ITEM.Name = "Munition"
ITEM.Description = "Wird benötigt um Waffen zu benutzen."
ITEM.Stackable = true
ITEM.DropStack = true
ITEM.Base = "base_darkrp"
ITEM.MaxStack = 1000
ITEM.UseSpeed = 1.5
ITEM.DropSpeed = 1.5

function ITEM:GetName()
	if SERVER then
		return self:GetData("Name", self.Name)
	else
		return self:GetData("Name", language.GetPhrase(self:GetData("AmmoType").."_ammo"))
	end
end

function ITEM:CanMerge(item)
	return self.Stackable and self:GetClass() == item:GetClass() and self:GetData("AmmoType") == item:GetData("AmmoType") and (self:GetMaxStack() >= (item:GetAmount() + self:GetAmount()))
end

function ITEM:CanPickup(ply, ent)
	if ent.amountGiven > self:GetMaxStack() then return false, "Das ist zu viel Munition auf einem Haufen!" end
end

function ITEM:SaveData(ent)
	self:SetModel(ent:GetModel())
	self:SetAmount(ent.amountGiven)	
	self:SetData("AmmoType", ent.ammoType)
end

function ITEM:LoadData(ent)
	ent:SetModel(self:GetModel())
	ent.amountGiven = self:GetAmount()	
	ent.ammoType = self:GetData("AmmoType")
end

function ITEM:Use(ply)
	ply:GiveAmmo(self:GetAmount(), self:GetData("AmmoType"))
	ply:EmitSound("items/ammo_pickup.wav")
	return true
end