ITEM.Name = "Essen"
ITEM.Description = "Regeneriert Energie.\n\nSättigung: %d"
ITEM.Model = "models/props_junk/watermelon01.mdl"
ITEM.Stackable = false
ITEM.Base = "base_darkrp"
ITEM.UseSpeed = 1
ITEM.DropSpeed = 1

function ITEM:GetName()
	return self:GetData("Name", self.Name)
end

function ITEM:GetDescription()
	return self:GetData("Description", string.format(self.Description, self:GetData("Nutrition")).."%")
end

function ITEM:CanPickup(ply, ent)
	if ent.FoodName == "Altes Wasser" then return false end
	return true
end

function ITEM:Use(ply)
	local energy = ply:getDarkRPVar("Energy") + self:GetData("Nutrition")
	ply:setSelfDarkRPVar("Energy", math.Clamp(energy, 0, 100))
	umsg.Start("AteFoodIcon", ply)
	umsg.End()

	local foodItem
	for _,v in pairs(FoodItems) do
		if v.model == self:GetModel() then
			foodItem = v
			break
		end
	end
	ply:EmitSound(foodItem and foodItem.sound or "cookingmod/eating.wav", 100, 100)
	return self:TakeOne()
end

function ITEM:SaveData(ent)
	self:SetData("Name", ent.foodItem and ent.foodItem.name)
	self:SetData("Owner", ent:Getowning_ent())
	self:SetData("Nutrition", ent.FoodEnergy)
	self:SetModel(ent:GetModel())
end

function ITEM:CanDrop(ply)
	local foodTable = {cmd = "buyfood", max = GAMEMODE.Config.maxfooditems}
	if ply:customEntityLimitReached(foodTable) then
		DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("limit", GAMEMODE.Config.chatCommandPrefix.."buyfood"))
		return false
	end
end

function ITEM:LoadData(ent, ply)
	ent:SetModel(self:GetModel())
	for _,v in pairs(FoodItems) do
		if v.model == self:GetModel() then
			ent.foodItem = v
			break
		end
	end
	if !ent.foodItem then
		SafeRemoveEntity(ent)
		return
	end
	ent:Setowning_ent(self:GetData("Owner"))
	ent.FoodEnergy = self:GetData("Nutrition")
	local foodTable = {cmd = "buyfood", max = GAMEMODE.Config.maxfooditems}
	ent.DarkRPItem = foodTable
	if IsValid(ply) then
		ent.SID = ply.SID
		ply:addCustomEntity(foodTable)
	end
end