ITEM.Name = "Shipment"
ITEM.Description = "Eine Kiste mit Inhalt.\n\nInhalt: %s"
ITEM.Model = "models/items/item_item_crate.mdl"
ITEM.Stackable = true
ITEM.DropStack = true
ITEM.Base = "base_darkrp"
ITEM.MaxStack = 3
ITEM.UseSpeed = 3
ITEM.DropSpeed = 3

function ITEM:Initialize()
	if !SERVER or !self:GetData("Class") then return end
	local shipment = CustomShipments[self:GetData("Contents")]
	if shipment and shipment.entity == self:GetData("class") then return end
	for k, v in ipairs(CustomShipments) do
		if v.entity == self:GetData("Class") then
			self:SetData("Contents", k)
			return
		end
	end
end

function ITEM:GetShipmentName()
	local shipment = CustomShipments[self:GetData("Contents")]
	if shipment then
		return shipment.name
	else
		return "Ungültig"
	end
end

function ITEM:GetName()
	return self:GetData("Name", self:GetShipmentName().."-"..self.Name)
end

function ITEM:GetDescription()
	return self:GetData("Description", string.format(self.Description, self:GetShipmentName()))
end

function ITEM:CanMerge(item)
	return self.Stackable and item.Stackable and self:GetClass() == item:GetClass() and self:GetData("Contents") == item:GetData("Contents") and (self:GetMaxStack() >= (item:GetAmount() + self:GetAmount()))
end

function ITEM:Merge(item)
	local self_Count = self:GetAmount()
	local ent_Count = item:GetAmount()
	local count = self_Count + ent_Count
	self:SetAmount(count)
	local wep_class = weapons.Get(self:GetData("Class"))
	local self_Ammo = self:GetData("Ammo") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local item_Ammo = item:GetData("Ammo") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local self_Clip1 = self:GetData("Clip1") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local item_Clip1 = item:GetData("Clip1") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local self_Clip2 = self:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
	local item_Clip2 = item:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
	self:SetData("Ammo", math.floor(((item_Ammo or 0) * ent_Count + (self_Ammo or 0) * self_Count) / count))
	self:SetData("Clip1", math.floor(((item_Clip1 or 0) * ent_Count + (self_Clip1 or 0) * self_Count) / count))
	if self:GetData("Clip2") or item:GetData("Clip2") then
		local self_Clip2 = self:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
		local item_Clip2 = item:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
		self:SetData("Clip2", math.floor(((item_Clip2 or 0) * ent_Count + (self_Clip2 or 0) * self_Count) / count))
	end
end

function ITEM:CanPickup(ply, ent)
	if ent.sparking then return false, "Dieses Shipment spawnt gerade eine Waffe!" end
	if ent.locked then return false, "Dieses Shipment spawnt gerade!" end
	if ent:Getcount() > self:GetMaxStack() then return false, "Es sind mehr als 3 Waffen in diesem Shipment!" end
	return true
end

function ITEM:SaveData(ent)
	self:SetData("Owner", ent:Getowning_ent())
	local contents = ent:Getcontents()
	self:SetData("Contents", contents)
	self:SetData("Amount", ent:Getcount())
	self:SetData("Class", CustomShipments[contents].entity)
	self:SetData("Ammo", ent.ammoadd)
	self:SetData("Clip1", ent.clip1)
	self:SetData("Clip2", ent.clip2)
end

function ITEM:LoadData(ent)
	ent:Setcontents(self:GetData("Contents"))
	ent:Setcount(self:GetData("Amount"))
	ent:Setowning_ent(self:GetData("Owner"))
	ent.ammoadd = self:GetData("Ammo")
	ent.clip1 = self:GetData("Clip1")
	ent.clip2 = self:GetData("Clip2")
end

function ITEM:Use(ply)
	local class = CustomShipments[self:GetData("Contents")].entity
	local weapon_exists = false
	local wep = ply:Give(class)
	if !IsValid(wep) then
		wep = ply:GetWeapon(class)
		weapon_exists = true
	end
	if IsValid(wep) then
		local default_clip = wep.Primary and wep.Primary.DefaultClip
		if self:GetData("Clip1") then
			if weapon_exists then
				ply:GiveAmmo(self:GetData("Clip1"), wep:GetPrimaryAmmoType(), true)
			else
				wep:SetClip1(self:GetData("Clip1"))
			end
		elseif default_clip then
			if weapon_exists then
				ply:GiveAmmo(default_clip, wep:GetPrimaryAmmoType(), true)
			else
				wep:SetClip1(default_clip)
			end
		end
		if self:GetData("Clip2") then
			if weapon_exists then
				ply:GiveAmmo(self:GetData("Clip2"), wep:GetSecondaryAmmoType(), true)
			else
				wep:SetClip2(self:GetData("Clip2"))
			end
		end
		if self:GetData("Ammo") then
			ply:GiveAmmo(self:GetData("Ammo"), wep:GetPrimaryAmmoType(), true)
		elseif default_clip then
			ply:GiveAmmo(default_clip, wep:GetPrimaryAmmoType(), true)
		end
		ply:SelectWeapon(class)
	end
	ply:EmitSound("items/ammo_pickup.wav")
	return self:TakeOne()
end