ITEM.Name = "Waffe"
ITEM.Description = ""
ITEM.Model = "models/weapons/w_pistol.mdl"
ITEM.Base = "base_darkrp"
ITEM.Stackable = true
ITEM.MaxStack = 3
ITEM.UseSpeed = 3
ITEM.DropSpeed = 3

function ITEM:GetWeaponClass(wep)
	return wep.GetWeaponClass and wep:GetWeaponClass() or wep.weaponclass
end

function ITEM:GetName()
	local name = self.Name
	local class = self:GetData("Class")
	local wep_class = weapons.Get(class)
	if wep_class then
		name = wep_class.PrintName or wep_class.ClassName
	else
		name = class
	end
	return name or "Ungültige Waffe"
end

function ITEM:GetDescription()
	local desc = self.Description
	local clip = 0
	local reserve = 0
	local wep_class = weapons.Get(self:GetData("Class"))
	if wep_class and wep_class.DrawAmmo then
		if wep_class.Primary and wep_class.Primary.ClipSize and wep_class.Primary.ClipSize >= 0 then
			if self:GetData("Clip1") then
				local clip1 = self:GetData("Clip1")
				local amount = self:GetAmount()
				clip = math.min(math.floor(clip1 / amount), clip1)
			end
			if self:GetData("Ammo") then
				local ammo = self:GetData("Ammo")
				local amount = self:GetAmount()
				reserve = math.min(math.floor(ammo / amount), ammo)
			end
		end
	end
	return self:GetData("Description", "Munition: "..clip.."\nReserve: "..reserve)
end

function ITEM:CanPickup(ply, ent)
	if ent:Getamount() > self:GetMaxStack() then
		return false, "Du kannst nur 3 Waffen gleichzeitig aufheben!"
	end
	return true
end

function ITEM:CanMerge(item)
	return self.Stackable and item.Stackable and item:GetClass() == self:GetClass() and item:GetData("Class") == self:GetData("Class") and self:GetMaxStack() >= self:GetAmount() + item:GetAmount()
end

function ITEM:Merge(item)
	local self_Count = self:GetAmount()
	local ent_Count = item:GetAmount()
	local count = self_Count + ent_Count
	self:SetAmount(count)
	local wep_class = weapons.Get(self:GetData("Class"))
	local self_Ammo = self:GetData("Ammo") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local item_Ammo = item:GetData("Ammo") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local self_Clip1 = self:GetData("Clip1") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	local item_Clip1 = item:GetData("Clip1") or wep_class and wep_class.Primary and wep_class.Primary.DefaultClip
	self:SetData("Ammo", math.floor(self_Ammo + item_Ammo))
	self:SetData("Clip1", math.floor(self_Clip1 + item_Clip1))
	if self:GetData("Clip2") or item:GetData("Clip2") then
		local self_Clip2 = self:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
		local item_Clip2 = item:GetData("Clip2") or wep_class and wep_class.Secondary and wep_class.Secondary.DefaultClip
		self:SetData("Clip2", math.floor(self_Clip2 + item_Clip2))
	end
end

function ITEM:Split(amount)
	local s_amount = self:GetData("Amount")
	local s_clip1 = self:GetData("Clip1")
	local s_clip2 = self:GetData("Clip2")
	local s_ammo = self:GetData("Ammo")
	self:SetAmount(self:GetAmount() - amount)
	local item = self:Copy()
	item:SetAmount(amount)
	if s_clip1 then
		self:SetData("Clip1", math.min(math.floor(s_clip1 / s_amount * self:GetAmount()), s_clip1))
		item:SetData("Clip1", math.min(math.floor(s_clip1 / s_amount * amount), s_clip1))
	end
	if s_clip2 then
		self:SetData("Clip2", math.min(math.floor(s_clip2 / s_amount * self:GetAmount()), s_clip2))
		item:SetData("Clip2", math.min(math.floor(s_clip2 / s_amount * amount), s_clip2))
	end
	if s_ammo then
		self:SetData("Ammo", math.min(math.floor(s_ammo / s_amount * self:GetAmount()), s_ammo))
		item:SetData("Ammo", math.min(math.floor(s_ammo / s_amount * amount), s_ammo))
	end
	return item
end

function ITEM:SaveData(ent)
	self:SetData("Class", self:GetWeaponClass(ent))
	self:SetData("Amount", ent:Getamount())
	self:SetData("Model", ent:GetModel())
	if ent.clip1 then
		self:SetData("Clip1", ent.clip1 * ent:Getamount())
	end
	if ent.clip2 then
		self:SetData("Clip2", ent.clip2 * ent:Getamount())
	end
	if ent.ammoadd then
		self:SetData("Ammo", ent.ammoadd * ent:Getamount())
	end
end

function ITEM:LoadData(ent)
	local model = self:GetData("Model")
	if util.IsValidModel(model) then
		ent:SetModel(model)
	else
		ent:SetModel("models/weapons/w_rif_ak47.mdl")
	end
	ent:Setamount(1)
	if ent.GetWeaponClass then
		ent:SetWeaponClass(self:GetData("Class"))
	else
		ent.weaponclass = self:GetData("Class")
	end
	local clip1 = self:GetData("Clip1")
	local clip2 = self:GetData("Clip2")
	local ammo = self:GetData("Ammo")
	if clip1 then
		ent.clip1 = math.min(math.floor(clip1 / self:GetAmount()), clip1)
		self:SetData("Clip1", clip1 - ent.clip1)
	end
	if clip2 then
		ent.clip2 =  math.min(math.floor(clip2 / self:GetAmount()), clip2)
		self:SetData("Clip2", clip2 - ent.clip2)
	end
	if ammo then
		ent.ammoadd =  math.min(math.floor(ammo / self:GetAmount()), ammo)
		self:SetData("Ammo", ammo - ent.ammoadd)
	end
	function ent:Initialize()
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		self:SetUseType(SIMPLE_USE)
		local phys = self:GetPhysicsObject()
		if phys:IsValid() then
			phys:Wake()
		end
	end
end

function ITEM:Use(ply)
	local class = self:GetData("Class")
	local weapon_exists = false
	local wep = ply:Give(class)
	if !IsValid(wep) then
		wep = ply:GetWeapon(class)
		weapon_exists = true
	end
	if IsValid(wep) then
		if self:GetData("Clip1") then
			local clip1 = self:GetData("Clip1")
			local ammo = math.min(math.floor(clip1 / self:GetAmount()), clip1)
			if weapon_exists then
				ply:GiveAmmo(ammo, wep:GetPrimaryAmmoType(), true)
			else
				wep:SetClip1(ammo)
			end
			self:SetData("Clip1", clip1 - ammo)
		end
		if self:GetData("Clip2") then
			local clip2 = self:GetData("Clip2")
			local ammo = math.min(math.floor(clip2 / self:GetAmount()), clip2)
			if weapon_exists then
				ply:GiveAmmo(ammo, wep:GetSecondaryAmmoType(), true)
			else
				wep:SetClip2(ammo)
			end
			self:SetData("Clip2", clip2 - ammo)
		end
		if self:GetData("Ammo") then
			local reserve = self:GetData("Ammo")
			local ammo = math.min(math.floor(reserve / self:GetAmount()), reserve)
			ply:GiveAmmo(ammo, wep:GetPrimaryAmmoType(), true)
			self:SetData("Ammo", reserve - ammo)
		end
		ply:SelectWeapon(class)
	end
	ply:EmitSound("items/ammo_pickup.wav")
	return self:TakeOne()
end