itemstore.config = {}

include("config.lua")

include("language.lua")
include("gamemodes.lua")
include("items.lua")
include("containers.lua")
include("admin.lua")

if itemstore.config.PickupProperty then
	local dist = itemstore.config.PickupDistance * itemstore.config.PickupDistance
	properties.Add("ItemStorePickup", {
		MenuLabel = "Gegenstand aufheben",
		MenuIcon = "icon16/arrow_in.png",
		Order = 100,
		Filter = function(self, ent, ply)
			return ply:Alive() and ply:EyePos():DistToSqr(ent:GetPos()) < dist and itemstore.items.Pickups[ent:GetClass()] and !itemstore.config.DisabledItems[itemstore.items.Pickups[ent:GetClass()]] and itemstore.Item(itemstore.items.Pickups[ent:GetClass()])
		end,
		Action = function(self, ent)
			self:MsgStart()
				net.WriteEntity(ent)
			self:MsgEnd()
		end,
		Receive = function(self, length, ply)
			local ent = net.ReadEntity()
			if IsValid(ply) and IsValid(ent) and ply:Alive() and ply:EyePos():DistToSqr(ent:GetPos()) < dist and itemstore.items.Pickups[ent:GetClass()] and !itemstore.config.DisabledItems[itemstore.items.Pickups[ent:GetClass()]] and itemstore.Item(itemstore.items.Pickups[ent:GetClass()]) then
				ply:PickupItem(ent)
			end
		end
	})
end

local reg = debug.getregistry()
local GetTable = reg.Entity.GetTable
local GetWalkSpeed = reg.Player.GetWalkSpeed
local function SpeedModifier(ply, mv)
	local speed = GetTable(ply).ItemStore_SpeedModifier
	if speed and speed != 1 then
		mv:SetMaxClientSpeed(GetWalkSpeed(ply) * speed)
	end
end

hook.Add("SetupMove", "ItemStore_SpeedModifier", SpeedModifier)