local PANEL = {}

function PANEL:Init()
	self:SetTitle(itemstore.Translate("admin_title"))
	self:SetSkin("itemstore")
	self.Scroll = vgui.Create("DScrollPanel", self)
	self.Scroll:Dock(FILL)
	self.List = vgui.Create("DListLayout", self.Scroll)
	self.List:Dock(FILL)
	local b = self.List:Add("DButton")
	b:SetText("SteamID überprüfen")
	b:DockMargin(0, 0, 0, 2)
	function b.DoClick()
		local menu = DermaMenu()
		menu:AddOption("Inventar", function()
			Derma_StringRequest("SteamID eingeben", "Bitte gebe die SteamID des Spielers an, von dem du das Inventar einsehen willst.", "", function(value)
				value = string.upper(string.Trim(value))
				if value:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
					net.Start("ItemStore_AdminOfflineInventory")
						net.WriteString(value)
					net.SendToServer()
				else
					Derma_Message("Du musst ein gültiges SteamID-Format angeben!", "Keine gültige SteamID angegeben!", "Okay")
				end
			end, nil, "Überprüfen", "Abbrechen")
		end)
		menu:AddOption("Lager", function()
			Derma_StringRequest("SteamID eingeben", "Bitte gebe die SteamID des Spielers an, von dem du das Lager einsehen willst.", "", function(value)
				value = string.upper(string.Trim(value))
				if value:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
					net.Start("ItemStore_AdminOfflineBank")
						net.WriteString(value)
					net.SendToServer()
				else
					Derma_Message("Du musst ein gültiges SteamID-Format angeben!", "Keine gültige SteamID angegeben!", "Okay")
				end
			end, nil, "Überprüfen", "Abbrechen")
		end)
		menu:Open()
	end
	local b = self.List:Add("DButton")
	b:SetText("Spieler zurücksetzen")
	b:DockMargin(0, 0, 0, 2)
	function b.DoClick()
		local menu = DermaMenu()
		menu:AddOption("Nach SteamID suchen", function()
			Derma_StringRequest("SteamID zurücksetzen", "Bitte gebe die SteamID des Spielers an, dessen Inventar und Bank zurückgesetzt werden sollen.", "", function(value)
				value = string.upper(string.Trim(value))
				if value:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
					net.Start("ItemStore_ResetSteamID")
						net.WriteString(value)
					net.SendToServer()
				else
					Derma_Message("Du musst ein gültiges SteamID-Format angeben!", "Keine gültige SteamID angegeben!", "Okay")
				end
			end, nil, "Zurücksetzen", "Abbrechen")
		end)
		local players = player.GetAll()
		table.sort(players, function(a, b) return a:Name() < b:Name() end)
		for _, ply in ipairs(players) do
			menu:AddOption(ply:Name(), function()
				if !IsValid(ply) then return end
				Derma_Query("Möchtest du das Inventar und die Bank dieses Spielers wirklich zurücksetzen?", "Spieler zurücksetzen", "Fortfahren", function()
					if !IsValid(ply) then return end
					net.Start("ItemStore_ResetPlayer")
						net.WriteEntity(ply)
					net.SendToServer()
				end, "Abbrechen")
			end)
		end
		menu:Open()
	end
	local players = player.GetAll()
	table.sort(players, function(a, b) return a:Name() < b:Name() end)
	for _, ply in ipairs(players) do
		local b = self.List:Add("DButton")
		b:SetText(ply:Name())
		b:DockMargin(0, 0, 0, 2)
		function b.DoClick()
			local menu = DermaMenu()
			menu:AddOption(itemstore.Translate("inventory"), function()
				if !IsValid(ply) then return end
				net.Start("ItemStore_AdminInventory")
				 	net.WriteEntity(ply)
				net.SendToServer()
			end)
			menu:AddOption(itemstore.Translate("bank"), function()
				if !IsValid(ply) then return end
				net.Start("ItemStore_AdminBank")
					net.WriteEntity(ply)
				net.SendToServer()
			end)
			menu:Open()
		end
	end
end

vgui.Register("ItemStoreAdmin", PANEL, "DFrame")