local PANEL = {}

surface.CreateFont("ItemStore_Close", {font = use_font, size = 13, weight = 1000})

function PANEL:Init()
	self:ShowCloseButton(false)
	self:SetSkin("itemstore")
	self.CloseBtn = vgui.Create("DButton", self)
	self.CloseBtn:SetSize(50, 18)
	self.CloseBtn:SetPos(self:GetWide() - 52, 2)
	self.CloseBtn:SetText("X")
	self.CloseBtn:SetFont("ItemStore_Close")
	self.CloseBtn:SetTextColor(color_white)
	self.CloseBtn.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(0, 0, 0, w, h, col)
	end
	self.CloseBtn.DoClick = function()
		self:Remove()
	end
	self.Container = vgui.Create("ItemStoreContainer", self)
	self.Container:SizeToContents()
end

function PANEL:RemoveCloseButton()
	if IsValid(self.CloseBtn) then
		self.CloseBtn:Remove()
	end
end

function PANEL:PerformLayout()
	self:SetSize(self.Container:GetWide() + 10, self.Container:GetTall() + 32)
	if IsValid(self.CloseBtn) then
		self.CloseBtn:SetPos(self:GetWide() - 52, 2)
	end
	self.Container:SetPos(5, 27)
	self.BaseClass.PerformLayout(self)
end

function PANEL:Refresh()
	self.Container:Refresh()
end

function PANEL:SetContainerID(id)
	self.Container:SetContainerID(id)
end

function PANEL:GetContainerID()
	return self.Container:GetContainerID()
end

vgui.Register("ItemStoreContainerWindow", PANEL, "DFrame")