include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("lplates_headinfo", {font = use_font, size = 30, weight = 1000, blursize = 0, scanlines = 0})

surface.CreateFont("lplates_small_preview", {font = use_font, size = 18, antialias = true})
surface.CreateFont("lplates_big_preview", {font = use_font, size = 64, antialias = true})

surface.CreateFont("lplates_close", {
	font = use_font,
	size = 13,
	weight = 1000
})

local platemat = Material("dan/plate.png")

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	dist = local_ply:EyePos():DistToSqr(self:GetPos())
	if dist > 100000 then return end
	local ang = self:GetAngles()	
	local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2)))
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.15)
		draw.SimpleTextOutlined(self.PrintName, "lplates_headinfo", 0, -50, Color(150, 0, 100, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	cam.End3D2D()
end

local dmv_msg = string.format([[Willkommen bei der Kennzeichen-Modifkation.

Für ein modifiziertes Kennzeichen, trage hier eine 
Kombination aus Zahlen und/oder Buchstaben ein.

Das Ganze kostet dich dann $%s.]], string.Comma(LicensePlates.CustomPlateCost))

local dmv_frame
net.Receive("npc_dmv_openmenu", function(len)
	local npc = net.ReadEntity()
	if !IsValid(npc) or IsValid(dmv_frame) then return end
	dmv_frame = vgui.Create("DFrame")
	dmv_frame:SetTitle("Kennzeichen-Modifikation")
	dmv_frame:SetSize(275, 300)
	dmv_frame:Center()
	dmv_frame:ShowCloseButton(false)
	dmv_frame:MakePopup()
	dmv_frame:ParentToHUD()
	dmv_frame.OldPaint = dmv_frame.Paint
	dmv_frame.Paint = MG_Theme.Theme.Frame.Paint
	dmv_frame.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local ply = LocalPlayer()
	dmv_frame.Think = function(slf)
		if !IsValid(npc) or !ply:Alive() or ply:GetPos():DistToSqr(npc:GetPos()) > 62500 then
			dmv_frame:Close()
		end
	end
	local Close = vgui.Create("DButton", dmv_frame)
	Close:SetSize(50, 20)
	Close:SetPos(dmv_frame:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("MG_Theme_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(dmv_frame, w, h)
		local col
		if dmv_frame:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		dmv_frame:Remove()
	end
	local lblinfo = vgui.Create("DLabel", dmv_frame)
	lblinfo:SetPos(10, 30)
	lblinfo:SetText(dmv_msg)
	lblinfo:SizeToContents()
	local lentry = vgui.Create("DTextEntry", dmv_frame)
	MG_Theme.Theme.TextEntry.Setup(lentry)
	lentry:SetPos(8, lblinfo.y + lblinfo:GetTall() + 7)
	lentry:SetWide(dmv_frame:GetWide() - 16)
	local txt
	function lentry:OnTextChanged()
		txt = self:GetText()
		txt = string.gsub(txt, "[^%a%d-]", "")
		txt = string.gsub(txt, "%l", function(m)
			return string.upper(m)
		end)
		txt = string.Left(txt, 7)
		self:SetText(txt)
		self:SetCaretPos(#txt)
	end
	local licensePreview = vgui.Create("DPanel", dmv_frame)
	licensePreview:SetPos(8, lentry.y + lentry:GetTall() + 5)
	licensePreview:SetWide(dmv_frame:GetWide() - 16)
	licensePreview:SetTall(128)
	licensePreview.Paint = function(self, w, h)
		surface.SetMaterial(platemat)
		surface.SetDrawColor(LicensePlates.PlateColor)
		surface.DrawTexturedRect(0, 0, 256, 128)

		draw.SimpleText(LicensePlates.PlateTextTop, "lplates_small_preview", 256 * 0.5, 17, LicensePlates.PlateTextTopColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText(LicensePlates.PlateTextBottom, "lplates_small_preview", 256 * 0.5, 110, LicensePlates.PlateTextBottomColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		
		draw.SimpleText(txt or "", "lplates_big_preview", 256 * 0.5, 128 * 0.5, LicensePlates.PlateTextSerialColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		
		surface.SetDrawColor(LicensePlates.PlateDividerColor)
		surface.DrawRect(5, 30, 248, 3)
		surface.DrawRect(5, 98, 248, 3)
		//surface.DrawRect(-256 / 2 + 8, 128 / 3.7, 256 - 16, 6)
	end
	local btnreg = vgui.Create("DButton", dmv_frame)
	btnreg:SetText("Kennzeichen registrieren")
	MG_Theme.Theme.Button.SetupTheme(btnreg)
	btnreg:SetPos(dmv_frame:GetWide() / 2, licensePreview.y + licensePreview:GetTall() + 5)
	btnreg:SetWide((dmv_frame:GetWide() / 2) - 8)
	local btnmin = vgui.Create("DLabel", dmv_frame)
	btnmin:SetText("Mindestens 3 Buchstaben!")
	btnmin:SetTextColor(Color(255, 0, 0, 255))
	btnmin:SetPos(10, licensePreview.y + licensePreview:GetTall() + 6)
	btnmin:SetWide(dmv_frame:GetWide() / 2)
	btnmin:SetVisible(false)
	function btnreg:DoClick()
		local txt = lentry:GetText()
		if #txt < 3 then surface.PlaySound("buttons/button10.wav") btnmin:SetVisible(true) return end
		surface.PlaySound("ui/buttonclick.wav")
		dmv_frame:Close()
		local fr = vgui.Create("DFrame")
		fr:SetTitle("Kauf bestätigen")
		fr:SetTall(78)
		fr:MakePopup()
		fr:SetBackgroundBlur(true)
		fr.OldPaint = fr.Paint
		fr.Paint = MG_Theme.Theme.Frame.Paint
		fr.PaintOver = MG_Theme.Theme.Frame.PaintOver
		local lblver = vgui.Create("DLabel", fr)
		lblver:SetText(string.format("Bist du dir sicher das du diese Kennzeichen-Modifikation für $%s kaufen möchtest?", string.Comma(LicensePlates.CustomPlateCost)))
		lblver:SizeToContents()
		lblver:SetPos(8, 30)
		fr:SetWide(lblver:GetWide() + 16)
		fr:Center()
		local yoff = lblver.y + lblver:GetTall() + 5
		local btnaccept = vgui.Create("DButton", fr)
		btnaccept:SetText("Akzeptieren")
		MG_Theme.Theme.Button.SetupTheme(btnaccept)
		btnaccept:SetWide((fr:GetWide() / 3) * 2 - 9)
		btnaccept:SetPos(8, yoff)
		function btnaccept:DoClick()
			surface.PlaySound("ui/buttonclick.wav")
			if !IsValid(npc) then return end
			net.Start("npc_dmv_buyplate")
				net.WriteEntity(npc)
				net.WriteString(txt)
			net.SendToServer()
			fr:Close()
		end
		local btncancel = vgui.Create("DButton", fr)
		btncancel:SetText("Abbrechen")
		MG_Theme.Theme.Button.SetupTheme(btncancel)
		btncancel:SetWide((fr:GetWide() / 3) - 8)
		btncancel:SetPos(((fr:GetWide() / 3) * 2) + 1, yoff)
		function btncancel:DoClick()
			surface.PlaySound("ui/buttonclick.wav")
			fr:Close()
		end
	end
end)