local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("lplates_big", {font = use_font, size = 128, antialias = true})
surface.CreateFont("lplates_small", {font = use_font, size = 36, antialias = true})

local pwidth, pheight = 512, 256
local swidth, sheight = 24, 24

local platemat = Material("dan/plate.png")
local screwmat = Material("dan/screw.png")

local function DrawScrew(x, y)
	surface.DrawTexturedRect(x - (swidth / 2), y - (sheight / 2), swidth, sheight)
end

local LicenseVehicles = {}
hook.Add("NetworkEntityCreated", "cl_lplates_initplates", function(ent)
	if ent:IsVehicle() then
		LicenseVehicles[ent:EntIndex()] = ent
	end
end)

hook.Add("EntityRemoved", "cl_lplates_removeplates", function(ent)
	LicenseVehicles[ent:EntIndex()] = nil
end)

local dist = LicensePlates.DistanceFade * LicensePlates.DistanceFade
local local_ply
local function DrawPlates()
	local_ply = local_ply or LocalPlayer()
	for _, veh in pairs(LicenseVehicles) do
		if veh:IsDormant() or veh:GetNoDraw() or veh:GetPos():DistToSqr(local_ply:EyePos()) > dist then continue end
		local vname = veh:GetVehicleClass()
		local plates = LicensePlates.GetVehiclePlates(vname)
		if !plates then continue end
		local pserial = veh:GetNW2String("plate_serial")
		if pserial == "" then continue end
		render.SuppressEngineLighting(true)
		for _, pinfo in pairs(plates) do
			cam.Start3D2D(veh:LocalToWorld(pinfo.pos), veh:LocalToWorldAngles(pinfo.ang), pinfo.scale)
				surface.SetMaterial(platemat)
				surface.SetDrawColor(LicensePlates.PlateColor)
				surface.DrawTexturedRect(-pwidth / 2 - 6, -pheight / 2 - 6, pwidth + 12, pheight + 12)
				if LicensePlates.DrawTextShadow then
					draw.SimpleText(pserial, "lplates_big",-4, 4, LicensePlates.PlateTextSerialShadowColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
					draw.SimpleText(LicensePlates.PlateTextTop, "lplates_small", -1, (-pheight / 2.6) + 1, LicensePlates.PlateTextTopShadowColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
					draw.SimpleText(LicensePlates.PlateTextBottom, "lplates_small", -1, (pheight / 2.7) + 1, LicensePlates.PlateTextBottomShadowColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				end
				draw.SimpleText(pserial, "lplates_big", 0, 0, LicensePlates.PlateTextSerialColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw.SimpleText(LicensePlates.PlateTextTop, "lplates_small", 0, - pheight / 2.6, LicensePlates.PlateTextTopColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw.SimpleText(LicensePlates.PlateTextBottom, "lplates_small", 0, pheight / 2.7, LicensePlates.PlateTextBottomColor, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				surface.SetDrawColor(LicensePlates.PlateDividerColor)
				surface.DrawRect(-pwidth / 2 + 8, -pheight / 3.7, pwidth - 16, 6)
				surface.DrawRect(-pwidth / 2 + 8, pheight / 3.7, pwidth - 16, 6)
				if LicensePlates.DrawScrews then
					local xoff, yoff = pwidth / 3.275, pheight / 2.55
					surface.SetMaterial(screwmat)
					surface.SetDrawColor(255, 255, 255)
					DrawScrew(xoff, yoff)
					DrawScrew(-xoff, yoff)
					DrawScrew(xoff, -yoff)
					DrawScrew(-xoff, -yoff)
				end
			cam.End3D2D()
		end
		render.SuppressEngineLighting(false)
	end
end
hook.Add("PostDrawTranslucentRenderables", "cl_lplates_drawplates", DrawPlates)