zmlab = zmlab or {}
zmlab.f = zmlab.f or {}

local IgnoreFileTable = {}
function zmlab.f.PreLoadFile(fdir, afile, client)
	IgnoreFileTable[afile] = true
	zmlab.f.LoadFile(fdir, afile, client)
end

function zmlab.f.LoadFile(fdir, afile, client)

	if SERVER then
		AddCSLuaFile(fdir .. afile)
	end

	if client and SERVER then return end

	include(fdir .. afile)
end

function zmlab.f.LoadAllFiles(fdir, client)
	local files, dirs = file.Find(fdir .. "*", "LUA")

	for _, afile in ipairs(files) do
		if string.match(afile, ".lua") and !IgnoreFileTable[afile] then
			zmlab.f.LoadFile(fdir, afile, client)
		end
	end

	for _, dir in ipairs(dirs) do
		zmlab.f.LoadAllFiles(fdir .. dir .. "/", client)
	end
end

// Initializes the Script
function zmlab.f.Initialize()
	zmlab.f.PreLoadFile("zmlab/sh/","zmlab_config.lua")
	zmlab.f.LoadAllFiles("zmlab_languages/")
	zmlab.f.LoadAllFiles("zmlab/sh/")
	if SERVER then
		zmlab.f.LoadAllFiles("zmlab/sv/")
	end

	zmlab.f.LoadAllFiles("zmlab/cl/", true)
end

if SERVER then
	hook.Add("PostGamemodeLoaded", "a_zmlab_Initialize_sv", function()
		zmlab.f.Initialize()
	end)
else
	// This needs to be called instantly on client since client settings wont work otherwhise
	zmlab.f.PreLoadFile("zmlab/sh/","zmlab_materials.lua")
	zmlab.f.PreLoadFile("zmlab/cl/","zmlab_fonts.lua")
	zmlab.f.PreLoadFile("zmlab/cl/","zmlab_player_cl.lua")

	hook.Add("InitPostEntity", "a_zmlab_Initialize_cl", function()
		zmlab.f.Initialize()
	end)
end

if GAMEMODE then
	zmlab.f.Initialize()
end