function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 25 do
		local p = self.Emitter:Add("effects/yellowflare", self.Start)
		if p then
			p:SetDieTime(math.Rand(2, 3))
			p:SetStartAlpha(255)
			p:SetStartSize(math.Rand(1, 2))
			p:SetEndSize(0)
			p:SetRoll(0)
			p:SetVelocity(Vector(math.random(-75, 75), math.random(-75, 75), math.random(60, 100)))
			p:SetGravity(Vector(0, 0, -200))
			p:SetCollide(false)
			p:SetStartLength(0.1)
			p:SetEndLength(0.2)
			p:SetVelocityScale(true)
		end
	end
	for i = 1, 5 do
		local c = self.Emitter:Add("particle/particle_composite", self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(50)
			c:SetEndAlpha(0)
			c:SetStartSize(10)
			c:SetEndSize(25)
			c:SetRoll(math.Rand(150, 360))
			c:SetRollDelta(math.Rand(-1, 1))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-60, 60), math.random(-60, 60), math.random(0, 60)))
			c:SetGravity(Vector(0, 0, -100))
		end
	end
	for i = 1, 20 do
		local c = self.Emitter:Add("particle/smokesprites_000"..math.random(1,9), self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(35)
			c:SetEndAlpha(0)
			c:SetStartSize(15)
			c:SetEndSize(30)
			c:SetRoll(math.Rand(-40, 40))
			c:SetRollDelta(math.Rand(-1, 1))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-50, 50), math.random(-50, 50), math.random(0, 75)))
			c:SetGravity(Vector(0, 0, -50))
		end
	end
	for i = 1, 50 do
		local w = self.Emitter:Add("effects/fleck_tile"..math.random(1,2), self.Start + Vector(math.Rand(-3, 3), math.Rand(-3, 3), math.Rand(0, 2)))
		if w then
			w:SetVelocity(Vector(math.Rand(-100, 100), math.Rand(-100, 100), math.Rand(50, 150)))
			w:SetDieTime(math.Rand(2, 3))
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(math.Rand(1, 1.5))
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-30, 30))
			w:SetAirResistance(70)
			w:SetGravity(Vector(0, 0, -400))
			w:SetCollide(true)
			w:SetBounce(0.6)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end