local mat = CreateMaterial("zmlab_meth", "UnlitGeneric", {
	["$basetexture"] = "sprites/light_glow02",
	["$additive"] = 1,
	["$translucent"] = 1,
	["$vertexcolor"] = 1,
	["$vertexalpha"] = 1,
})

function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 50 do
		local p = self.Emitter:Add("!zmlab_meth", self.Start + Vector(math.Rand(-1, 1), math.Rand(-1, 1), math.Rand(0, 1)))
		if p then
			p:SetVelocity(Vector(math.Rand(-25, 25), math.Rand(-25, 25), math.Rand(0, 75)))
			p:SetDieTime(math.Rand(2, 3))
			p:SetStartAlpha(255)
			p:SetEndAlpha(0)
			p:SetStartSize(math.Rand(3, 5))
			p:SetEndSize(0)
			p:SetRoll(math.Rand(0, 360))
			p:SetRollDelta(math.Rand(-15, 15))
			p:SetAirResistance(50)
			p:SetGravity(Vector(0, 0, -200))
			p:SetCollide(true)
			p:SetBounce(0.6)
			p:SetColor(100, 100, 255)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end