ENT.Type = "anim"
ENT.Base = "base_anim"
ENT.AutomaticFrameAdvance = true
ENT.RenderGroup = RENDERGROUP_BOTH
ENT.Spawnable = true
ENT.PrintName = "Methlabor"
ENT.Category = "Meth-Herstellung"
ENT.Model = Model("models/zerochain/zmlab/zmlab_combiner.mdl")

function ENT:SetupDataTables()
	self:NetworkVar("Entity", 0, "owning_ent")
	self:NetworkVar("Int", 0, "Aluminium")
	self:NetworkVar("Int", 1, "Methylamin")
	self:NetworkVar("Int", 2, "Stage")
	self:NetworkVar("Int", 3, "NeedAluminium")
	self:NetworkVar("Int", 4, "NeedMethylamin")
	self:NetworkVar("Bool", 0, "HasFilter")
	self:NetworkVar("Bool", 1, "HasTray")
	self:NetworkVar("Bool", 2, "IsBusy")
	self:NetworkVar("Bool", 3, "IsBeeingScraped")
	self:NetworkVar("Bool", 4, "IsScraped")
	self:NetworkVar("Float", 0, "StartProcessingTime")
	self:NetworkVar("Float", 1, "MaxProcessingTime")
	self:NetworkVar("Float", 2, "MethSludge")
	self:NetworkVar("Float", 3, "MaxMethSludge")
	self:NetworkVar("Float", 4, "CleaningProgress")
	self:NetworkVar("Float", 5, "ScrapedIn")

	if SERVER then
		self:SetAluminium(0)
		self:SetMethylamin(0)
		self:SetStage(1)
		self:SetNeedAluminium(0)
		self:SetNeedMethylamin(0)

		self:SetHasFilter(false)
		self:SetHasTray(false)
		self:SetIsBusy(false)

		self:SetStartProcessingTime(0)
		self:SetMaxProcessingTime(0)
		self:SetMethSludge(0)
		self:SetMaxMethSludge(0)
		self:SetCleaningProgress(0)
	end
end

function ENT:PhysgunPickup(ply)
	return ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply:IsAdmin()
end