include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_filtermenu", {font = use_font, size = 15, weight = 800, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("mg_filtermenu2", {font = use_font, size = 32, weight = 600, blursize = 0, antialias = true, shadow = false})

surface.CreateFont("mg_entfont", {font = use_font, size = 35, weight = 1000, blursize = 0, antialias = true, shadow = false})

local base
local function filtermenu()
	local ent = net.ReadEntity()
	if !IsValid(ent) or IsValid(base) then return end
	base = vgui.Create("DFrame")
	base:SetSize(200, 70)
	base:Center()
	base:SetTitle("")
	base:MakePopup()
	base:ShowCloseButton(false)
	base:SetDraggable(false)
	base:ParentToHUD()
	base.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, Color(70, 76, 60))
		draw.SimpleText("Filter", "mg_filtermenu", 5, 5, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP)
	end
	local ply = LocalPlayer()
	local pressed_E = true
	base.Think = function()
		if !input.IsKeyDown(KEY_E) then
			pressed_E = false
		elseif !pressed_E then
			base:Remove()
		end
		if !IsValid(ent) or ent:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(ent:GetPos()) > 36000 then
			base:Remove()
		end
	end

	local closebttn = vgui.Create("DButton", base)
	closebttn:SetText("")
	closebttn:SetPos(150, 0)
	closebttn:SetSize(50, 20)
	closebttn.Paint = function(self, w, h)
		if self:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, Color(192, 57, 43))
		else
			draw.RoundedBox(0, 0, 0, w, h, Color(45, 45, 45))
		end
		draw.SimpleText("X", "mg_filtermenu", w / 2, h / 2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	closebttn.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		base:Close()
	end

	local bttn1 = vgui.Create("DButton", base)
	bttn1:Dock(FILL)
	bttn1:SetText("")
	bttn1.Paint = function(self, w, h)
		if !IsValid(ent) then return end
		if self:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, Color(35, 35, 35))
		else
			draw.RoundedBox(0, 0, 0, w, h, Color(45, 45, 45))
		end
		draw.SimpleText("Reparieren ($"..string.Comma(ent:Getprice())..")", "mg_filtermenu", w / 2, h / 2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	bttn1.DoClick = function()
		base:Close()
		surface.PlaySound("ui/buttonclick.wav")
		if !IsValid(ent) then return end
		net.Start("mg_meth_net_openfiltermenu")
			net.WriteEntity(ent)
		net.SendToServer()
	end
end

net.Receive("mg_meth_net_openfiltermenu", filtermenu)

local localply
local cam_Start3D2D, cam_End3D2D, draw_SimpleTextOutlined = cam.Start3D2D, cam.End3D2D, draw.SimpleTextOutlined
local vector_1 = Vector(0, 0, 1)
function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	localply = localply or LocalPlayer()
	if localply:GetPos():DistToSqr(self:GetPos()) > 40000 then return end
	if IsValid(self:GetParent()) then return end
	local owner = zmlab.f.GetOwner(self)
	local pname = owner and owner:Nick() or "Niemand"
	local ang = self:GetAngles()	
	local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2) * 2))
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	cam_Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
		draw_SimpleTextOutlined(self.PrintName, "mg_entfont", 0, -100, team.GetColor(zmlab.config.cookjob), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("Besitzer: "..pname, "mg_entfont2", 0, -70, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("Zum Montieren, Methlabor berühren.", "mg_entfont2", 0, -40, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("Zustand: "..math.Round(self:GetFilterHealth() / zmlab.config.Filter.Health * 100, 1).."%", "mg_entfont2", 0, -10, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	cam_End3D2D()
end

function ENT:Initialize()
	self.LastCombiner = NULL
	self.LastCombiner_Stage = -1
	self.LastHealth = -1
end

local localPly
function ENT:Think()
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end

	localPly = localPly or LocalPlayer()

	if zmlab.f.InDistance(localPly:EyePos(), self:GetPos(), 600) and !self:GetNoDraw() then

		// Attach sounds
		local curCombiner = dt.CombinerEnt
		if curCombiner != tb.LastCombiner then
			tb.LastCombiner = curCombiner

			if IsValid(tb.LastCombiner) then
				self:EmitSound("filter_attach")
			else
				self:EmitSound("filter_dettach")
			end
		end

		// Animation
		if IsValid(tb.LastCombiner) then
			local combinerStage = tb.LastCombiner:GetStage()
			if combinerStage != tb.LastCombiner_Stage then

				if combinerStage == 5 then
					zmlab.f.ClientAnim(self, "run", 1)
				else
					zmlab.f.ClientAnim(self, "idle", 1)
				end

				self.LastCombiner_Stage = combinerStage
			end
		else
			zmlab.f.ClientAnim(self, "idle", 1)
			tb.LastCombiner_Stage = -1
		end

		if zmlab.config.Filter.Health > 0 then
			// Health Skins
			local health = dt.FilterHealth
			if tb.LastHealth ~= health then

				if health <= 0 then
					self:EmitSound("filter_break")
				elseif health < zmlab.config.Filter.Health * 0.4 then
					self:SetSkin(2)
				elseif health < zmlab.config.Filter.Health * 0.75 then
					self:SetSkin(1)
				else
					self:SetSkin(0)
				end

				tb.LastHealth = health
			end
		end
	else
		tb.LastCombiner_Stage = -1
		tb.LastHealth = -1
	end

	self:SetNextClientThink(CurTime())
	return true
end
