include("shared.lua")

local localply

local labcolors = {
	Color(47, 54, 64), -- Main background
	Color(27, 156, 252), -- On
	Color(87, 96, 111), -- Off
	Color(53, 59, 72), -- Help background & progress background
	Color(0, 151, 230), -- Progress fill
	Color(251, 197, 49), -- Danger filter
	Color(65, 65, 65),
	Color(231, 76, 60),
	Color(45, 45, 45),
	Color(35, 35, 35),
	Color(192, 57, 43),
}
local base
local function freezermenu()
	local ent = net.ReadEntity()
	if !IsValid(ent) or IsValid(base) then return end
	base = vgui.Create("DFrame")
	base:SetSize(200, 70)
	base:Center()
	base:SetTitle("")
	base:MakePopup()
	base:ShowCloseButton(false)
	base:SetDraggable(false)
	base:ParentToHUD()
	base.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, labcolors[7])
		draw.SimpleText("Freezer", "mg_methcombinermenu", 5, 5, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP)
	end
	local ply = LocalPlayer()
	local pressed_E = true
	base.Think = function()
		if !input.IsKeyDown(KEY_E) then
			pressed_E = false
		elseif !pressed_E then
			base:Remove()
		end
		if !IsValid(ent) or ent:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(ent:GetPos()) > 36000 then
			base:Remove()
		end
	end
	local closebttn = vgui.Create("DButton", base)
	closebttn:SetText("")
	closebttn:SetPos(150, 0)
	closebttn:SetSize(50, 20)
	closebttn.Paint = function(self, w, h)
		if self:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, labcolors[11])
		else
			draw.RoundedBox(0, 0, 0, w, h, labcolors[8])
		end
		draw.SimpleText("X", "mg_methcombinermenu", w / 2, h / 2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	closebttn.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		base:Close()
	end

	local bttn1 = vgui.Create("DButton", base)
	bttn1:Dock(FILL)
	bttn1:SetText("")
	bttn1.Paint = function(self, w, h)
		if self:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, labcolors[10])
		else
			draw.RoundedBox(0, 0, 0, w, h, labcolors[9])
		end
		draw.SimpleText("Freezer fixieren/lösen", "mg_methcombinermenu", w / 2, h / 2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	bttn1.DoClick = function()
		base:Close()
		surface.PlaySound("ui/buttonclick.wav")
		if !IsValid(ent) then return end
		net.Start("mg_meth_net_freeze")
			net.WriteEntity(ent)
		net.SendToServer()
	end
end

net.Receive("mg_meth_net_openfreezermenu", freezermenu)

function ENT:Initialize()
	self.LastUsedPositions = -1
	self.LastFrezze = 0
end

local vector_1 = Vector(0, -20, 81)
local color_1 = Color(0, 0, 0, 200)
local particleEffects = GetConVar("zmlab_cl_vfx_particleeffects")
function ENT:Draw()
	self:DrawModel()
	localply = localply or LocalPlayer()
	if localply:GetPos():DistToSqr(self:GetPos()) < 1000000 then
		if particleEffects:GetBool() then
			local dlight01 = DynamicLight(self:EntIndex())
			if (dlight01 and self:GetIsFreezing()) then
				dlight01.pos = self:GetPos() + self:GetUp() * 50 + self:GetRight() * 20
				dlight01.r = 0
				dlight01.g = 200
				dlight01.b = 255
				dlight01.brightness = 2
				dlight01.Decay = 1000
				dlight01.Size = 300
				dlight01.DieTime = CurTime() + 1
			end
		end

		local owner = zmlab.f.GetOwner(self)
		local pname = owner and owner:Nick() or "Niemand"
		local len = #pname
		local ang = self:GetAngles()
		ang:RotateAroundAxis(ang:Forward(), 90)
		cam.Start3D2D(self:LocalToWorld(vector_1), ang, .03)
			draw.RoundedBox(0, -(len * 62) / 2, 0, len * 62, 150, color_1)
			draw.SimpleText(pname, "mg_meth_ownerbig", 0, 75, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		cam.End3D2D()
	end
end

local localPly
function ENT:Think()
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end

	localPly = localPly or LocalPlayer()

	local pos = self:GetPos()

	if zmlab.f.InDistance(localPly:EyePos(), pos, 600) then
		local usedPos = dt.UsedPositions

		if tb.LastUsedPositions ~= usedPos then
			if usedPos > tb.LastUsedPositions then
				self:EmitSound("freezer_addTray")
			else
				self:EmitSound("freezer_removeTray")
			end

			tb.LastUsedPositions = usedPos
		end

		if dt.IsFreezing and CurTime() > tb.LastFrezze then
			self:EmitSound("progress_freezing")
			if particleEffects:GetBool() then
				local up = self:GetUp()
				local ang = self:GetAngles()

				ParticleEffect("zmlab_frozen_tray", pos + up * 25, ang, self)
				ParticleEffect("zmlab_frozen_tray", pos + up * 35, ang, self)
				ParticleEffect("zmlab_frozen_tray", pos + up * 45, ang, self)
				ParticleEffect("zmlab_frozen_tray", pos + up * 55, ang, self)
				ParticleEffect("zmlab_frozen_tray", pos + up * 65, ang, self)
			end
			tb.LastFrezze = CurTime() + 1
		end
	end
end