include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_methdropoff", {font = use_font, size = 65, weight = 1000, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("mg_methdropoff2", {font = use_font, size = 32, weight = 600, blursize = 0, antialias = true, shadow = false})

local localply
local cam_Start3D2D, cam_End3D2D, draw_SimpleTextOutlined, render = cam.Start3D2D, cam.End3D2D, draw.SimpleTextOutlined, render

function ENT:Initialize()
	self.Closed = true
	self.RenderStencil = false
	self:CreateClientSideModel()
end

function ENT:CreateClientSideModel()
	self.csModel = ClientsideModel("models/zerochain/zmlab/zmlab_dropoffshaft_shaft.mdl")
	local csModel = self.csModel

	if !IsValid(csModel) then return end
	csModel:SetPos(self:GetPos())
	csModel:SetAngles(self:GetAngles())
	csModel:SetParent(self)
	csModel:DrawShadow(false)
	csModel:SetNoDraw(true)
end

function ENT:Draw()
	self:DrawModel()

	if self.RenderStencil then
		render.ClearStencil()
		render.SetStencilEnable(true)
		render.SetStencilWriteMask(255)
		render.SetStencilTestMask(255)
		render.SetStencilReferenceValue(57)
		render.SetStencilCompareFunction(STENCILCOMPARISONFUNCTION_ALWAYS)
		render.SetStencilPassOperation(STENCILOPERATION_REPLACE)
		render.SetStencilFailOperation(STENCIL_ZERO)
		render.SetStencilZFailOperation(STENCIL_ZERO)

		cam.Start3D2D(self:GetPos() + self:GetUp() * 1, self:GetAngles(), 0.5)
			draw.RoundedBox(0, -45, -45, 90, 90, zmlab.default_colors["white02"])
		cam.End3D2D()

		render.SetStencilCompareFunction(STENCILCOMPARISONFUNCTION_EQUAL)
		render.SuppressEngineLighting(true)
		render.DepthRange(0, 0.8)

		if !IsValid(self.csModel) then
			self:CreateClientSideModel()
		end
		
		if IsValid(self.csModel) then
			self.csModel:DrawModel()
		end

		render.SuppressEngineLighting(false)
		render.SetStencilEnable(false)
		render.DepthRange(0, 1)
	end
end

local vector_1 = Vector(0, 0, 1)
local red_color, green_color = Color(232, 65, 24), Color(68, 189, 50)
function ENT:DrawTranslucent()
	localply = localply or LocalPlayer()
	if localply:GetPos():DistToSqr(self:GetPos()) > 40000 then return end

	local ang = self:GetAngles()	
	local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 60 + math.sin(SysTime() * 2)))
	local bttntxt = input.LookupBinding("+use") and string.upper(input.LookupBinding("+use")) or "E"
	local pricetxt = zmlab.currentPrice
	local baseprice = zmlab.config.baseprice
	local progress = (1 / baseprice * zmlab.config.pricediff[2]) * ((pricetxt - baseprice) / baseprice * 100)
	local pcolor = zmlab.f.LerpColor(progress, red_color, green_color)
	local chngtxt = string.ToMinutesSeconds(math.max(0, zmlab.nextPriceChange - CurTime()))

	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	cam_Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
		draw_SimpleTextOutlined(self.PrintName, "mg_methdropoff", 0, -100, team.GetColor(zmlab.config.cookjob), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
		if localply:Team() == zmlab.config.cookjob then
			draw_SimpleTextOutlined("Drücke ["..bttntxt.."], um Meth zu verkaufen.", "mg_methdropoff2", 0, -55, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("Verkaufspreis: $"..string.Comma(pricetxt).."/g", "mg_methdropoff2", -200, -20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("("..math.floor((pricetxt - baseprice) / baseprice * 100).."%)", "mg_methdropoff2", 152, -20, pcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER, 1, color_black)
			draw_SimpleTextOutlined("Nächste Preisänderung: "..string.Comma(chngtxt).." min.", "mg_methdropoff2", 0, 15, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
		end
	cam_End3D2D()
end

function ENT:Think()
	local tb = self:GetTable()
	local dt = tb.dt
	if !dt then return end

	if IsValid(tb.csModel) then
		tb.csModel:SetPos(self:GetPos())
		tb.csModel:SetAngles(self:GetAngles())
	end

	local closed = dt.IsClosed

	if tb.Closed ~= closed or (tb.Anim and tb.Anim != self:GetSequence()) then
		tb.Anim = nil
		tb.Closed = closed

		if tb.Closed then

			zmlab.f.ClientAnim(self, "close", 2)
			self:EmitSound("DropOffSpawn")

			timer.Simple(2, function()
				if IsValid(self) then
					tb.RenderStencil = false
				end
			end)
		else
			tb.RenderStencil = true
			zmlab.f.ClientAnim(self, "open", 1)
			self:EmitSound("DropOffSpawn")

			tb.Anim = self:GetSequence()
		end
	end

	self:SetNextClientThink(CurTime())
	return true
end

function ENT:OnRemove()
	if IsValid(self.csModel) then
		self.csModel:Remove()
	end
end