include("shared.lua")
include("vmod/config/sh_config.lua")

surface.CreateFont("Fuel_PumpNumbers", {font = "Arial", size = 24, weight = 500, antialias = true})
surface.CreateFont("Fuel_PumpPercent", {font = "Arial", size = 48, weight = 500, antialias = true})
surface.CreateFont("Fuel_PumpText", {font = "Arial", size = 48, weight = 500, antialias = true})
surface.CreateFont("Fuel_PumpSmallText", {font = "Arial", size = 40, weight = 500, antialias = true})
surface.CreateFont("Fuel_PumpMiniText", {font = "Arial", size = 25, weight = 500, antialias = true})

local local_ply, distance
local bgcolor = Color(50, 50, 50)
function ENT:Draw()
	self:DrawModel()
	local_ply = local_ply or LocalPlayer()
	distance = local_ply:EyePos():DistToSqr(self:GetPos())
	if distance < 1562500 then
		local ang = self:GetAngles()
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(), -90)
		cam.Start3D2D(self:GetPos() + ang:Up() * 10 - ang:Forward() * 15 - ang:Right() * 57, ang, 0.05)
			draw.RoundedBox(0, 0, 0, 606, 460, color_black)
			draw.RoundedBox(0, 0, 0, 606, 50, Color(255, 75, 75, 255))
			draw.DrawText("Tanksäule", "Fuel_PumpText", 305, 1, bgcolor, TEXT_ALIGN_CENTER)
			draw.DrawText("Tanksäule", "Fuel_PumpText", 304, 0, color_white, TEXT_ALIGN_CENTER)
			local ent = self:GetVehicleEntity()
			if ent:IsValid() then
				local fuel = math.Round(self:GetFuel(), 1)
				local max_fuel = math.Round(self:GetMaxFuel(), 1)
				local height = math.Clamp(fuel / max_fuel, 0, 1)
				local percent = math.floor(math.Clamp(fuel / max_fuel * 100, 0, 100))
				draw.RoundedBox(4, 470, 56, 98, 396, bgcolor)
				draw.RoundedBox(4, 473, 432 - (372 * height), 92, 372 * height + 16, Color(255, 185, 0))
				draw.DrawText(percent.."%", "Fuel_PumpPercent", 520, (height > 0.3) and 438 - (372 * height) or 334, bgcolor, TEXT_ALIGN_CENTER)
				draw.DrawText(percent.."%", "Fuel_PumpPercent", 518, (height > 0.3) and 438 - (372 * height) or 334, color_white, TEXT_ALIGN_CENTER)
				draw.DrawText("T  A  N  K", "Fuel_PumpNumbers", 520, (height > 0.3) and 438 - (372 * height) + 40 or 374, bgcolor, TEXT_ALIGN_CENTER)
				draw.DrawText("T  A  N  K", "Fuel_PumpNumbers", 518, (height > 0.3) and 438 - (372 * height) + 40 or 374, color_white, TEXT_ALIGN_CENTER)
				draw.DrawText(fuel.." Liter", "Fuel_PumpMiniText", 520, 404, bgcolor, TEXT_ALIGN_CENTER)
				draw.DrawText(fuel.." Liter", "Fuel_PumpMiniText", 518, 404, color_white, TEXT_ALIGN_CENTER)
				local car = self:GetVehicleClass()
				local name = "Unbekannt"
				if list.Get("Vehicles")[car] then
					name = list.Get("Vehicles")[car].Name
				end
				draw.DrawText(string.sub(name, 1, 22), "Fuel_PumpPercent", 40, 70, color_white, TEXT_ALIGN_LEFT)
				if vcmod1 then
					draw.DrawText("Haltbarkeit: "..math.ceil(ent:VC_getHealth(true)).."%", "Fuel_PumpNumbers", 40, 140, color_white, TEXT_ALIGN_LEFT)
				end
				draw.DrawText("Nummernschild: "..(ent:GetNWString("plate_serial") or "Unbekannt"), "Fuel_PumpNumbers", 40, 170, color_white, TEXT_ALIGN_LEFT)
				local reduced = MG_VMod.Pump.CustomPrices[car] or 1
				local price = self:GetPrice() * reduced
				local total = math.floor(math.abs(fuel - max_fuel) * price)
				if reduced == 1 then
					draw.DrawText("Preis pro Liter: $"..string.Comma(price), "Fuel_PumpNumbers", 40, 200, color_white, TEXT_ALIGN_LEFT)
				else
					draw.DrawText("Preis pro Liter: $"..string.Comma(price).." (Für Sie, um "..math.floor((1 - reduced) * 100).."% reduziert)", "Fuel_PumpNumbers", 40, 200, color_white, TEXT_ALIGN_LEFT)
				end
				if (fuel < max_fuel) then
					draw.DrawText("Drücke "..(string.upper(input.LookupBinding("+use")) or "E")..", um "..math.abs(fuel - max_fuel).." Liter für $" ..string.Comma(total).." aufzutanken.", "Fuel_PumpNumbers", 40, 260, color_white, TEXT_ALIGN_LEFT)
				elseif (fuel >= max_fuel) then
					draw.DrawText("Dieses Auto ist bereits vollgetankt!", "Fuel_PumpNumbers", 40, 260, color_white, TEXT_ALIGN_LEFT)
				end
			else
				draw.DrawText("Fahre ein Auto an die Säule!", "Fuel_PumpText", 36, 90, color_white, TEXT_ALIGN_LEFT)
				draw.DrawText("Preis pro Liter: $"..string.Comma(self:GetPrice()), "Fuel_PumpSmallText", 300, 160, color_white, TEXT_ALIGN_CENTER)
			end
		cam.End3D2D()
	end
end