surface.CreateFont("Fuel_Display", {font = "Arial", size = 24, weight = 500, antialias = true})
surface.CreateFont("Fuel_Display2", {font = "Arial", size = 12, weight = 500, antialias = true})
surface.CreateFont("Fuel_Display3", {font = "Arial", size = 16, weight = 500, antialias = true})

local fuel_anim = 100
local local_ply, veh
local fuelmeter = CreateClientConVar("cl_fuelmeter", 1, FCVAR_ARCHIVE)
local function DrawFuelMeter()
	if !fuelmeter:GetBool() then return end
	local_ply = local_ply or LocalPlayer()
	veh = local_ply:GetVehicle()
	if !IsValid(veh) then return end
	local class = veh:GetClass()
	if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then return end
	if MG_VMod.FuelExceptions[veh:GetVehicleClass()] == true then return end
	local fuel = math.Round(veh:GetNWInt("Fuel"), 1)
	local max_fuel = math.Round(veh:GetNWInt("MaxFuel"), 1)
	local clamp = math.Clamp(fuel / max_fuel * 100, 0, 100)
	fuel_anim = math.Approach(fuel_anim, clamp, 1)
	local wide = MG_VMod.HUD.Width
	local high = MG_VMod.HUD.Height
	local offsetx = MG_VMod.HUD.OffsetX
	local offsety = MG_VMod.HUD.OffsetY
	local border = MG_VMod.HUD.Border
	local sum = (high - (border * 2)) * (fuel_anim / 100) + border * 2
	local scrh = ScrH()
	local scrw = ScrW()
	draw.RoundedBox(4, scrw - wide - offsetx - (border / 2), scrh - high - offsety - (border / 2), wide + border, high + border, MG_VMod.HUD.BGColor)
	draw.RoundedBox(4, scrw - wide - offsetx, scrh - sum - offsety, wide, sum, MG_VMod.HUD.Color)
	clamp = math.floor(clamp)
	draw.DrawText(clamp.."%", "Fuel_Display", scrw - wide / 2 - offsetx + 1, (sum < 60) and scrh - offsety - 61 or scrh - sum - offsety + 1, Color(50, 50, 50), TEXT_ALIGN_CENTER)
	draw.DrawText(clamp.."%", "Fuel_Display", scrw - wide / 2 - offsetx, (sum < 60) and scrh - offsety - 60 or scrh - sum - offsety, color_white, TEXT_ALIGN_CENTER)
	draw.DrawText("T  A  N  K", "Fuel_Display2", scrw - wide / 2 - offsetx + 1, (sum < 60) and scrh - offsety - 41 or scrh - sum - offsety + 21, Color(50, 50, 50), TEXT_ALIGN_CENTER)
	draw.DrawText("T  A  N  K", "Fuel_Display2", scrw - wide / 2 - offsetx, (sum < 60) and scrh - offsety - 40 or scrh - sum - offsety + 20, color_white, TEXT_ALIGN_CENTER)
	draw.DrawText(fuel.." Liter", "Fuel_Display3", scrw - wide / 2 - offsetx + 1, scrh - offsety - 20, Color(50, 50, 50), TEXT_ALIGN_CENTER)
	draw.DrawText(fuel.." Liter", "Fuel_Display3", scrw - wide / 2 - offsetx, scrh - offsety - 21, color_white, TEXT_ALIGN_CENTER)
end

hook.Add("HUDPaint", "Fuel_DrawFuelMeter", DrawFuelMeter)