local MG_VMod_EngineStartTime
local function DrawEngineStartup()
	local cur_time = CurTime()
	if (!MG_VMod_EngineStartTime or MG_VMod_EngineStartTime + MG_VMod.StartupTime <= cur_time) then
		hook.Remove("HUDPaint", "Fuel_DrawEngineStartup")
		return
	end
	surface.SetDrawColor(Color(50, 50, 50, 155))
	surface.DrawRect(ScreenScale(220), ScreenScale(175), ScreenScale(200), ScreenScale(7.5))
	surface.SetDrawColor(Color(200, 0, 0, 155))
	surface.DrawRect(ScreenScale(220), ScreenScale(175), ScreenScale(65) * (cur_time - MG_VMod_EngineStartTime) / MG_VMod.HUD.BarMultiplier, ScreenScale(7.5))
	surface.SetTextColor(color_white)
	surface.SetFont("UiBold")
	surface.SetTextPos(ScreenScale(300), ScreenScale(176))
	surface.DrawText("Motor wird gestartet...")
end

usermessage.Hook("MG_VMod_EngineStrat", function(msg)
	if (msg:ReadBool() == true) then
		MG_VMod_EngineStartTime = CurTime()
		hook.Add("HUDPaint", "Fuel_DrawEngineStartup", DrawEngineStartup)
	else
		MG_VMod_EngineStartTime = nil
		hook.Remove("HUDPaint", "Fuel_DrawEngineStartup")
	end
end)