if SERVER then
	AddCSLuaFile("shared.lua")
end

if CLIENT then
	SWEP.Slot = 3
	SWEP.SlotPos = 3
	SWEP.DrawAmmo = false
	SWEP.DrawCrosshair = false
end

SWEP.Base = "weapon_basekit"
SWEP.PrintName = "Benzinkanister"
SWEP.Instructions = "Mit Linksklick können Autos aufgetankt werden."
SWEP.Author = "Modern Gaming"
SWEP.Spawnable = true
SWEP.AdminSpawnable = false
SWEP.UseHands = false
SWEP.ViewModel = "models/weapons/c_bugbait.mdl"
SWEP.WorldModel = "models/props_junk/gascan001a.mdl"
SWEP.ShowWorldModel = false
SWEP.HoldType = "slam"

SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = true
SWEP.Primary.Ammo = "none"
SWEP.Primary.Delay = 0.1
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = "none"
SWEP.SwayScale = 1
SWEP.BobScale = 2

SWEP.ViewModelBoneMods = {
	["ValveBiped.cube"] = {scale = Vector(0, 0, 0), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.cube1"] = {scale = Vector(0, 0, 0), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.cube2"] = {scale = Vector(0, 0, 0), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.cube3"] = {scale = Vector(0, 0, 0), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)}
}
SWEP.VElements = {
	["vm_gascan"] = {type = "Model", model = "models/props_junk/gascan001a.mdl", bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(0, 0, 0), angle = Angle(70, -45, 130), size = Vector(0.5, 0.5, 0.5), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}
SWEP.WElements = {
	["wm_gascan"] = {type = "Model", model = "models/props_junk/gascan001a.mdl", bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(3.635, 4.675, 1), angle = Angle(180, 24.545, 3.506), size = Vector(0.5, 0.5, 0.5), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

DEFINE_BASECLASS("weapon_basekit")

function SWEP:SetupDataTables()
	self:NetworkVar("Bool", 0, "Pouring")

	self:NetworkVar("Float", 1, "PouringTime")
	self:NetworkVar("Float", 1, "WetTime")
end

function SWEP:DrawHUD()
	if self.Owner:InVehicle() and !self.Owner:GetAllowWeaponsInVehicle() then return end
	local tr = self.Owner:GetEyeTrace()
	local ent = tr.Entity
	if IsValid(ent) and ent:IsVehicle() then
		local class = ent:GetClass()
		if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then return end
		local fuel, maxfuel = ent:GetNWInt("Fuel"), ent:GetNWInt("MaxFuel")
		local scrw, scrh = ScrW() / 2, ScrH() - 110
		draw.SimpleTextOutlined("Tank: "..string.Comma(math.Round(fuel, 1)).." / "..string.Comma(math.Round(maxfuel, 1)).."l", "mg_instructions", scrw, scrh, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		draw.SimpleTextOutlined("Gedrückt halten zum Auftanken.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
	end
end

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)

	self:SetPouring(false)
	self:SetPouringTime(0)
	self:SetWetTime(0)

	return BaseClass.Initialize(self)
end

function SWEP:Deploy()
	if self.Wet then
		self.Wet:Stop()
		self.Wet = nil
	end

	self:SendWeaponAnim(ACT_VM_DRAW)
	self:SetNextPrimaryFire(CurTime() + self:SequenceDuration())

	self:SetPouring(false)
	self:SetPouringTime(0)
	self:SetWetTime(0)

	return BaseClass.Deploy(self)
end

function SWEP:Holster()
	if self.Wet then
		self.Wet:Stop()
		self.Wet = nil
	end

	self:SetPouring(false)
	self:SetPouringTime(0)
	self:SetWetTime(0)

	return BaseClass.Holster(self)
end

function SWEP:OnRemove()
	if self.Wet then
		self.Wet:Stop()
		self.Wet = nil
	end

	return BaseClass.OnRemove(self)
end

function SWEP:PrimaryAttack()
	if !IsValid(self.Owner) then return end
	local speed = self.Primary.Delay
	speed = hook.Run("MG_VMod_FuelSpeed", self, speed) or speed
	self:SetNextPrimaryFire(CurTime() + speed)
	local tr = util.TraceLine{start = self.Owner:GetShootPos(), endpos = self.Owner:GetShootPos() + self.Owner:EyeAngles():Forward() * 80, filter = self.Owner}
	local ent = tr.Entity
	if IsValid(ent) and ent:IsVehicle() then
		local class = ent:GetClass()
		if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then return end	
		if MG_VMod.FuelExceptions[ent:GetVehicleClass()] == true then return end

		if (SERVER and ent:GetVehicleFuel() < ent:GetMaxVehicleFuel()) or (CLIENT and ent:GetNWInt("Fuel", 0) < ent:GetNWInt("MaxFuel", 0)) then
			self:SetHoldType("pistol")
			self:SetPouring(true)
			self:SetPouringTime(CurTime() + 0.1)
			self:SetWetTime(CurTime() + 0.3)

			if !self.Wet then
				self.Wet = CreateSound(self, "ambient/water/leak_1.wav")
				self.Wet:ChangePitch(150, 0)
				self.Wet:Play()
			else
				self.Wet:ChangeVolume(1, 0.1)
			end
			if SERVER then
				ent:SetVehicleFuel(ent:GetVehicleFuel() + 1)
			end
		end
	end
end
 
function SWEP:SecondaryAttack()
end

function SWEP:Reload()
end

function SWEP:Think()
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end

	if tb.Wet and dt.WetTime <= CurTime() then
		tb.Wet:Stop()
		tb.Wet = nil

		dt.WetTime = 0
	end

	if dt.Pouring and dt.PouringTime <= CurTime() then
		dt.Pouring = false
		dt.PouringTime = 0

		self:SetHoldType(self.HoldType)
	end
end

if CLIENT then
	SWEP.MoveToPos = vector_origin + Vector(0, 10, 0)
	SWEP.LastMultiX = 0
	SWEP.LastSysTime = 0
	function SWEP:GetViewModelPosition(pos, ang)
		local pouring = self:GetPouring()
		local sys_time = SysTime()
		local multx
		if pouring then
			multx = (self.LastMultiX == 1 and 1) or Lerp((sys_time - self.LastSysTime) * 25, self.LastMultiX, 1)
		else
			multx = (self.LastMultiX == 0 and 0) or Lerp((sys_time - self.LastSysTime) * 25, self.LastMultiX, 0)
		end
		self.LastSysTime = sys_time
		local Offset = self.MoveToPos
		pos = pos + Offset.x * ang:Right() * multx
		pos = pos + Offset.y * ang:Forward() * multx
		pos = pos + Offset.z * ang:Up() * multx
		self.LastMultiX = multx
		return pos, ang
	end
end