include("shared.lua")

surface.CreateFont("mg_crate_font", {font = "Roboto", size = 55, weight = 700, blursize = 0, antialias = true, shadow = false})

local clr, local_ply = Color(150, 150, 50, 100)
local text = "Bergbaukiste von"
function ENT:Draw()
	self:DrawModel()
	local_ply = local_ply or LocalPlayer()
	if local_ply:EyePos():DistToSqr(self:GetPos()) > 90000 then return end
	local pos = self:GetPos()
	local ang = self:GetAngles()
	local owner = self:Getowning_ent()
	owner = (IsValid(owner) and owner:IsPlayer() and owner:Name()) or "Niemand"
	surface.SetFont("mg_crate_font")
	local worth = "$"..string.Comma(self:GetWorth())
	local size = "Erze: "..self:GetContent().." / "..self:GetSize()
	local w = surface.GetTextSize(text)
	local w2 = surface.GetTextSize(owner)
	local w3 = surface.GetTextSize(worth)
	local w4 = surface.GetTextSize(size)
	ang:RotateAroundAxis(ang:Up(), 90)
	cam.Start3D2D(pos + ang:Up() * 13, ang, 0.05)
		draw.WordBox(8, -w * 0.5, -145, text, "mg_crate_font", clr, color_white)
		draw.WordBox(8, -w2 * 0.5, -60, owner, "mg_crate_font", clr, color_white)
		draw.WordBox(8, -w3 * 0.5, 25, worth, "mg_crate_font", clr, color_white)
		draw.WordBox(8, -w4 * 0.5, 110, size, "mg_crate_font", clr, color_white)
	cam.End3D2D()
end

surface.CreateFont("mg_crate_upgrade1", {
	font = "Roboto",
	size = 18,
	weight = 500,
	shadow = true,
})

surface.CreateFont("mg_crate_upgrade2", {
	font = "Roboto",
	size = 14,
	weight = 500,
	shadow = true,
})

local menu
net.Receive("Mining_OpenMenu", function()
	local Crate = net.ReadEntity()
	if !IsValid(Crate) then return end
	if IsValid(menu) then return end
	menu = vgui.Create("DFrame")
	menu:SetSize(400, 314)
	menu:SetTitle("Bergbaukiste")
	menu:SetPos(ScrW() / 2 - menu:GetWide() / 2, ScrH())
	menu:MoveTo(ScrW() / 2 - menu:GetWide() / 2, ScrH() / 2 - menu:GetTall() / 2, 0.25, 0, 0.5)
	menu:MakePopup()
	menu:ShowCloseButton(false)
	menu:ParentToHUD()
	local ply = LocalPlayer()
	menu.Think = function()
		if !IsValid(Crate) or Crate:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(Crate:GetPos()) > 10000 then
			menu:Remove()
		end
	end
	function menu:Paint(w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(156, 119, 0))
		draw.RoundedBox(2, 2, 2, w - 4, h - 4, Color(35, 35, 35, 255))
	end
	local Close = vgui.Create("DButton", menu)
	Close:SetSize(50, 20)
	Close:SetPos(menu:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("mg_money_printer_close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(0, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		menu:Remove()
	end
	local UpgradeList = vgui.Create("DScrollPanel", menu)
	UpgradeList:SetPos(10, 30)
	UpgradeList:SetSize(menu:GetWide() - 20, menu:GetTall() - 50)
	UpgradeList.Paint = function(self, w, h)
		draw.RoundedBox(0, 1, 1, w, h, Color(50, 50, 50, 100))
	end
	for k, v in ipairs(Crate.Upgrades) do
		local Cost = v.Price + (v.PriceInc * (Crate.dt["Upgrade"..k] or 0))
		local UpgradeListPanel = vgui.Create("DFrame", UpgradeList)
		UpgradeListPanel:SetTall(55 + 11)
		UpgradeListPanel:Dock(TOP)
		UpgradeListPanel:SetTitle("")
		UpgradeListPanel:ShowCloseButton(false)
		UpgradeListPanel:SetDraggable(false)
		local star = Material("icon16/star.png")
		UpgradeListPanel.Paint = function(self, w, h)
			draw.RoundedBox(0, 0, 0, w - 1, h - 1, Color(60, 60, 60, 255))
			local stars_left = Crate.dt and Crate.dt["Upgrade"..k] or 0
			local x, y = 55 + 15, 45
			for i=1, v.Max do
				local clr = stars_left > 0 and color_white or Color(255, 255, 255, 100)
				surface.SetDrawColor(clr)
				surface.SetMaterial(star)
				surface.DrawTexturedRect(x, y, 16, 16)
				stars_left = stars_left - 1
				x = x + 18
			end
		end
		local Icon = vgui.Create("SpawnIcon", UpgradeListPanel)
		Icon:SetModel(v.Icon)
		Icon:SetSize(55, 55)
		Icon:SetPos(5, 5)
		Icon:SetMouseInputEnabled(false)
		local Name = vgui.Create("DLabel", UpgradeListPanel)
		Name:SetPos(55 + 15, 5)
		Name:SetFont("mg_crate_upgrade1")
		Name:SetText(v.Name)
		Name:SizeToContents()
		local Info = vgui.Create("DLabel", UpgradeListPanel)
		Info:SetPos(55 + 15, 25)
		Info:SetFont("mg_crate_upgrade2")
		Info:SetText(v.Pickaxe and "Für Spitzhacke" or "Für Bergbaukiste")
		Info:SizeToContents()
		local Price = vgui.Create("DLabel", UpgradeListPanel)
		Price:SetPos(UpgradeList:GetWide() - 95, 5)
		Price:SetFont("mg_crate_upgrade1")
		Price:SetText("Preis: $"..string.Comma(Cost))
		Price:SizeToContents()
		Price.Think = function(self)
			if !IsValid(Crate) then return end
			local lvl = (Crate.dt["Upgrade"..k] or 0)
			Cost = lvl < v.Max and v.Price + (v.PriceInc * lvl) or false
			self:SetText(Cost and "Preis: $"..string.Comma(Cost) or "Max. Level "..lvl)
		end
		local Buy = vgui.Create("DButton", UpgradeListPanel)
		Buy:SetSize(80, 20)
		Buy:SetPos(UpgradeList:GetWide() - 85, 40)
		Buy:SetText("Verbessern")
		Buy.Think = function()
			if IsValid(Crate) and (Crate.dt["Upgrade"..k] or 0) < v.Max and ply:canAfford(Cost) then
				Buy:SetDisabled(false)
			else
				Buy:SetDisabled(true)
			end
		end
		Buy.DoClick = function()
			if IsValid(Crate) then
				net.Start("Mining_Upgrade")
					net.WriteEntity(Crate)
					net.WriteUInt(k, 16)
				net.SendToServer()
			end
		end
	end
end)