ENT.Base = "base_anim"

ENT.PrintName = "Bergbaukiste"
ENT.Category = "Bergbau"
ENT.Spawnable = true

ENT.IsOreCrate = true

ENT.Size = 15

ENT.Upgrades = {
	{
		Name = "Mehr Platz (+5)",
		Icon = "models/prop/crates/miningcrate.mdl",
		Crate = true,
		Size = true,
		Price = 2000,
		PriceInc = 1000,
		Max = 3,
		Increase = 5,
		Func = function(ply, crate, lvl, tbl)
			crate:SetSize(crate:GetSize() + tbl.Increase)
		end
	},
	{
		Name = "Handel (+4% Auszahlung)",
		Icon = "models/props_interiors/cashregister01.mdl",
		Crate = true,
		Size = true,
		Price = 3000,
		PriceInc = 1500,
		Max = 3,
		Chance = 0.04,
		Func = function(ply, crate, lvl, tbl)
			crate.SellMultiplier = 1 + (tbl.Chance * lvl)
		end
	},
	{
		Name = "Beschleunigung (+10%)",
		Icon = "models/pickaxe/pickaxe_w.mdl",
		Pickaxe = true,
		Speed = true,
		Price = 4000,
		PriceInc = 2000,
		Max = 3,
		Speed = 0.1,
		Func = function(ply, crate, lvl, tbl)
			crate:SetSpeed(1 - (tbl.Speed * lvl))
		end
	},
	{
		Name = "Abbauchance (+1%)",
		Icon = "models/prop/drop/rock_ore.mdl",
		Pickaxe = true,
		Speed = true,
		Price = 1000,
		PriceInc = 500,
		Max = 5,
		Chance = 1,
		Func = function(ply, crate, lvl, tbl)
			crate.ExtraChance = tbl.Chance * lvl
		end
	},
}

function ENT:SetupDataTables()
	self:NetworkVar("Entity", 0, "owning_ent")
	self:NetworkVar("Int", 0, "Worth")
	self:NetworkVar("Int", 1, "Size")
	self:NetworkVar("Int", 2, "Content")
	self:NetworkVar("Float", 0, "Speed")
	self:SetSpeed(1)

	local ind = 3
	for k, v in ipairs(self.Upgrades) do
		self:NetworkVar("Int", ind, "Upgrade"..k)
		ind = ind + 1
	end
end

MiningCrates = MiningCrates or {}
function ENT:Initialize()
	if SERVER then
		self:SetModel("models/prop/crates/miningcrate.mdl")
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		self:SetUseType(SIMPLE_USE)
		local phys = self:GetPhysicsObject()
		if phys:IsValid() then
			phys:Wake()
		end
		self:SetHealth(250)
		self:SetSize(self.Size)
		self.ExtraChance = 0
		self.CompletePrice = 0
		self.SellMultiplier = 1
	end
	MiningCrates[self:EntIndex()] = self
end

function ENT:OnRemove()
	MiningCrates[self:EntIndex()] = nil
end

function ENT:PhysgunPickup(ply)
	return ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply:IsAdmin()
end