include("shared.lua")

surface.CreateFont("mg_ore_font", {font = "Roboto", size = 72, weight = 700, blursize = 0, antialias = true, shadow = false})

if !draw.ShadowText then
	function draw.ShadowText(text, font, x, y, colortext, colorshadow, dist, xalign, yalign)
		draw.SimpleText(text, font, x + dist, y + dist, colorshadow, xalign, yalign)
		draw.SimpleText(text, font, x, y, colortext, xalign, yalign)
	end
end

function ENT:Draw()
	self:DrawModel()
end

local up, clr, local_ply, eye_ang, wid = Vector(0, 0, 15), Color(100, 100, 50, 255)
function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	if local_ply:EyePos():DistToSqr(self:GetPos()) > 40000 then return end
	eye_ang = EyeAngles()
	eye_ang.p = 0
	eye_ang.y = eye_ang.y - 90
	eye_ang.r = 90
	local name = self:GetOreName()
	surface.SetFont("mg_ore_font")
	wid = math.max(250, surface.GetTextSize(name))
	cam.Start3D2D(self:GetPos() + up, eye_ang, 0.05)
		surface.SetDrawColor(clr)
		surface.DrawRect(-wid / 2 - 15, -200, wid + 30, 65)
		surface.SetDrawColor(0, 0, 0, 150)
		surface.DrawRect(-wid / 2 - 15, -135, wid + 30, 65)
		draw.ShadowText(name, "mg_ore_font", 0, -170, color_white, color_black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.ShadowText("$"..string.Comma(self:GetOreWorth()), "mg_ore_font", 0, -105, color_white, color_black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	cam.End3D2D()
end