SWEP.Spawnable = true

SWEP.HoldType = "melee"

SWEP.PrintName = "Spitzhacke"
SWEP.Slot = 0
SWEP.SlotPos = 1
SWEP.Primary.Damage	= 12
SWEP.Primary.Delay 	= 1
SWEP.Author = "Modern Gaming"
SWEP.Purpose = "Wird benutzt, um Mineralien abzubauen."

SWEP.ViewModelFOV = 72
SWEP.ViewModel = Model("models/pickaxe/pickaxe_v.mdl")
SWEP.WorldModel = Model("models/pickaxe/pickaxe_w.mdl")

SWEP.Primary.Automatic = true
SWEP.Primary.Ammo = "none"
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Secondary.Automatic = true
SWEP.Secondary.Ammo = "none"
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1

SWEP.WeaponType = "melee_sharp"

function SWEP:SetupDataTables()
	self:NetworkVar("Float", 0, "NextAttack")
end

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)
	self:SetDeploySpeed(1)
end

function SWEP:Deploy()
	self:SetNextAttack(0)
	return true
end

function SWEP:CheckTrace(owner)
	owner:LagCompensation(true)
	local tr = util.TraceLine({
		start = owner:GetShootPos(),
		endpos = owner:GetShootPos() + owner:GetAimVector() * 84,
		filter = owner,
		mask = MASK_SHOT_HULL
	})
	if !IsValid(tr.Entity) then 
		tr = util.TraceHull({
			start = owner:GetShootPos(),
			endpos = owner:GetShootPos() + owner:GetAimVector() * 84,
			filter = owner,
			mins = Vector(-2, -2, -1),
			maxs = Vector(2, 2, 1),
			mask = MASK_SHOT_HULL
		})
	end
	owner:LagCompensation(false)
	if tr.Hit then
		return true, tr
	end
	return false, tr
end

function SWEP:DetermineSpeed()
	local primdelay = self.Primary.Delay
	for _, v in pairs(MiningCrates) do
		if !IsValid(v) then continue end
		local owner = v.Getowning_ent and v:Getowning_ent()
		if IsValid(owner) and owner == self.Owner then
			local speed = v:GetSpeed()
			if speed == 0 then
				break
			end
			primdelay = primdelay * speed
		end
	end
	primdelay = hook.Run("Mining_PickaxeSpeed", self, primdelay) or primdelay
	return primdelay
end

local SwingSound = Sound("pickaxe/swing.wav")
local FleshSound = Sound("pickaxe/flesh.wav")
local HitSound = Sound("pickaxe/hit.mp3")
function SWEP:PrimaryAttack()
	self.Owner:SetAnimation(PLAYER_ATTACK1)
	self:EmitSound(SwingSound)
	self:SetNextAttack(CurTime() + 0.12)
	local speed = self:DetermineSpeed()
	self:SetNextPrimaryFire(CurTime() + speed)
	self:SetNextSecondaryFire(CurTime() + speed)
	self.Owner:ViewPunch(Angle(0.5, 0.5, 0))
	if self:CheckTrace(self.Owner) then
		self:SendWeaponAnim(ACT_VM_HITCENTER)
	else
		self:SendWeaponAnim(ACT_VM_MISSCENTER)
	end
end

function SWEP:SecondaryAttack()
	self:PrimaryAttack(true)
end

function SWEP:DealDamage()
	local owner = self.Owner
	local _, tr = self:CheckTrace(owner)
	if SERVER and IsValid(tr.Entity) then
		local dmginfo = DamageInfo()
		local attacker = owner
		if !IsValid(attacker) then attacker = self end
		dmginfo:SetAttacker(attacker)
		dmginfo:SetInflictor(self)
		dmginfo:SetDamage(self.Primary.Damage * math.Rand(0.9, 1.1))
		dmginfo:SetDamageForce(owner:GetForward() * 16384)
		local pos = owner:GetShootPos()
		local dest = pos + (owner:GetAimVector() * 84)
		tr.Entity:DispatchTraceAttack(dmginfo, pos + (owner:GetAimVector() * 3), dest)
	end
	if tr.Hit then
		if tr.Entity:IsPlayer() or tr.Entity:IsNPC() or tr.MatType == MAT_FLESH then
			self:EmitSound(FleshSound)
			self.Owner:ViewPunch(Angle(-1.5, 0, 0))
			if IsFirstTimePredicted() then
				local edata = EffectData()
				edata:SetOrigin(tr.HitPos)
				edata:SetNormal(tr.Normal)
				util.Effect("BloodImpact", edata)
			end
		elseif tr.Entity.IsOreVene then
			self:EmitSound(HitSound)
			self.Owner:ViewPunch(Angle(-1, 0, 0))
			if IsFirstTimePredicted() then
				local edata = EffectData()
				edata:SetStart(self.Owner:GetShootPos())
				edata:SetOrigin(tr.HitPos)
				edata:SetNormal(tr.Normal)
				edata:SetSurfaceProp(tr.SurfaceProps)
				edata:SetHitBox(tr.HitBox)
				edata:SetEntity(tr.Entity)
				util.Effect("Impact", edata)
			end
			if SERVER then
				tr.Entity:Mine(self.Owner, tr)
			end
		else
			self:EmitSound(HitSound)
			self.Owner:ViewPunch(Angle(-1, 0, 0))
			if IsFirstTimePredicted() then
				local edata = EffectData()
				edata:SetStart(self.Owner:GetShootPos())
				edata:SetOrigin(tr.HitPos)
				edata:SetNormal(tr.Normal)
				edata:SetSurfaceProp(tr.SurfaceProps)
				edata:SetHitBox(tr.HitBox)
				edata:SetEntity(tr.Entity)
				util.Effect("Impact", edata)
			end
		end
	end
	if IsValid(tr.Entity) then
		local phys = tr.Entity:GetPhysicsObject()
		if IsValid(phys) and phys:GetMass() < 400 then
			phys:ApplyForceOffset(owner:GetAimVector() * 180 * phys:GetMass(), tr.HitPos)
		end
	end
end

function SWEP:Think()
	local curtime = CurTime()
	local next_atk = self:GetNextAttack()
	if (next_atk > 0 and curtime > next_atk) then
		self:DealDamage()
		self:SetNextAttack(0)
	end
end