MOTD = {}

surface.CreateFont("MOTD_BebasNeue14", {font = "BebasNeue", size = 14, weight = 400, antialias = true})
surface.CreateFont("MOTD_BebasNeue18", {font = "BebasNeue", size = 18, weight = 400, antialias = true})
surface.CreateFont("MOTD_BebasNeue20", {font = "BebasNeue", size = 20, weight = 400, antialias = true})
surface.CreateFont("MOTD_BebasNeue24", {font = "BebasNeue", size = 24, weight = 400, antialias = true})
surface.CreateFont("MOTD_BebasNeue70", {font = "BebasNeue", size = 70, weight = 400, antialias = true})
surface.CreateFont("MOTD_OpenSansC14", {font = "Open Sans Condensed", size = 14, weight = 400, antialias = true})
surface.CreateFont("MOTD_OpenSansC18", {font = "Open Sans Condensed", size = 18, weight = 400, antialias = true})

MOTD.CurrentHeight = ScrH() / 2

include("motd/cl_config.lua")
include("motd/cl_tabs.lua")
include("motd/cl_addtabs.lua")
include("motd/cl_addsv.lua")
include("motd/panels/cl_menubutton.lua")
include("motd/panels/cl_serverpanel.lua")

local MOTD_MainWindow
function MOTD.OpenMOTD(first)
	if IsValid(MOTD_MainWindow) then return end
	local ply = LocalPlayer()
	hook.Run("MOTDOpened")
	MOTD_MainWindow = vgui.Create("DFrame")
	MOTD_MainWindow:SetSize(ScrW(), ScrH())
	MOTD_MainWindow:Center()
	MOTD_MainWindow:SetDraggable(false)
	MOTD_MainWindow:ShowCloseButton(false)
	MOTD_MainWindow:SetTitle("")
	MOTD_MainWindow:SetBackgroundBlur(true)
	MOTD_MainWindow.Paint = MOTD.PaintMainWindow
	MOTD_MainWindow.FirstOpened = first and true or false
	MOTD.TabManager = {}
	if MOTD.Settings.ShowAvatar then
		local avatar_img = vgui.Create("AvatarImage", MOTD_MainWindow)
		avatar_img:SetSize(28,28)
		avatar_img:SetPos(10 , 130)
		avatar_img:SetPlayer(ply, 64)
	end
	if MOTD.Settings.ShowPlayerName then
		local avatar_text = vgui.Create("DLabel", MOTD_MainWindow)
		avatar_text:SetPos(ScrW() - 50 , 135)
		avatar_text:SetText("Willkommen zurück, "..ply:Name())
		avatar_text:SetFont("MOTD_BebasNeue20")
		avatar_text:SetColor(Color(255, 255, 255, 150))
		avatar_text:SizeToContents()
		avatar_text:SetPos(ScrW() - (avatar_text:GetWide() + 5) , 133)
	end
	local MenuButtonList = vgui.Create("DPanelList", MOTD_MainWindow)
	MenuButtonList:SetSize(450, ScrH() - (ScrH() / 3.5))
	MenuButtonList:SetPos(10, 165)
	MenuButtonList:SetPadding(0)
	MenuButtonList:SetSpacing(3)
	MenuButtonList:SetAutoSize(false)
	MenuButtonList:SetNoSizing(false)
	MenuButtonList:EnableVerticalScrollbar(true)
	MenuButtonList.Paint = function()
	end
	for _,v in pairs(MOTD.Tabs) do
		local Button = vgui.Create("ModernButton")
		Button:SetText(v.title)
		Button:SetColor(v.settings.color)
		if v.settings.subtitle then
			Button:SetSubText(v.settings.subtitle)
		end
		if v.settings.icon then
			Button:SetImage(v.settings.icon, 32, 32)
		end
		if v.settings.url then
			local html = vgui.Create("HTML", MOTD_MainWindow)
			html:SetSize(ScrW() - 475, ScrH() - (ScrH() / 3.5))
			html:SetPos(470, 165)
			html:SetVisible(false)
			Button.DoClick = function()
				MOTD.ShowTabPanel(html, Button, v.settings.url)
			end
			table.insert(MOTD.TabManager, {btn = Button, panel = html, url = v.settings.url})
		elseif v.settings.serverlist then
			local ServerList = vgui.Create("DPanelList", MOTD_MainWindow)
			ServerList:SetSize(ScrW() / 3 + 90, ScrH() - (ScrH() / 3.5))
			ServerList:SetPos(470, 165)
			ServerList:SetPadding(0)
			ServerList:SetSpacing(3)
			ServerList:SetAutoSize(false)
			ServerList:SetNoSizing(false)
			ServerList:EnableVerticalScrollbar(true)
			ServerList.Paint = function() end
			ServerList:SetVisible(false)
			for _,m in pairs(MOTD.Servers) do
				local Server = vgui.Create("ModernServerButton")
				Server:SetText(m.title)
				Server:SetColor(m.settings.color)
				Server.DoClick = function()
					ply:ConCommand("connect "..m.settings.serveripport)
				end
				if m.settings.subtitle then
					Server:SetSubText(m.settings.subtitle)
				end
				if m.settings.showgametracker then
					Server:SetGametracker(m.settings.serveripport)
				end
				ServerList:AddItem(Server)
			end
			Button.DoClick = function()
				MOTD.ShowTabPanel(ServerList, Button)
			end
			table.insert(MOTD.TabManager, {btn = Button, panel = ServerList})
		elseif v.settings.text then
			local TextLabelsList = vgui.Create("DPanelList", MOTD_MainWindow)
			TextLabelsList:SetSize(ScrW() - 475, ScrH() - (ScrH() / 3.5))
			TextLabelsList:SetPos(470, 165)
			TextLabelsList:SetPadding(0)
			TextLabelsList:SetSpacing(3)
			TextLabelsList:SetAutoSize(false)
			TextLabelsList:SetNoSizing(false)
			TextLabelsList:EnableVerticalScrollbar(true)
			TextLabelsList.Paint = function() end
			TextLabelsList:SetVisible(false)
			local txttable = string.Explode("\n",v.settings.text)
			if istable(txttable) then
				for _,m in pairs(txttable) do
					local text = vgui.Create("DLabel")
					text:SetText(m)
					text:SetFont(MOTD.Settings.TextTabFont)
					text:SizeToContents()
					if IsValid(text) then
						TextLabelsList:AddItem(text)
					end
				end
			end
			Button.DoClick = function()
				MOTD.ShowTabPanel(TextLabelsList, Button)
			end
			table.insert(MOTD.TabManager, {btn = Button, panel = TextLabelsList})
		elseif v.settings.steamurl then
			Button.DoClick = function()
				gui.OpenURL(v.settings.steamurl)
			end
			table.insert(MOTD.TabManager, {btn = Button})
		elseif v.settings.close then
			Button.DoClick = function()
				MOTD.CloseMOTD()
			end
			table.insert(MOTD.TabManager, {btn = Button})
		end
		MenuButtonList:AddItem(Button)
	end
	MOTD_MainWindow:MakePopup()
	local opentab = MOTD.Settings.OpenTab
	if MOTD.TabManager[opentab] then 
		MOTD.ShowTabPanel(MOTD.TabManager[opentab].panel,
		MOTD.TabManager[opentab].btn,MOTD.TabManager[opentab].url)
		if MOTD.Settings.MenuSounds then
			surface.PlaySound(MOTD.Settings.MenuOpenSound)
		end
	else
		MOTD.CloseMOTD()
	end
end
usermessage.Hook("MOTD_Open", MOTD.OpenMOTD)

function MOTD.ShowTabPanel(panel, btn, url)
	if !IsValid(MOTD_MainWindow) or !panel or !btn then return end
	for _,v in pairs(MOTD.TabManager) do
		if IsValid(v.panel) and IsValid(v.btn) then 
			v.panel:SetVisible(false)
			v.btn:ToggleSelect(false)
		end
	end
	btn:ToggleSelect(true)
	if url then
		panel:OpenURL(url)
	end
	panel:SetVisible(true)
	if MOTD.Settings.MenuSounds then
		surface.PlaySound(MOTD.Settings.ButtonClickSound)
	end
end

local xpos = 0
local lastsys = 0
local forward = true
local backwards = false
function MOTD.PaintMainWindow()
	if !IsValid(MOTD_MainWindow) then return end
	Derma_DrawBackgroundBlur(MOTD_MainWindow)
	surface.SetDrawColor(MOTD.Theme.WindowColor)
	MOTD.CurrentHeight = math.Approach(MOTD.CurrentHeight, ScrH() - 100, FrameTime() * 400)
	surface.DrawRect(0, 50, ScrW(), MOTD.CurrentHeight)
	surface.SetMaterial(MOTD.Theme.BannerMaterial)
	surface.SetDrawColor(MOTD.Theme.BannerColor)
	surface.DrawTexturedRect(0, 50, ScrW(), 75)
	draw.DrawText(MOTD.Settings.MOTDTitle, "MOTD_BebasNeue70", 10, 57, color_white, 0)
	surface.SetFont(MOTD.ScrollerFont)
	local w = surface.GetTextSize(MOTD.ScrollerText)
	draw.DrawText(MOTD.ScrollerText, MOTD.ScrollerFont, xpos, MOTD.ScrollerYPos, MOTD.Theme.ScrollerTextColor, 0)
	xpos = xpos + ((SysTime() - lastsys) * MOTD.ScrollerSpeed)
	if xpos > ScrW() then
		xpos = -w
	end
	lastsys = SysTime()
end

function MOTD.CloseMOTD()
	if IsValid(MOTD_MainWindow) then
		hook.Run("MOTDClosed", MOTD_MainWindow.FirstOpened)
		MOTD_MainWindow:Remove()
		if MOTD.Settings.MenuSounds then
			surface.PlaySound(MOTD.Settings.MenuCloseSound)
		end
	end
end

hook.Add("InitPostEntity", "MOTD_Open", function()
	if MOTD.Settings.ShowOnPlayerConnect then
		MOTD.OpenMOTD(true)
	end
end)

concommand.Add("motd", function()
	MOTD.OpenMOTD()
end)

hook.Add("OnPlayerChat", "MOTD_Open", function(ply, text)
	text = string.lower(text)
	if text == MOTD.ChatCommand then
		if ply != LocalPlayer() then return true end
		MOTD.OpenMOTD()
		return true
	end
end)