MOTD.Tabs = {}

function AddMOTDTab(title, tabsettings)
	if !title or !istable(tabsettings) or !tabsettings.color then
		error("Ungültiges MOTD-Tab \""..title.."\" Kein Link oder Panel spezifiziert oder gueltig.")
	end
	if !tabsettings.url and !tabsettings.steamurl and !tabsettings.panel and !tabsettings.text and !tabsettings.serverlist and !tabsettings.close then
		error("Ungültiges MOTD-Tab \""..title.."\" Kein Link oder Panel spezifiziert oder gueltig.")
	end
	table.insert(MOTD.Tabs, {title = title, settings = tabsettings})
end

MOTD.Servers = {}
function AddMOTDServer(title, serversettings)
	if !title or !istable(serversettings) or !serversettings.color then
		error("Ungültiger MOTD-Server \""..title.."\"-Einstellungen fehlend oder ungültig.")
	end
	if !serversettings.serveripport then
		error("Ungültiger MOTD-Server \""..title.."\" Server-IP/Port fehlt oder ist falsch..")
	end
	table.insert(MOTD.Servers, {title = title, settings = serversettings})
end