local ServerButtonPanel = {}
function ServerButtonPanel:Init()
	self:SetDrawBackground(false)
	self:SetDrawBorder(false)
	self.WSize = ScrW() / 3 + 90
	self:SetSize(self.WSize, 82)
	self.BackColor = Color(38, 41, 49, 255)
	self.TextColor = Color(255, 255, 255, 250)
	self.HoverColor = Color(23, 55, 94, 250)
	self.HoverTextColor = Color(142, 180, 227, 250)
	self.Hovering = false
	self.HeaderLbl = vgui.Create("DLabel", self)
	self.HeaderLbl:SetFont("MOTD_BebasNeue24")
	self.HeaderLbl:SetColor(self.TextColor)
	self.SubLbl = vgui.Create("DLabel", self)
	self.SubLbl:SetFont("MOTD_OpenSansC14")
	self.SubLbl:SetColor(self.TextColor)
	self.JoinLbl = vgui.Create("DLabel", self)
	self.JoinLbl:SetFont("MOTD_BebasNeue20")
	self.JoinLbl:SetColor(self.TextColor)
	self.JoinLbl:SetText("Server beitreten")
	self.JoinLbl:SizeToContents()
	self.HTMLImage = vgui.Create("DHTML", self)
	self.HTMLImage:SetSize(350, 20)
	self.HTMLImage:SetVisible(false)
end

function ServerButtonPanel:SetNoActionEnbaled()
	self.NoAction = true
	self.HoverColor = Color(0, 0, 0, 155)
	self.HeaderLbl:SetColor(Color(153, 153, 153, 90))
end

function ServerButtonPanel:SetColor(color)
	if !type(color) == "color" then return end
	self.HoverColor = color
	self.HoverTextColor = color
end

function ServerButtonPanel:SetText(text)
	self.HeaderLbl:SetText(text)
	self.HeaderLbl:SizeToContents()
end

function ServerButtonPanel:SetSubText(text)
	self.SubLbl:SetText(text)
	self.SubLbl:SizeToContents()
end

local GTBaseURL = "https://www.gametracker.com/server_info/%s/b_350_20_692108_381007_FFFFFF_000000.png"
function ServerButtonPanel:SetGametracker(ip)
	if !ip then return end
	self.HTMLImage:SetVisible(true)
	self.HTMLImage:SetScrollbars(false)
	self.HTMLImage:OpenURL(string.format(GTBaseURL, ip))
end

function ServerButtonPanel:PerformLayout()
	self.HTMLImage:SetPos(45, 50)
	self.HeaderLbl:SetPos(45, 12)
	self.SubLbl:SetPos(45, 28)
	self.JoinLbl:SetPos(self.WSize - 110, 12)
 end

function ServerButtonPanel:Paint()
	surface.SetDrawColor(self.BackColor)
	surface.DrawRect(0, 0, self:GetWide(), self:GetTall())
	if !self.Hovering then
		surface.SetDrawColor(self.BackColor)
	else
		surface.SetDrawColor(self.HoverColor)
	end
	surface.DrawRect(self.WSize - 115, 9, 150, 25)
end

function ServerButtonPanel:OnCursorEntered()
	self.Hovering = true
	if !self.NoAction and !self.CurrentSelection then
		self.HeaderLbl:SetColor(self.HoverTextColor)
	end
end

function ServerButtonPanel:OnCursorExited()
	self.Hovering = false
	if !self.NoAction and !self.CurrentSelection then
		self.HeaderLbl:SetColor(self.TextColor)
	end
end

derma.DefineControl("ModernServerButton", "Modern MOTD Server Selection Button", ServerButtonPanel, "DImageButton")