local include_sv = SERVER and include or function() end
local include_cl = SERVER and AddCSLuaFile or include
local include_sh = function(path) include_sv(path) include_cl(path) end

logs = logs or {}
logs.cfg = {}
logs.types	= {}
logs.data = {}

include_cl("mg_logs/lib/logs_draw.lua")
include_sh("mg_logs/cfg.lua")

include_sh("mg_logs/core_sh.lua")
include_sv("mg_logs/core_sv.lua")

include_cl("mg_logs/vgui/skin.lua")
include_cl("mg_logs/vgui/frame.lua")
include_cl("mg_logs/vgui/tablist.lua")

include_cl("mg_logs/menu.lua")

hook.Add("Initialize", "logs.Initialize", function()
	local files, _ = file.Find("mg_logs/hooks/*.lua", "LUA")
	for _, f in ipairs(files) do
		if logs.cfg.DisabledLogTypes[f:sub(1, f:len() - 4):lower()] then continue end
		print("[MG-Logs] Log-Kategorie hinzugefügt: \""..f.."\"")

		if string.find(f, "sv_") then
			include_sv("mg_logs/hooks/"..f)
		elseif string.find(f, "cl_") then
			include_cl("mg_logs/hooks/"..f)
		else
			include_sh("mg_logs/hooks/"..f)
		end
	end
end)

print("[MG-Logs] Logs geladen.")