-- Befehle zum Öffnen der Logs
logs.cfg.Commands = {
	["serverlogs"] = true,
	["logs"] = true,
	["log"] = true,
	["l"] = true
}

-- Superadmingruppe (Hat Zugriff auf Superadmin-Logs)
logs.cfg.Superadmins = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["superadmin"] = true
}

-- Admingruppe
logs.cfg.Admins = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["superadmin"] = true,
	["admin_vip"] = true,
	["admin"] = true,
	["moderator_vip"] = true,
	["moderator"] = true
}

-- Servereinstellungen

logs.cfg.MaxRows = 200 -- Maximale Logs, welche auf einmal angezeigt und geladen werden können
logs.cfg.OldestLogs = 14 * 24 * 60 * 60 -- Älteste Logs (Standard: 2 Wochen)
logs.cfg.ShowTeam = true -- Beruf hinter dem Namen anzeigen (Funktion NameID kann in core_sv.lua erweitert werden)

-- Standardeinstellungen vom Spieler

logs.cfg.UseColors = true
logs.cfg.Width = 0.75
logs.cfg.Height = 0.75

-- Logtypen, welche nicht geladen werden sollen
logs.cfg.DisabledLogTypes = {
}

-- Logdateien, welche nicht geladen werden sollen
logs.cfg.DisabledLogFiles = {
}

-- Werkzeuge, welche kein Logging benötigen
logs.cfg.ToolBlacklist = {
	["inflator"] = true,
	["paint"] = true
}