logs.Register("Aufträge", false, Color(255, 200, 0))

logs.AddHook("onHitAccepted", function(hitman, ta, customer)
	logs.Log("Aufträge", hitman:NameID().." hat einen Tötungsauftrag auf "..ta:NameID().." von "..customer:NameID().." akzeptiert", {
		["Name des Auftragmörders"] = hitman:Name(),
		["SteamID des Auftragmörders"] = hitman:SteamID(),
		["Name des Tötungsziels"] = ta:Name(),
		["SteamID des Tötungsziels"] = ta:SteamID(),
		["Name des Auftraggebers"] = customer:Name(),
		["SteamID des Auftraggebers"] = customer:SteamID()
	})
end)

logs.AddHook("onHitCompleted", function(hitman, ta, customer)
	logs.Log("Aufträge", hitman:NameID().." hat den Tötungsauftrag auf "..ta:NameID().." von "..(IsValid(customer) and customer:NameID() or "einem unbekannten Spieler").." erfolgreich ausgeführt", {
		["Name des Auftragmörders"] = hitman:Name(),
		["SteamID des Auftragmörders"] = hitman:SteamID(),
		["Name des Opfers"] = ta:Name(),
		["SteamID des Opfers"] = ta:SteamID(),
		["Name des Auftraggebers"] = IsValid(customer) and customer:Name() or nil,
		["SteamID des Auftraggebers"] = IsValid(customer) and customer:SteamID() or nil
	})
end)

logs.AddHook("onHitFailed", function(hitman, ta)
	logs.Log("Aufträge", hitman:NameID().." konnte den Tötungsauftrag auf "..ta:NameID().." nicht erfolgreich ausführen" , {
		["Name des Auftragmörders"] = hitman:Name(),
		["SteamID des Auftragmörders"] = hitman:SteamID(),
		["Name des Tötungsziels"] = ta:Name(),
		["SteamID des Tötungsziels"] = ta:SteamID()
	})
end)

logs.Register("RP-Name", false, Color(150, 255, 100))

logs.AddHook("onPlayerChangedName", function(ply, old, new)
	logs.Log("RP-Name", ply:NameID().." hat seinen Namen von "..old.. " zu "..new.." geändert", {
		["Neuer Name"] = new,
		["Alter Name"] = old,
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("AFK", false, Color(150, 0, 200))

logs.AddHook("playerSetAFK", function(ply, afk)
	logs.Log("AFK", afk and (ply:NameID().." ist AFK gegangen") or (ply:NameID().." ist nicht länger AFK"), {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("Jobwechsel", false, Color(255, 150, 0))

logs.AddHook("OnPlayerChangedTeam", function(ply, old, new)
	if old == new then return end
	logs.Log("Jobwechsel", ply:NameID().." hat seinen Job von "..team.GetName(old).. " zu "..team.GetName(new).." gewechselt", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("Degradierung", false, Color(255, 150, 255))

logs.AddHook("onPlayerStartDemote", function(demoter, demotee, reason)
	logs.Log("Degradierung", demoter:NameID().." hat eine Degradierung für "..demotee:NameID().." aufgrund \""..(reason or "Fehlerhafter Grund").."\" gestartet", {
		["Name des Degradierten"] = demotee:Name(),
		["SteamID des Degradierten"] = demotee:SteamID(),
		["Name des Degradierenden"] = demoter:Name(),
		["SteamID des Degradierenden"] = demoter:SteamID()
	})
end)

logs.AddHook("onPlayerDemoted", function(demoter, demotee, reason, success)
	if success then
		if IsValid(demoter) then
			logs.Log("Degradierung", demoter:NameID().." hat "..demotee:NameID().." aufgrund \""..(reason or "Fehlerhafter Grund").."\" degradieren lassen", {
				["Name des Degradierten"] = demotee:Name(),
				["SteamID des Degradierten"] = demotee:SteamID(),
				["Name des Degradierenden"] = demoter:Name(),
				["SteamID des Degradierenden"] = demoter:SteamID()
			})
		else
			logs.Log("Degradierung", demotee:NameID().." wurde aufgrund von \""..(reason or "Fehlerhafter Grund").."\" degradiert", {
				["Name des Degradierten"] = demotee:Name(),
				["SteamID des Degradierten"] = demotee:SteamID()
			})
		end
	else
		logs.Log("Degradierung", demotee:NameID().." wurde nicht degradiert", {
			["Name des Degradierten"] = demotee:Name(),
			["SteamID des Degradierten"] = demotee:SteamID()
		})
	end
end)

logs.AddHook("onPlayerFired", function(ply, target, reason)
	reason = reason or "Fehlerhafter Grund"
	logs.Log("Degradierung", ply:NameID().." hat "..target:NameID().." aufgrund  \""..reason.."\" gekündigt", {
		["Name des Gefeuerten"] = target:Name(),
		["SteamID des Gefeuerten"] = target:SteamID(),
		["Name des Feuernden"] = ply:Name(),
		["SteamID des Feuernden"] = ply:SteamID(),
		["Grund"] = reason
	})
end)

logs.Register("Polizei", false, Color(50, 100, 255))

logs.AddHook("playerArrested", function(ta, time, off)
	if IsValid(off) and IsValid(ta) then
		logs.Log("Polizei", off:NameID().." hat "..ta:NameID().." inhaftiert", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"] = off:SteamID(),
			["Name des Inhaftierten"] = ta:Name(),
			["SteamID des Inhaftierten"] = ta:SteamID()
		})
	end
end)

logs.AddHook("playerUnArrested", function(ta, off)
	if IsValid(off) then
		logs.Log("Polizei", off:NameID().." hat "..ta:NameID().." aus der Haft entlassen", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"] = off:SteamID(),
			["Name des Häftlings"] = ta:Name(),
			["SteamID des Häftlings"] = ta:SteamID()
		})
	else
		logs.Log("Polizei", ta:NameID().." wurde aus dem Gefängnis entlassen.", {
			["Name"] = ta:Name(),
			["SteamID"]	= ta:SteamID()
		})
	end
end)

logs.AddHook("playerWanted", function(ta, off, reason)
	reason = reason or "Fehlerhafter Grund"
	if IsValid(off) then
		logs.Log("Polizei", off:NameID().." hat eine Fahndung auf "..ta:NameID().." mit dem Grund \""..reason.."\" aufgegeben", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"] = off:SteamID(),
			["Name des Ziels"] = ta:Name(),
			["SteamID des Ziels"] = ta:SteamID(),
			["Grund"] = reason
		})
	else
		logs.Log("Polizei", ta:NameID().." wird nun mit dem Grund \""..reason.."\" gefahndet", {
			["Name"] = ta:Name(),
			["SteamID"] = ta:SteamID(),
			["Grund"] = reason
		})
	end
end)

logs.AddHook("playerUnWanted", function(ta, off)
	if IsValid(off) then
		logs.Log("Polizei", off:NameID().." hat die Fahndung von "..ta:NameID().." eingestellt", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"] = off:SteamID(),
			["Name des Ziels"] = ta:Name(),
			["SteamID des Ziels"] = ta:SteamID()
		})
	else
		logs.Log("Polizei", ta:NameID().."s Fahndung wurde eingestellt", {
			["Name"] = ta:Name(),
			["SteamID"]	= ta:SteamID()
		})
	end
end)

logs.AddHook("playerWarranted", function(ta, off, reason)
	reason = reason or "Fehlerhafter Grund"
	if IsValid(off) then
		logs.Log("Polizei", off:NameID().." hat einen Durchsuchungsbefehl auf "..ta:NameID().." mit dem Grund \""..reason.."\" aufgegeben", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"]	= off:SteamID(),
			["Name des Ziels"] = ta:Name(),
			["SteamID des Ziels"] = ta:SteamID(),
			["Grund"] = reason
		})
	else
		logs.Log("Polizei", "Ein Durchsuchungsbefehl wurde auf "..ta:NameID().." mit dem Grund \""..reason.."\" aufgegeben", {
			["Name des Ziels"] = ta:Name(),
			["SteamID des Ziels"] = ta:SteamID(),
			["Grund"] = reason
		})
	end
end)

logs.AddHook("playerUnWarranted", function(ta, off)
	if IsValid(off) then
		logs.Log("Polizei", off:NameID().." hat den Durchsuchungsbefehl auf "..ta:NameID().." aufgehoben", {
			["Name des Beamten"] = off:Name(),
			["SteamID des Beamten"] = off:SteamID(),
			["Name des Ziels"] = ta:Name(),
			["SteamID des Ziels"] = ta:SteamID()
		})
	else
		logs.Log("Polizei", ta:NameID().."\"s Durchsuchungsbefehl ist abgelaufen", {
			["Name"] = ta:Name(),
			["SteamID"]	= ta:SteamID()
		})
	end
end)

logs.AddHook("playerWeaponsChecked", function(ply, ent)
	if !IsValid(ply) then return end
	logs.Log("Polizei", ply:NameID().." hat "..ent:NameID().." nach Waffen durchsucht", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Durchsuchten"] = ent:Name(),
		["SteamID des Durchsuchten"] = ent:SteamID()
	})
end)

logs.AddHook("playerWeaponsConfiscated", function(ply, ent)
	if !IsValid(ply) then return end
	logs.Log("Polizei", ply:NameID().." hat die Waffen von "..ent:NameID().." konfisziert", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Durchsuchten"] = ent:Name(),
		["SteamID des Durchsuchten"] = ent:SteamID()
	})
end)

logs.AddHook("playerWeaponsReturned", function(ply, ent)
	if IsValid(ply) then
		logs.Log("Polizei", ply:NameID().." hat die Waffen von "..ent:NameID().." zurückgegeben", {
			["Name des Beamten"] = ply:Name(),
			["SteamID des Beamten"] = ply:SteamID(),
			["Name des Durchsuchten"] = ent:Name(),
			["SteamID des Durchsuchten"] = ent:SteamID()
		})
	end
end)

logs.AddHook("onDoorRamUsed", function(success, ply, trace)
	if !success then return end
	local ent = trace.Entity
	if !IsValid(ent) then return end
	local type_str
	if ent:GetClass() == "prop_physics" then
		type_str = "ein Prop mit Modell \""..ent:GetModel().."\""
	elseif ent:IsVehicle() then
		local veh_name = ent:GetVehicleClass()
		if list.Get("Vehicles")[veh_name] then
			type_str = list.Get("Vehicles")[veh_name].Name
		else
			type_str = "das Auto"
		end
	elseif ent:isDoor() then
		type_str = "eine Tür"
	elseif ent.isFadingDoor then
		type_str = "eine Fading Door"
	else
		type_str = ent.PrintName or ent:GetClass()
	end
	local owner = ent.getDoorOwner and IsValid(ent:getDoorOwner()) and ent:getDoorOwner() or ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) and ent:CPPIGetOwner()
	logs.Log("Polizei", ply:NameID().." hat "..type_str.." von "..logs.ResolveOwner(owner, "Niemandem", ply).." mithilfe des Rammbocks "..((type_str == "eine Tür" or type_str == "eine Fading Door") and "geöffnet" or "gelöst"), {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("ballistic_shields_dbreach", function(ply, ent)
	local type_str
	if ent:isDoor() then
		type_str = "eine Tür"
	else
		type_str = "eine Fading Door"
	end
	local owner = ent.getDoorOwner and IsValid(ent:getDoorOwner()) and ent:getDoorOwner() or ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) and ent:CPPIGetOwner()
	logs.Log("Polizei", ply:NameID().." hat "..type_str.." von "..logs.ResolveOwner(owner, "Niemandem", ply).." mithilfe des schweren Schilds geöffnet", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("MG_Trunk_DoorRamOpen", function(ply, ent)
	local owner
	if (ent.getDoorOwner and IsValid(ent:getDoorOwner())) then
		owner = ent:getDoorOwner()
	end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "Auto"
	end
	logs.Log("Polizei", ply:NameID().." hat den Kofferraum vom "..veh_name.." von "..logs.ResolveOwner(owner, "Niemandem", ply).." mittels des Rammbocks aufgebrochen", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Grundstück-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Grundstück-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("onPlayerTasered", function(ply, ta)
	logs.Log("Polizei", ply:NameID().." hat "..ta:NameID().." getasert", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Ziels"] = ta:Name(),
		["SteamID des Ziels"] = ta:SteamID(),
		["Waffe des Ziels"] = ply.Ragdoll_OldWep
	})
end)

logs.AddHook("onTaserUsed", function(ply)
	logs.Log("Polizei", ply:NameID().." hat den Taser benutzt und verfehlt", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID()
	})
end)

logs.AddHook("onStoppedVehicle", function(ply, ent)
	if !ent:IsVehicle() then return end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Polizei", ply:NameID().." hat "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." mit dem EMP angehalten", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onPlayerUsedArmory", function(ply)
	logs.Log("Polizei", ply:NameID().." hat sich am Arsenal ausgerüstet", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerUsedAmmoCrate", function(ply)
	logs.Log("Polizei", ply:NameID().." hat das Munitionslager benutzt", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("lockdownStarted", function(ply)
	if IsValid(ply) then
		logs.Log("Polizei", ply:NameID().." hat einen Lockdown ausgerufen", {
			["Name"] = ply:Name(),
			["SteamID"] = ply:SteamID()
		})
	else
		logs.Log("Polizei", "Ein Lockdown wurde ausgerufen")
	end
end)

logs.AddHook("lockdownEnded", function(ply)
	if IsValid(ply) then
		logs.Log("Polizei", ply:NameID().." hat den Lockdown beendet", {
			["Name"] = ply:Name(),
			["SteamID"] = ply:SteamID()
		})
	else
		logs.Log("Polizei", "Der Lockdown wurde beendet")
	end
end)

logs.AddHook("MG_SeizeReward.BeginSeizeEntity", function(ply, ent)
	local owner = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	logs.Log("Polizei", ply:NameID().." hat angefangen, "..(ent.PrintName or ent:GetClass()).." von "..logs.ResolveOwner(owner, "Niemandem", ply).." zu konfiszieren", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("MG_SeizeReward.SeizeEntity", function(plys, ent)
	local copy = {
		["Name des Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	}
	for _, ply in ipairs(plys) do
		copy["Mitwirkende Beamte"] = copy["Mitwirkende Beamte"] or {}
		copy["Mitwirkende Beamte"][ply:Name()] = ply:SteamID()
	end
	local owner = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	logs.Log("Polizei", (ent.PrintName or ent:GetClass()).." von "..logs.ResolveOwner(owner, "Niemandem", ply).." wurde erfolgreich konfisziert", copy)
end)

logs.AddHook("MG_SeizeReward.StopSeizeEntity", function(ply, ent)
	local owner = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	logs.Log("Polizei", ply:NameID().." hat die Konfiszierung von "..(ent.PrintName or ent:GetClass()).." von "..logs.ResolveOwner(owner, "Niemandem", ply).." abgebrochen", {
		["Name der Person"] = ply:Name(),
		["SteamID der Person"] = ply:SteamID(),
		["Name des Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("Economy_HostageMoneyTaken", function(ply, amount)
	if IsValid(ply) then
		logs.Log("Polizei", ply:NameID().." hat $"..string.Comma(amount).." von der Geiselkasse abgehoben", {
			["Name"] = ply:Name(),
			["SteamID"] = ply:SteamID()
		})
	end
end)

logs.AddHook("MGFinesystem_answeredFine", function(ply, actor, answer)
	if IsValid(ply) then
		if answer then
			logs.Log("Polizei", ply:NameID().." hat seinen Strafzettel bezahlt", {
				["Name"] = ply:Name(),
				["SteamID"] = ply:SteamID()
			})
		else
			logs.Log("Polizei", ply:NameID().." hat seinen Strafzettel abgelehnt", {
				["Name"] = ply:Name(),
				["SteamID"] = ply:SteamID()
			})
		end
	end
end)

logs.AddHook("MGFinesystem_issuedFine", function(ply, target, reason, sum)
	if IsValid(ply) and IsValid(target) then
		logs.Log("Polizei", ply:NameID().." hat einen Strafzettel in Höhe von $"..string.Comma(sum).." ("..reason..") gegem "..target:NameID().." ausgestellt", {
			["Name des Beamten"] = ply:Name(),
			["SteamID des Beamten"] = ply:SteamID(),
			["Name des Ziels"] = target:Name(),
			["SteamID des Ziels"] = target:SteamID(),
		})
	end
end)

logs.Register("Obdachloser", false, Color(155, 120, 90))

logs.AddHook("onBootThrown", function(ply)
	logs.Log("Obdachloser", ply:NameID().." hat einen Schuh geworfen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("onPiss", function(ply)
	logs.Log("Obdachloser", ply:NameID().." hat angefangen, zu pinkeln", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("onPissStop", function(ply)
	logs.Log("Obdachloser", ply:NameID().." hat aufgehört, zu pinkeln", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("Dumpster_FindSomething", function(ply, ent)
	if !IsValid(ent) then return end
	ent = ent:GetClass() == "spawned_weapon" and ent:GetWeaponClass() or ent.GetPrintName and ent:GetPrintName() or ent.PrintName or ent:GetClass()
	logs.Log("Obdachloser", ply:NameID().." hat "..ent.." in der Mülltone gefunden", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("Dumpster_FindMoney", function(ply, amt)
	logs.Log("Obdachloser", ply:NameID().." hat $"..string.Comma(amt).." in der Mülltone gefunden", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("Dumpster_FindNothing", function(ply)
	logs.Log("Obdachloser", ply:NameID().." hat nichts in der Mülltone gefunden", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("Finanzen", false, Color(0, 200, 0))

logs.AddHook("playerBoughtCustomEntity", function(ply, ent_tbl, ent, price)
	logs.Log("Finanzen", ply:NameID().." hat "..ent_tbl.name.." für $"..string.Comma(price or ent_tbl.price).." erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerBoughtShipment", function(ply, ent_tbl, ent, price)
	logs.Log("Finanzen", ply:NameID().." hat "..ent_tbl.name.." für $"..string.Comma(price or ent_tbl.price).." erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerBoughtPistol", function(ply, ent_tbl, ent, price)
	logs.Log("Finanzen", ply:NameID().." hat "..ent_tbl.name.." für $"..string.Comma(price or ent_tbl.price).." erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerBoughtAmmo", function(ply, ent_tbl, ent, price)
	logs.Log("Finanzen", ply:NameID().." hat "..ent_tbl.name.." für $"..string.Comma(price or ent_tbl.price).." erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerBoughtSeeds", function(ply, npc, name, cost)
	logs.Log("Finanzen", ply:NameID().." hat "..name.." für $"..string.Comma(cost).." erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerPickedUpMoney", function(ply, amt)
	logs.Log("Finanzen", ply:NameID().." hat $"..string.Comma(amt).." aufgehoben", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("playerGaveMoney", function(ply, ta, amt)
	logs.Log("Finanzen", ply:NameID().." hat "..ta:NameID().." $"..string.Comma(amt).." gegeben", {
		["Name des Geldgebers"] = ply:Name(),
		["SteamID des Geldgebers"] = ply:SteamID(),
		["Name des Empfängers"] = ta:Name(),
		["SteamID des Empfängers"] = ta:SteamID()
	})
end)

logs.AddHook("playerDroppedMoney", function(ply, amt)
	logs.Log("Finanzen", ply:NameID().." hat $"..string.Comma(amt).." fallen gelassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID(),
	})
end)

logs.AddHook("playerPickedUpCheque", function(ta, ply, amt, succ)
	if succ then
		logs.Log("Finanzen", ta:NameID().." hat einen Check im Wert von $"..string.Comma(amt).." aufgehoben", {
			["Name"] = ta:Name(),
			["SteamID"] = ta:SteamID()
		})
	end
end)

logs.AddHook("playerDroppedCheque", function(ply, ta, amt)
	logs.Log("Finanzen", ply:NameID().." hat einen Check im Wert von $"..string.Comma(amt).." für "..ta:NameID().." ausgestellt und fallen gelassen", {
		["Name des Absenders"] = ply:Name(),
		["SteamID des Absenders"] = ply:SteamID(),
		["Name des Empfängers"] = ta:Name(),
		["SteamID des Empfängers"] = ta:SteamID()
	})
end)

logs.AddHook("donation_box_addmoney", function(ent, money, amount)
	local owner = IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	local ownername = IsValid(owner) and owner:NameID() or "Niemandem"
	logs.Log("Finanzen", "Jemand hat $"..string.Comma(amount).." in die Spendentruhe von "..ownername.." gelegt", {
		["Besitzer"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("donation_box_empty", function(ent, ply, money)
	logs.Log("Finanzen", ply:NameID().." hat $"..string.Comma(money).." aus seiner Spendentruhe genommen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("MoneyPrinter_TakeMoney", function(ply, printer, worth)
	local owner = IsValid(printer:Getowning_ent()) and printer:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat $"..string.Comma(worth).." vom Gelddrucker von "..logs.ResolveOwner(owner, "Niemandem", ply).." abgehoben", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("MoneyPrinter_BuyMod", function(ply, printer, _, mod)
	local owner = IsValid(printer:Getowning_ent()) and printer:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat "..mod.Name.." für $"..string.Comma(mod.Price).." für Gelddrucker von "..logs.ResolveOwner(owner, "Niemandem", ply).." gekauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("MoneyPrinter_SellMod", function(ply, printer, _, mod)
	local owner = IsValid(printer:Getowning_ent()) and printer:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat "..mod.Name.." für $"..string.Comma(mod.Price).." von Gelddrucker von "..logs.ResolveOwner(owner, "Niemandem", ply).." verkauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("WeedPlant_OnSell", function(ply, plant, worth)
	local owner = IsValid(plant:Getowning_ent()) and plant:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat eine Marihuanapflanze im Wert von $"..string.Comma(worth).." von "..logs.ResolveOwner(owner, "Niemandem", ply).." verkauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("WeedPlant_OnDestroy", function(ply, plant)
	local owner = IsValid(plant:Getowning_ent()) and plant:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat eine Marihuanapflanze im Wert von $"..string.Comma(plant:GetSellAmount()).." von "..logs.ResolveOwner(owner, "Niemandem", ply).." zerstört", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerSoldStuff", function(ply, sold)
	logs.Log("Finanzen", ply:NameID().." hat Gegenstände im Wert von $"..string.Comma(sold).." beim Pflanzenmarkt verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("onPlayerSoldSeeds", function(ply, sold)
	logs.Log("Finanzen", ply:NameID().." hat Gegenstände im Wert von $"..string.Comma(sold).." beim Pflanzenmarkt verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("onPlayerDestroyedPlot", function(ply, plot)
	local owner = IsValid(plot:Getowning_ent()) and plot:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat ein Beet von "..logs.ResolveOwner(owner, "Niemandem", ply).." zerstört", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("zrush_OnFuelSold", function(ply, amt, id, sold)
	logs.Log("Finanzen", ply:NameID().." hat Öl im Wert von $"..string.Comma(sold).." bei Big Jim verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("zrush_OnMachineCrateSold", function(ply, sold, ent, machine)
	logs.Log("Finanzen", ply:NameID().." hat "..(machine.name or "Etwas").." am Maschinenbaukasten für $"..string.Comma(sold).." verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("zmlab_OnSellMeth", function(ply, ent, sold)
	logs.Log("Finanzen", ply:NameID().." hat Meth im Wert von $"..string.Comma(sold).." bei einem Meth Abwurfpunkt verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("zmlab_OnMethMade", function(ply, tray, meth)
	logs.Log("Finanzen", ply:NameID().." hat Meth ("..string.Comma(meth:GetMethAmount()).."g) hergestellt", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("Mining_SellOres", function(ply, sold)
	logs.Log("Finanzen", ply:NameID().." hat Erze im Wert von $"..string.Comma(sold).." an der Verkaufskiste verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("Mining_BuyUpgrade", function(ply, crate, _, tbl, price, lvl)
	local owner = IsValid(crate:Getowning_ent()) and crate:Getowning_ent()
	logs.Log("Finanzen", ply:NameID().." hat "..tbl.Name.." Lv. "..lvl.." für $"..string.Comma(price).." für Bergbaukiste von "..logs.ResolveOwner(owner, "Niemandem", ply).." gekauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerBailed", function(ply, lawyer, amt)
	logs.Log("Finanzen", ply:NameID().." hat "..lawyer:NameID().." $"..string.Comma(amt).." für eine Kaution bezahlt", {
		["Name des Freigelassenen"] = ply:Name(),
		["SteamID des Freigelassenen"] = ply:SteamID(),
		["Name des Anwalts"] = lawyer:Name(),
		["SteamID des Anwalts"] = lawyer:SteamID()
	})
end)

logs.AddHook("PS_OnBuyItem", function(ply, item_id, amt)
	logs.Log("Finanzen", ply:NameID().." hat "..item_id.." für $"..string.Comma(amt).." gekauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("PS_OnSellItem", function(ply, item_id, amt)
	logs.Log("Finanzen", ply:NameID().." hat "..item_id.." für $"..string.Comma(amt).." verkauft", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onDealerSoldEntity", function(ply, ent, price)
	local class = ent:GetClass()
	local ent_name = ent.PrintName or class
	local owned_by = ""
	local oldplayer = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	if class == "spawned_shipment" then
		local contents = CustomShipments[ent:Getcontents()].entity
		if contents then
			local wep = weapons.Get(contents)
			ent_name = "Shipment ("..(wep and (wep.PrintName or wep.ClassName) or "Waffe").." x"..ent:Getcount()..")"
		end
	elseif class == "spawned_weapon" then
		local wep = weapons.Get(ent:GetWeaponClass())
		if wep then
			ent_name = (wep and (wep.PrintName or wep.ClassName) or "Waffe").." (x"..ent:Getamount()..")"
		end
	else
		owned_by = " von "..logs.ResolveOwner(oldplayer, "Niemandem", ply)
	end
	logs.Log("Finanzen", ply:NameID().." hat "..ent_name..""..owned_by.." für $"..string.Comma(price).." beim Händler verkauft", {
		["Name des Verkäufers"] = ply:Name(),
		["SteamID des Verkäufers"] = ply:SteamID(),
		["Name des alten Besitzers"] = IsValid(oldplayer) and oldplayer:Name() or nil,
		["SteamID des alten Besitzers"] = IsValid(oldplayer) and oldplayer:SteamID() or nil
	})
end)

logs.AddHook("DON:MoneyWon", function(ply, money)
	logs.Log("Finanzen", ply:NameID().." hat bei Double or Nothing $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("DON:JackpotWon", function(ply, money)
	logs.Log("Finanzen", ply:NameID().." hat bei Double or Nothing den Jackpot mit $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("mr.payout", function(ply, money)
	logs.Log("Finanzen", ply:NameID().." hat im Roulette $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("MG_Blackjack_OnBlackjackPayout", function(ply, _, money)
	logs.Log("Finanzen", ply:NameID().." hat bei Blackjack $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("WOL_Win", function(ply, money)
	logs.Log("Finanzen", ply:NameID().." hat beim Wheel of Luck $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("WOL_Jackpot", function(ply, money)
	logs.Log("Finanzen", ply:NameID().." hat beim Wheel of Luck den Jackpot mit $"..string.Comma(money).." gewonnen", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("NLR", false, Color(100, 100, 100))

logs.AddHook("onPlayerEnteredNLR", function(ply)
	logs.Log("NLR", ply:NameID().." hat seine NLR-Zone betreten", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerExitedNLR", function(ply)
	logs.Log("NLR", ply:NameID().." hat seine NLR-Zone verlassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.Register("Inventar", false, Color(0, 255, 255))

logs.AddHook("PlayerPickupDarkRPWeapon", function(ply, sw, rw)
	logs.Log("Inventar", ply:NameID().." hat "..(rw.PrintName or rw:GetClass()).." vom Boden aufgehoben", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onDarkRPWeaponDropped", function(ply, sw, rw)
	logs.Log("Inventar", ply:NameID().." hat "..(rw.PrintName or rw:GetClass()).." auf den Boden fallen gelassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("MG_Trunk_OnStoreEntity", function(ply, ent, veh)
	local veh_name = veh:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "Auto"
	end
	local ent_name = ent.PrintName or ent:GetClass()
	logs.Log("Inventar", ply:NameID().." hat "..ent_name.." in den Kofferraum vom "..veh_name.." gelegt", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("MG_Trunk_OnTakeOutEntity", function(ply, ent, veh)
	local veh_name = veh:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "Auto"
	end
	local ent_name = ent.PrintName or ent:GetClass()
	logs.Log("Inventar", ply:NameID().." hat "..ent_name.." aus dem Kofferraum vom "..veh_name.." genommen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPocketItemAdded", function(ply, ent)
	logs.Log("Inventar", ply:NameID().." hat "..(ent.PrintName or ent:GetClass()).." in seine Tasche aufgenommen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPocketItemDropped", function(ply, ent)
	logs.Log("Inventar", ply:NameID().." hat "..(ent.PrintName or ent:GetClass()).." aus seiner Tasche fallen gelassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("ItemStoreUsedItem", function(ply, item)
	if !item then return end
	local itemname = item:GetName() or item.Name
	logs.Log("Inventar", ply:NameID().." hat "..itemname.." im Inventar benutzt", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("ItemStorePickUpItem", function(ply, item)
	if !item then return end
	local itemname = item:GetName() or item.Name
	logs.Log("Inventar", ply:NameID().." hat "..itemname.." in seinem Inventar verstaut", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("ItemStorePickUpWeapon", function(ply, wep, item)
	if !item then return end
	local itemname = item:GetName() or item.Name
	logs.Log("Inventar", ply:NameID().." hat "..itemname.." in seinem Inventar verstaut", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("ItemStoreDroppedItem", function(ply, item)
	if !item then return end
	local itemname = item:GetName() or item.Name
	logs.Log("Inventar", ply:NameID().." hat "..itemname.." aus dem Inventar fallen gelassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("ItemStoreDestroyedItem", function(ply, item)
	if !item then return end
	local itemname = item:GetName() or item.Name
	logs.Log("Inventar", ply:NameID().." hat "..itemname.." im Inventar zerstört", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerChangedHealth", function(ply, amount, self)
	logs.Log("Inventar", ply:NameID().." hat "..self.PrintName.." ("..amount.."%) benutzt", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerEquippedArmor", function(ply, amount, self)
	logs.Log("Inventar", ply:NameID().." hat "..self.PrintName.." ("..amount.."%) ausgerüstet", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerTookAmmo", function(ply, wep, amount)
	logs.Log("Inventar", ply:NameID().." hat "..amount.." Munition von "..(wep.Primary.PrintName or wep.ClassName).." entnommen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerDroppedAmmo", function(ply, wep, ammo)
	logs.Log("Inventar", ply:NameID().." hat "..ammo.amountGiven.." Munition von "..wep:GetPrintName().." fallen gelassen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("onPlayerPickedUpSeeds", function(ply, id)
	logs.Log("Inventar", ply:NameID().." hat "..FarmingAddon.GetSeedName(id).." aufgehoben", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.Register("Immobilien", false, Color(0, 200, 0))

logs.AddHook("playerBoughtDoor", function(ply, ent)
	logs.Log("Immobilien", ply:NameID().." hat eine Tür erworben", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.AddHook("playerSellDoor", function(ply, ent)
	logs.Log("Immobilien", ply:NameID().." hat eine Tür verkauft", {
		["Name"] = ply:Name(),
		["SteamID"]	= ply:SteamID()
	})
end)

logs.Register("Fesseln", false, Color(50, 200, 200))

logs.AddHook("Cuffs_OnPlayerHandcuffing", function(ply, targ, rag, first)
	if !first then return end
	logs.Log("Fesseln", ply:NameID().." hat angefangen "..targ:NameID().." zu fesseln", {
		["Name des Fesselnden"] = ply:Name(),
		["SteamID des Fesselnden"] = ply:SteamID(),
		["Name des Gefesselten"] = targ:Name(),
		["SteamID des Gefesselten"] = targ:SteamID()
	})
end)

logs.AddHook("Cuffs_OnPlayerHandcuffed", function(ply, targ)
	logs.Log("Fesseln", ply:NameID().." hat "..targ:NameID().." gefesselt", {
		["Name des Fesselnden"] = ply:Name(),
		["SteamID des Fesselnden"] = ply:SteamID(),
		["Name des Gefesselten"] = targ:Name(),
		["SteamID des Gefesselten"] = targ:SteamID()
	})
end)

logs.AddHook("Cuffs_AttemptBreak", function(ply, wep)
	if wep:GetCuffBroken() <= 0 and (ply.Logs_LastAttemptBreak or 0) < CurTime() then
		ply.Logs_LastAttemptBreak = CurTime() + 2
		logs.Log("Fesseln", ply:NameID().." hat angefangen, sich selbst zu befreien", {
			["Name"] = ply:Name(),
			["SteamID"]	= ply:SteamID()
		})
	end
end)

logs.AddHook("Cuffs_OnHandcuffBreak", function(ply, cuffs, friend)
	if IsValid(friend) then
		logs.Log("Fesseln", friend:NameID().." hat "..ply:NameID().." entfesselt", {
			["Name des Gefesselten"] = ply:Name(),
			["SteamID des Gefesselten"] = ply:SteamID(),
			["Name des Helfers"] = friend:Name(),
			["SteamID des Helfers"] = friend:SteamID()
		})
	else
		logs.Log("Fesseln", ply:NameID().." hat sich selbst entfesselt", {
			["Name"] = ply:Name(),
			["SteamID"]	= ply:SteamID()
		})
	end
end)

logs.Register("Diebstahl", false, Color(180, 50, 255))

logs.AddHook("onPlayerStartedStealing", function(ply, ta)
	logs.Log("Diebstahl", ply:NameID().." hat angefangen "..ta:NameID().." zu bestehlen", {
		["Name des Diebs"] = ply:Name(),
		["SteamID des Diebs"] = ply:SteamID(),
		["Name des Opfers"] = ta:Name(),
		["SteamID des Opfers"] = ta:SteamID()
	})
end)

logs.AddHook("onPlayerStoleMoney", function(ply, ta, money)
	logs.Log("Diebstahl", ply:NameID().." hat "..ta:NameID().." $"..string.Comma(money).." gestohlen", {
		["Name des Diebs"] = ply:Name(),
		["SteamID des Diebs"] = ply:SteamID(),
		["Name des Opfers"] = ta:Name(),
		["SteamID des Opfers"] = ta:SteamID()
	})
end)

logs.AddHook("onPlayerStoleWeapon", function(ply, ta, wep)
	if !IsValid(wep) then return end
	local n = wep:GetClass()
	if wep.PrintName then
		n = wep.PrintName
	end
	logs.Log("Diebstahl", ply:NameID().." hat "..ta:NameID().." "..n.." gestohlen", {
		["Name des Diebs"] = ply:Name(),
		["SteamID des Diebs"] = ply:SteamID(),
		["Name des Opfers"] = ta:Name(),
		["SteamID des Opfers"] = ta:SteamID()
	})
end)

logs.AddHook("MG_Trunk_LockpickOpen", function(ply, ent)
	local owner
	if ent.getDoorOwner and IsValid(ent:getDoorOwner()) then
		owner = ent:getDoorOwner()
	end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "Auto"
	end
	logs.Log("Diebstahl", ply:NameID().." hat den Kofferraum vom "..veh_name.." von "..logs.ResolveOwner(owner, "Niemandem", ply).." aufgebrochen", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Grundstück-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Grundstück-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("donation_box_lockpickcompleted", function(ply, succ, ent, money)
	owner = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	logs.Log("Diebstahl", ply:NameID().." hat die Spendentruhe von "..logs.ResolveOwner(owner, "Niemandem", ply)..((succ and " aufgebrochen und "..(money and "$"..string.Comma(money) or "nichts").." erbeutet") or " angebrochen"), {
		["Name des Verbrechers"] = ply:Name(),
		["SteamID des Verbrechers"] = ply:SteamID(),
		["Name des Spendentruhen-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Spendentruhen-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("zrush_LockpickMachine", function(ply, ent)
	owner = ent.Getowning_ent and IsValid(ent:Getowning_ent()) and ent:Getowning_ent()
	logs.Log("Diebstahl", ply:NameID().." hat die Sicherung von "..ent.PrintName.." von "..logs.ResolveOwner(owner, "Niemandem", ply).." geknackt", {
		["Name des Verbrechers"] = ply:Name(),
		["SteamID des Verbrechers"] = ply:SteamID(),
		["Name des Spendentruhen-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Spendentruhen-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("onPlayerRobbedEconomyBank", function(ply)
	if (ply.Logs_RobDelay or 0) <= CurTime() then
		ply.Logs_RobDelay = CurTime() + 5
		logs.Log("Diebstahl", ply:NameID().." bestiehlt die Staatskasse", {
			["Name des Räubers"] = ply:Name(),
			["SteamID des Räubers"] = ply:SteamID()
		})
	end
end)

logs.AddHook("onVehicleSold", function(ply, ent)
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Diebstahl", ply:NameID().." hat "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." erfolgreich verkauft", {
		["Name des Verbrechers"] = ply:Name(),
		["SteamID des Verbrechers"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.Register("Einbruch", false, Color(180, 50, 255))

logs.AddHook("lockpickStarted", function(ply, ent)
	if !IsValid(ent) then return end
	local don_box, vehicle, fading_door, owner, veh_name = false, false, false
	if ent:GetClass() == "donation_box" then
		owner = ent:Getowning_ent()
		don_box = true
	elseif ent.getDoorOwner and IsValid(ent:getDoorOwner()) then
		owner = ent:getDoorOwner()
		if ent:IsVehicle() then
			vehicle = true
			veh_name = ent:GetVehicleClass()
			if list.Get("Vehicles")[veh_name] then
				veh_name = list.Get("Vehicles")[veh_name].Name
			else
				veh_name = "das Auto"
			end
		end
	elseif ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) then
		owner = ent:CPPIGetOwner()
		fading_door = true
	elseif ent.getKeysDoorGroup and ent:getKeysDoorGroup() then
		owner = "\""..ent:getKeysDoorGroup().."\""
	else
		local doorpeople = {}
		for tid in pairs(ent:getKeysDoorTeams() or {}) do
			local name = team.GetName(tid)
			if name then
				table.insert(doorpeople, name)
			end
		end
		if #doorpeople > 0 then
			local doorstr = table.concat(doorpeople, ", ")
			owner = tostring(doorstr)
		end
	end
	logs.Log(don_box and "Diebstahl" or "Einbruch", ply:NameID().." hat angefangen, "..(don_box and "die Spendentruhe" or vehicle and veh_name or fading_door and "eine Fading Door" or "eine Tür").." von "..(ply == owner and "sich selbst" or isstring(owner) and owner or IsValid(owner) and owner:NameID() or "Niemandem").." zu knacken", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Besitzers"] = !isstring(owner) and IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = !isstring(owner) and IsValid(owner) and owner:SteamID() or nil
	})
end)

local EntityActionClasses = {
	["zrush_drilltower"] = true,
	["zrush_burner"] = true,
	["zrush_pump"] = true,
	["zrush_refinery"] = true
}

logs.AddHook("onLockpickCompleted", function(ply, succ, ent)
	if !succ or !IsValid(ent) then return end
	local class = ent:GetClass()
	if class == "donation_box" or EntityActionClasses[class] then return end
	local vehicle, fading_door, owner, veh_name = false, false
	if ent.getDoorOwner and IsValid(ent:getDoorOwner()) then
		owner = ent:getDoorOwner()
		if ent:IsVehicle() then
			vehicle = true
			veh_name = ent:GetVehicleClass()
			if list.Get("Vehicles")[veh_name] then
				veh_name = list.Get("Vehicles")[veh_name].Name
			else
				veh_name = "das Auto"
			end
		end
	elseif ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) then
		owner = ent:CPPIGetOwner()
		fading_door = true
	elseif ent:getKeysDoorGroup() then
		owner = "\""..ent:getKeysDoorGroup().."\""
	else
		local doorpeople = {}
		for tid in pairs(ent:getKeysDoorTeams() or {}) do
			local name = team.GetName(tid)
			if name then
				table.insert(doorpeople, name)
			end
		end
		if #doorpeople > 0 then
			local doorstr = table.concat(doorpeople, ", ")
			owner = tostring(doorstr)
		end
	end
	logs.Log("Einbruch", ply:NameID().." hat "..(vehicle and veh_name or fading_door and "eine Fading Door" or "eine Tür").." von "..(ply == owner and "sich selbst" or isstring(owner) and owner or IsValid(owner) and owner:NameID() or "Niemandem").." aufgebrochen", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Besitzers"] = !isstring(owner) and IsValid(owner) and owner:Name() or nil,
		["SteamID des Besitzers"] = !isstring(owner) and IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("BreachCharge_BeginAttach", function(ply, door)
	local owner = door.getDoorOwner and IsValid(door:getDoorOwner()) and door:getDoorOwner()
	logs.Log("Einbruch", ply:NameID().." hat angefangen, eine Sprengladung an die Tür von "..logs.ResolveOwner(owner, "Niemandem", ply).." anzubringen", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Tür-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Tür-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("BreachCharge_Attach", function(ply, door)
	local owner = door.getDoorOwner and IsValid(door:getDoorOwner()) and door:getDoorOwner()
	logs.Log("Einbruch", ply:NameID().." hat eine Sprengladung an die Tür von "..logs.ResolveOwner(owner, "Niemandem", ply).." gesetzt", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Tür-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Tür-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("BreachCharge_Detonate", function(ply, door)
	if !IsValid(ply) then return end
	local owner = door.getDoorOwner and IsValid(door:getDoorOwner()) and door:getDoorOwner()
	logs.Log("Einbruch", ply:NameID().." hat eine Tür von "..logs.ResolveOwner(owner, "Niemandem", ply).." hoch gesprengt", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Tür-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Tür-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("BreachCharge_Pickup", function(ply, ply2)
	logs.Log("Einbruch", ply:NameID().." hat eine Türsprengladung von "..logs.ResolveOwner(ply2, "Niemandem", ply).." aufgenommen", {
		["Name des Spielers"] = ply:Name(),
		["SteamID des Spielers"] = ply:SteamID(),
		["Name des vorh. Besitzers"] = IsValid(ply2) and ply2:Name() or nil,
		["SteamID des vorh. Besitzers"] = IsValid(ply2) and ply2:SteamID() or nil
	})
end)

logs.AddHook("onCrackKeypad", function(ply, ent)
	local owner = ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) and ent:CPPIGetOwner()
	logs.Log("Einbruch", ply:NameID().." hat angefangen, ein Keypad von "..logs.ResolveOwner(owner, "Niemandem", ply).." zu knacken", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Keypad-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Keypad-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.AddHook("onKeypadCracked", function(ply, ent)
	local owner = ent.CPPIGetOwner and IsValid(ent:CPPIGetOwner()) and ent:CPPIGetOwner()
	logs.Log("Einbruch", ply:NameID().." hat ein Keypad von "..logs.ResolveOwner(owner, "Niemandem", ply).." geknackt", {
		["Name des Einbrechers"] = ply:Name(),
		["SteamID des Einbrechers"] = ply:SteamID(),
		["Name des Keypad-Besitzers"] = IsValid(owner) and owner:Name() or nil,
		["SteamID des Keypad-Besitzers"] = IsValid(owner) and owner:SteamID() or nil
	})
end)

logs.Register("Abschleppung", false, Color(255, 135, 155))

logs.AddHook("onPlayerBeginRequestVehicleTow", function(ply, ent)
	if !IsValid(ent) or !ent:IsVehicle() then return end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat angefangen, die Abschleppung für "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." angefordert", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onPlayerUntowVehicle", function(ply, ent)
	if !IsValid(ent) or !ent:IsVehicle() then return end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat die Abschleppung vom "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." abgesagt", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onPlayerRequestedVehicleTow", function(ply, ent)
	if !IsValid(ent) or !ent:IsVehicle() then return end
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat die Abschleppung für "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." angefordert", {
		["Name des Beamten"] = ply:Name(),
		["SteamID des Beamten"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onVehicleAutoTowed", function(ent)
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." wurde automatisch abgeschleppt, weil niemand kam, um es abzuschleppen")
end)

logs.AddHook("onVehicleDettached", function(ply, ent)
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." von seinem Abschleppwagen abgekoppelt", {
		["Name des Abschleppers"] = ply:Name(),
		["SteamID des Abschleppers"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onVehicleAttached", function(ply, ent)
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." an seinen Abschleppwagen angekoppelt", {
		["Name des Abschleppers"] = ply:Name(),
		["SteamID des Abschleppers"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.AddHook("onVehicleTowed", function(ply, ent)
	local veh_name = ent:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	local target = IsValid(ent:getDoorOwner()) and ent:getDoorOwner()
	logs.Log("Abschleppung", ply:NameID().." hat "..veh_name.." von "..logs.ResolveOwner(target, "Niemandem", ply).." erfolgreich abgeschleppt", {
		["Name des Abschleppers"] = ply:Name(),
		["SteamID des Abschleppers"] = ply:SteamID(),
		["Name des Autobesitzers"] = IsValid(target) and target:Name() or nil,
		["SteamID des Autobesitzers"] = IsValid(target) and target:SteamID() or nil
	})
end)

logs.Register("Anfrage", false, Color(200, 175, 115))

logs.AddHook("MG_Marker", function(ply, _, name)
	logs.Log("Anfrage", ply:NameID().." hat eine "..name.." aufgegeben", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.Register("Autos", false, Color(140, 200, 135))

logs.AddHook("PlayerEnteredVehicle", function(ply, veh)
	local class = veh:GetClass()
	if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then return end
	local veh_name = veh:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	logs.Log("Autos", ply:NameID().." ist in "..veh_name.." eingestiegen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)

logs.AddHook("PlayerLeaveVehicle", function(ply, veh)
	local class = veh:GetVehicleClass()
	if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then return end
	local veh_name = veh:GetVehicleClass()
	if list.Get("Vehicles")[veh_name] then
		veh_name = list.Get("Vehicles")[veh_name].Name
	else
		veh_name = "das Auto"
	end
	logs.Log("Autos", ply:NameID().." ist von "..veh_name.." ausgestiegen", {
		["Name"] = ply:Name(),
		["SteamID"] = ply:SteamID()
	})
end)