logs.Register("Verwarnungen", false, Color(150, 50, 0))

logs.AddHook("MG_Warn_WarnPlayer", function(ply, reason, name, admin)
	reason = reason or "Fehlerhafter Grund"
	if IsValid(admin) then
		logs.Log("Verwarnungen", admin:NameID().." hat "..ply:NameID().." mit dem Grund \""..reason.."\" verwarnt", {
			["Name des Admins"] = admin:Name(),
			["SteamID des Admins"] = admin:SteamID(),
			["Name des Spielers"] = ply:Name(),
			["SteamID des Spielers"] = ply:SteamID(),
			["Grund"] = reason
		})
	else
		logs.Log("Verwarnungen", ply:NameID().." wurde von der Konsole mit dem Grund \""..reason.."\" verwarnt", {
			["Name"] = ply:Name(),
			["SteamID"] = ply:SteamID(),
			["Grund"] = reason
		})
	end
end)

logs.AddHook("MG_Warn_WarnPlayerID", function(steamid, reason, admin)
	reason = reason or "Fehlerhafter Grund"
	if IsValid(admin) then
		logs.Log("Verwarnungen", admin:NameID().." hat "..steamid.." mit dem Grund \""..reason.."\" verwarnt", {
			["Name"] = admin:Name(),
			["SteamID"] = admin:SteamID(),
			["Grund"] = reason
		})
	else
		logs.Log("Verwarnungen", steamid.." wurde von der Konsole mit dem Grund \""..reason.."\" verwarnt", {
			["SteamID"] = steamid,
			["Grund"] = reason
		})
	end
end)

logs.AddHook("MG_Warn_ReduceWarns", function(ply, admin)
	if IsValid(admin) then
		if !isstring(ply) and IsValid(ply) then
			logs.Log("Verwarnungen", admin:NameID().." hat "..ply:NameID().."'s aktive Verwarnungen um 1 reduziert", {
				["Name des Admins"] = admin:Name(),
				["SteamID des Admins"] = admin:SteamID(),
				["Name des Spielers"] = ply:Name(),
				["SteamID des Spielers"] = ply:SteamID()
			})
		else
			logs.Log("Verwarnungen", admin:NameID().." hat die aktiven Verwarnungen von "..ply.." um 1 reduziert", {
				["Name des Admins"] = admin:Name(),
				["SteamID des Admins"] = admin:SteamID(),
				["SteamID des Spielers"] = ply,
			})
		end
	else
		if !isstring(ply) and IsValid(ply) then
			logs.Log("Verwarnungen", ply:NameID().."'s aktive Verwarnungen wurden um 1 reduziert", {
				["Name"] = ply:Name(),
				["SteamID"] = ply:SteamID()
			})
		else
			logs.Log("Verwarnungen", "Die aktiven Verwarnungen von "..ply.." wurden um 1 reduziert", {
				["SteamID"] = ply
			})
		end
	end
end)

logs.AddHook("MG_Warn_EditWarn", function(admin, id, warn, reason)
	local steamid = warn.steamid
	if IsValid(admin) then
		logs.Log("Verwarnungen", admin:NameID().." hat den Grund der Verwarnung von "..steamid.." ("..warn.pid.." | "..warn.reason..") editiert", {
			["Neuer Grund"] = reason,
			["Name des Admins"] = admin:Name(),
			["SteamID des Admins"] = admin:SteamID(),
			["SteamID des Spielers"] = steamid
		})
	else
		logs.Log("Verwarnungen", "Die Konsole hat den Grund der Verwarnung von "..steamid.." ("..warn.pid.." | "..warn.reason..") editiert", {
			["Neuer Grund"] = reason,
			["SteamID"] = steamid
		})
	end
end)

logs.AddHook("MG_Warn_DeleteWarn", function(admin, id, warn)
	local steamid = warn.steamid
	if IsValid(admin) then
		logs.Log("Verwarnungen", admin:NameID().." hat eine Verwarnung von "..steamid.." ("..warn.pid.." | "..warn.reason..") gelöscht", {
			["Name des Admins"] = admin:Name(),
			["SteamID des Admins"] = admin:SteamID(),
			["SteamID des Spielers"] = steamid
		})
	else
		logs.Log("Verwarnungen", "Die Konsole hat eine Verwarnung von "..steamid.." ("..warn.pid.." | "..warn.reason..") gelöscht", {
			["SteamID"] = steamid
		})
	end
end)

logs.AddHook("MG_Warn_DeleteAllWarns", function(ply, admin)
	if IsValid(admin) then
		if !isstring(ply) and IsValid(ply) then
			logs.Log("Verwarnungen", admin:NameID().." hat alle Verwarnungen von "..ply:NameID().." gelöscht ", {
				["Name des Admins"] = admin:Name(),
				["SteamID des Admins"] = admin:SteamID(),
				["Name des Spielers"] = ply:Name(),
				["SteamID des Spielers"] = ply:SteamID()
			})
		else
			logs.Log("Verwarnungen", admin:NameID().." hat alle Verwarnungen von "..ply.." gelöscht", {
				["Name des Admins"] = admin:Name(),
				["SteamID des Admins"] = admin:SteamID(),
				["SteamID des Spielers"] = ply,
			})
		end
	else
		if !isstring(ply) and IsValid(ply) then
			logs.Log("Verwarnungen", "Die Konsole hat alle Verwarnungen von "..ply:NameID().." gelöscht", {
				["Name"] = ply:Name(),
				["SteamID"] = ply:SteamID()
			})
		else
			logs.Log("Verwarnungen", "Die Konsole hat alle Verwarnungen von "..ply.." gelöscht", {
				["SteamID"] = ply
			})
		end
	end
end)

logs.AddHook("MG_Warn_PlayerBanned", function(ply, admin, time, nick)
	time = time == 0 and "permanent" or (time * 60).." Minuten"
	if !isstring(ply) and IsValid(ply) then
		logs.Log("Verwarnungen", ply:NameID().." wurde aufgrund zu vieler Verwarnungen für "..time.." gebannt", {
			["Name"] = ply:Name(),
			["SteamID"] = ply:SteamID()
		})
	else
		logs.Log("Verwarnungen", ply.." wurde aufgrund zu vieler Verwarnungen für "..time.." gebannt", {
			["Name"] = nick,
			["SteamID"] = ply
		})
	end
end)