logs.draw = {}

local surface_SetDrawColor = surface.SetDrawColor
local surface_SetMaterial = surface.SetMaterial
local surface_DrawRect = surface.DrawRect
local surface_DrawTexturedRect = surface.DrawTexturedRect

local function surface_DrawRectBold(x, y, w, h, t)
	t = t or 1
	surface_DrawRect(x, y, w, t)
	surface_DrawRect(x, y + (h - t), w, t)
	surface_DrawRect(x, y, t, h)
	surface_DrawRect(x + (w - t), y, t, h)
end

function logs.draw.Box(x, y, w, h, col)
	surface_SetDrawColor(col)
	surface_DrawRect(x, y, w, h)
end

function logs.draw.Outline(x, y, w, h, col, thickness)
	surface_SetDrawColor(col)
	surface_DrawRectBold(x, y, w, h, thickness)
end

function logs.draw.OutlinedBox(x, y, w, h, col, bordercol, thickness)
	surface_SetDrawColor(col)
	surface_DrawRect(x + 1, y + 1, w - 2, h - 2)
	surface_SetDrawColor(bordercol)
	surface_DrawRectBold(x, y, w, h, thickness)
end

local blur = Material("pp/blurscreen")
function logs.draw.Blur(panel, amount)
	local x, y = panel:LocalToScreen(0, 0)
	local scrw, scrh = ScrW(), ScrH()
	surface_SetDrawColor(255, 255, 255)
	surface_SetMaterial(blur)
	for i = 1, 3 do
		blur:SetFloat("$blur", (i / 3) * (amount or 6))
		blur:Recompute()
		render.UpdateScreenEffectTexture()
		surface_DrawTexturedRect(x * -1, y * -1, scrw, scrh)
	end
end