surface.CreateFont("logs.ui.26", {font = "Roboto", size = 26, weight = 500})
surface.CreateFont("logs.ui.24", {font = "Roboto", size = 24, weight = 500})
surface.CreateFont("logs.ui.22", {font = "Roboto", size = 22, weight = 500})
surface.CreateFont("logs.ui.20", {font = "Roboto", size = 20, weight = 500})
surface.CreateFont("logs.ui.19", {font = "Roboto", size = 19, weight = 500})
surface.CreateFont("logs.ui.18", {font = "Roboto", size = 18, weight = 500})
surface.CreateFont("logs.ui.16", {font = "Roboto", size = 16, weight = 500})
surface.CreateFont("logs.ui.14", {font = "Roboto", size = 14, weight = 500})

local selected_font = CreateClientConVar("mg_logs_font", "logs.roboto")
local width = CreateClientConVar("mg_logs_width", logs.cfg.Width)
local height = CreateClientConVar("mg_logs_height", logs.cfg.Height)
local color = CreateClientConVar("mg_logs_color", logs.cfg.UseColors and 1 or 0)

function logs.SelectFont()
	local sel_font = selected_font:GetString()
	if sel_font and logs.allowed_fonts[sel_font] then
		return sel_font
	else
		return "logs.roboto"
	end
end

function logs.AskLogs(cat, date, page)
	net.Start("logs.AddLog")
		net.WriteString(cat)
		net.WriteUInt(date, 32)
		net.WriteUInt(page, 16)
	net.SendToServer()
end

function logs.AskAdvLogs(cat, date, page, search, method)
	net.Start("logs.AdvLog")
		net.WriteString(cat)
		net.WriteUInt(date, 32)
		net.WriteUInt(page, 16)
		net.WriteString(search)
		net.WriteUInt(method, 8)
	net.SendToServer()
end

local function AddOptionClick(menu, value, ext, advanced, men)
	if ext and ext != 1 then
		men.DoRightClick = function()
			if !IsValid(logs.Adv_Menu) or !IsValid(logs.Adv_Menu.Loglist) then
				advanced:DoClick(value, true)
			else
				logs.Adv_Menu.Loglist:AskLogs(value)
			end
			menu:Remove()
		end
		men:SetTooltip("Rechtsklick zum Suchen in erweiterter Suche.")
	end
end

local function AddOption(menu, text, value, ext, advanced)
	local men = menu:AddOption(ext == 1 and text or text.." kopieren", function() 
		if ext == 1 then
			gui.OpenURL("https://steamcommunity.com/profiles/"..util.SteamIDTo64(value))
		else
			SetClipboardText(value)
			chat.AddText(Color(150, 150, 255), text, color_white, " kopiert.")
		end
	end)
	AddOptionClick(menu, value, ext, advanced, men)
end

local generic_logs = "Alle Logs"
local loading = "Logs werden geladen..."
local nothing_found = "Keine Logs vorhanden..."
local one_day = 24 * 60 * 60
local one_hour = 60 * 60

local data = {}
local adv_data = {}
local page = 1
local advanced
function logs.AddLog(name, active)
	data[name] = {}
	local loaded = active and true or false
	if active then
		logs.AskLogs(name, 1, 1)
	end
	local loglist
	local date_select
	local page_select
	local ply = LocalPlayer()
	local tabs = logs.Menu.Tabs
	local panel = vgui.Create("DPanel", tabs)
	local old_SetVisible = panel.SetVisible
	panel.SetVisible = function(panel, bool)
		old_SetVisible(panel, bool)
		if !bool or loaded then return end
		page = 1
		loaded = true
		if IsValid(loglist) then
			loglist:Clear()
			local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
			line:SetColumnText(name == generic_logs and 3 or 2, loading)
		end
		logs.AskLogs(name, os.time(), 1)
	end
	tabs:AddTab(name, panel, active and true)
	local search = Label("Suchen:", panel)
	search:SetFont("logs.ui.22")
	search:SetTextColor(logs.ui.Text)
	search:SetPos(5, panel:GetTall() - 28)
	search:SetSize(200, 20)
	local entry = vgui.Create("DTextEntry", panel)
	entry:SetPos(75, panel:GetTall() - 30)
	entry:SetSize(panel:GetWide() - 490, 25)
	entry:SetFont("logs.ui.22")
	loglist = vgui.Create("DListView", panel)
	loglist:SetPos(0, 0)
	loglist:SetSize(panel:GetWide(), panel:GetTall() - 35)
	loglist:SetMultiSelect(false)
	loglist:AddColumn("Uhrzeit"):SetFixedWidth(140)
	if name == generic_logs then
		loglist:AddColumn("Kategorie"):SetFixedWidth(100)
	end
	loglist:AddColumn("Log")
	loglist.OnRowSelected = function(parent, line)
		local column = loglist:GetLine(line)
		local the_log = name == generic_logs and column:GetColumnText(3) or column:GetColumnText(2)
		local menu = DermaMenu()
		menu:SetSkin("logs")
		AddOption(menu, "Zeile", the_log, false)
		for name, value in SortedPairs(column.Copy or {}) do
			if name and value and !istable(value) then
				if value:match("^STEAM_%d:%d:%d+$") then
					local submenu, parent = menu:AddSubMenu(name.." ("..value..") kopieren", function()
						SetClipboardText(value)
						chat.AddText(Color(150, 150, 255), text, color_white, " kopiert.")
					end)
					AddOptionClick(menu, value, true, advanced, parent)
					parent:SetSkin("logs")
					AddOption(submenu, "Steamprofil öffnen", value, 1)
				else
					AddOption(menu, name.." ("..value..")", value, true, advanced)
				end
			end
		end
		for name, value in SortedPairs(column.Copy or {}) do
			if name and value and istable(value) then
				local submenu, parent = menu:AddSubMenu(name)
				parent:SetSkin("logs")
				for name, value in SortedPairs(value) do
					AddOption(submenu, name.." ("..value..")", value, true, advanced)
				end
			end
		end
		menu:Open()
	end
	local old_AddLine = loglist.AddLine
	loglist.AddLine = function(self, ...)
		local pan = old_AddLine(self, ...)
		local sel_font = logs.SelectFont()
		for _, v in ipairs(pan.Columns) do
			v:SetFont(sel_font)
		end
		return pan
	end
	local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
	line:SetColumnText(name == generic_logs and 3 or 2, loading)
	panel.Data = {}
	loglist.Clear = function(self)
		for k in ipairs(self:GetLines()) do
			self:RemoveLine(k)
		end
		panel.Data = {}
	end
	loglist.AddLogs = function(self)
		loglist:Clear()
		local show_category = (name == generic_logs)
		local c = 0
		for _, v in ipairs(data[name] or {}) do
			local data = v.data
			local category = v.category
			local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", v.date), show_category and category or data, show_category and data)
			line.Copy = util.JSONToTable(v.copy)
			if show_category and color:GetBool() then
				line.Color = logs.types[category] and logs.types[category][3]
			end
			c = c + 1
		end
		if c == 0 then
			local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
			line:SetColumnText(name == generic_logs and 3 or 2, nothing_found)
		end
		if IsValid(page_select) then
			page_select:Clear()
			page_select:SetValue(page)
			for i=1, (page == 1 and page + 24 or page + 25) do
				page_select:AddChoice(i)
			end
			page_select:AddChoice("▼")
		end
		if string.Trim(entry:GetValue()) != "" then
			loglist:Search(string.Trim(entry:GetValue()))
		end
	end
	loglist.Search = function(self, search)
		if search == "" then
			self:Clear()
			self:AddLogs()
		else
			self:Clear()
			local show_category = name == generic_logs
			for _, v in ipairs(data[name] or {}) do
				if string.find(string.lower(v.copy), string.lower(search), 1, true) or string.find(string.lower(v.data), string.lower(search), 1, true) then
					local data = v.data
					local category = v.category
					local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", v.date), show_category and category or data, show_category and data)
					line.Copy = util.JSONToTable(v.copy)
					if show_category and color:GetBool() then
						line.Color = logs.types[category] and logs.types[category][3]
					end
					panel.Data[#panel.Data + 1] = v
				end
			end
		end
	end
	local searchbut = vgui.Create("DButton", panel)
	searchbut:SetPos(panel:GetWide() - 410, panel:GetTall() - 30)
	searchbut:SetSize(70, 25)
	searchbut:SetText("Suchen")
	searchbut.DoClick = function()
		loglist:Search(string.Trim(entry:GetValue()))
	end
	entry.OnEnter = function()
		loglist:Search(string.Trim(entry:GetValue()))
	end
	advanced = vgui.Create("DButton", panel)
	advanced:SetPos(panel:GetWide() - 335, panel:GetTall() - 30)
	advanced:SetSize(95, 25)
	advanced:SetText("Erw. Suche")
	advanced.DoClick = function(self, text, do_search)
		local w, h = logs.Menu.OrigWidth * 0.9, logs.Menu.OrigHeight * 0.9
		local menu = logs.Adv_Menu
		if IsValid(menu) then
			menu:Close()
		end
		local search_method
		local cat_select
		local date_select
		local page_select
		menu = vgui.Create("logs_frame_main")
		menu:SetSize(w, h)
		menu:Center()
		menu.lblTitle:SetText("[MG] Logsystem - Erweiterte Suche")
		logs.Adv_Menu = menu
		local loglist
		local local_entry = vgui.Create("DTextEntry", menu)
		local_entry:SetPos(150, menu:GetTall() - 60)
		local_entry:SetSize(menu:GetWide() - 470, 25)
		local_entry:SetFont("logs.ui.22")
		local_entry.OnEnter = function()
			loglist:Search(string.Trim(local_entry:GetValue()))
		end
		local entry = vgui.Create("DTextEntry", menu)
		entry:SetPos(150, menu:GetTall() - 30)
		entry:SetSize(menu:GetWide() - 565, 25)
		entry:SetFont("logs.ui.22")
		entry.OnEnter = function()
			loglist:AskLogs(string.Trim(entry:GetValue()))
		end
		if text and text != "" then
			entry:SetValue(text)
		end
		loglist = vgui.Create("DListView", menu)
		loglist:SetPos(0, 28)
		loglist:SetSize(menu:GetWide(), menu:GetTall() - 98)
		loglist:SetMultiSelect(false)
		loglist:AddColumn("Uhrzeit"):SetFixedWidth(140)
		loglist:AddColumn("Kategorie"):SetFixedWidth(100)
		loglist:AddColumn("Log")
		loglist.OnRowSelected = function(parent, line)
			local column = loglist:GetLine(line)
			local the_log = column:GetColumnText(3)
			local menu = DermaMenu()
			menu:SetSkin("logs")
			AddOption(menu, "Zeile", the_log, false)
			for name, value in SortedPairs(column.Copy or {}) do
				if name and value and !istable(value) then
					if value:match("^STEAM_%d:%d:%d+$") then
						local submenu, parent = menu:AddSubMenu(name.." ("..value..") kopieren", function()
							SetClipboardText(value)
							chat.AddText(Color(150, 150, 255), text, color_white, " kopiert.")
						end)
						AddOptionClick(menu, value, true, advanced, parent)
						parent:SetSkin("logs")
						AddOption(submenu, "Steamprofil öffnen", value, 1)
					else
						AddOption(menu, name.." ("..value..")", value, true, advanced)
					end
				end
			end
			for name, value in SortedPairs(column.Copy or {}) do
				if name and value and istable(value) then
					local submenu, parent = menu:AddSubMenu(name)
					parent:SetSkin("logs")
					for name, value in SortedPairs(value) do
						AddOption(submenu, name.." ("..value..")", value, true, advanced)
					end
				end
			end
			menu:Open()
		end
		local old_AddLine = loglist.AddLine
		loglist.AddLine = function(self, ...)
			local pan = old_AddLine(self, ...)
			local sel_font = logs.SelectFont()
			for _, v in ipairs(pan.Columns) do
				v:SetFont(sel_font)
			end
			return pan
		end
		local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
		line:SetColumnText(3, "Erweiterte Logs:")
		local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
		line:SetColumnText(3, "\"Log laden\" wird zum Öffnen und Laden von Logs benutzt.")
		local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
		line:SetColumnText(3, "\"In Log suchen\" wird zum Durchsuchen des offenen Logs benutzt.")
		menu.Data = {}
		loglist.Clear = function(self)
			for k in ipairs(self:GetLines()) do
				self:RemoveLine(k)
			end
			menu.Data = {}
		end
		loglist.AddLogs = function(self)
			loglist:Clear()
			local c = 0
			for _, v in ipairs(adv_data or {}) do
				local data = v.data
				local category = v.category
				local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", v.date), category, data)
				line.Copy = util.JSONToTable(v.copy)
				if color:GetBool() then
					line.Color = logs.types[category] and logs.types[category][3]
				end
				c = c + 1
			end
			if c == 0 then
				local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
				line:SetColumnText(3, nothing_found)
			end
			if string.Trim(local_entry:GetValue()) != "" then
				loglist:Search(string.Trim(local_entry:GetValue()))
			end
		end
		loglist.Search = function(self, search)
			if search == "" then
				self:Clear()
				self:AddLogs()
			else
				self:Clear()
				for _, v in ipairs(adv_data or {}) do
					if string.find(string.lower(v.copy), string.lower(search), 1, true) or string.find(string.lower(v.data), string.lower(search), 1, true) then
						local data = v.data
						local category = v.category
						local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", v.date), category, data)
						line.Copy = util.JSONToTable(v.copy)
						if color:GetBool() then
							line.Color = logs.types[category] and logs.types[category][3]
						end
						menu.Data[#menu.Data + 1] = v
					end
				end
			end
		end
		loglist.AskLogs = function(self, search)
			loglist:Clear()
			local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
			line:SetColumnText(3, loading)
			local selected_cat = cat_select:GetValue()
			if !tostring(selected_cat) then
				selected_cat = generic_logs
			end
			local _, selected_date = date_select:GetSelected()
			if !tonumber(selected_date) then
				selected_date = 1
				end
			local selected_page = page_select:GetValue()
			if !tonumber(selected_page) then
				selected_page = 1
			end
			local _, selected_searchmethod = search_method:GetSelected()
			if !tonumber(selected_searchmethod) then
				selected_searchmethod = 2
			end
			logs.AskAdvLogs(selected_cat, selected_date, selected_page, search, selected_searchmethod)
		end
		local local_search = Label("In Log suchen:", menu)
		local_search:SetFont("logs.ui.22")
		local_search:SetTextColor(logs.ui.Text)
		local_search:SetPos(5, menu:GetTall() - 58)
		local_search:SetSize(200, 20)
		local search = Label("Serverlog laden:", menu)
		search:SetFont("logs.ui.22")
		search:SetTextColor(logs.ui.Text)
		search:SetPos(5, menu:GetTall() - 28)
		search:SetSize(200, 20)
		cat_select = vgui.Create("DComboBox", menu)
		cat_select:SetPos(menu:GetWide() - 315, menu:GetTall() - 30)
		cat_select:SetSize(155, 25)
		cat_select:SetFont("logs.ui.18")
		cat_select:SetColor(logs.ui.ComboBoxText)
		cat_select:SetSortItems(false)
		cat_select:AddChoice(generic_logs)
		cat_select:SetValue(generic_logs)
		local is_sadmin = logs.cfg.Superadmins[ply:GetUserGroup()]
		for _,v in SortedPairs(logs.types) do
			if v[2] and !is_sadmin then continue end
			cat_select:AddChoice(v[1])
		end
		search_method = vgui.Create("DComboBox", menu)
		search_method:SetPos(menu:GetWide() - 155, menu:GetTall() - 30)
		search_method:SetSize(150, 25)
		search_method:SetFont("logs.ui.18")
		search_method:SetColor(logs.ui.ComboBoxText)
		search_method:SetSortItems(false)
		search_method:SetValue("Alles durchsuchen", 2)
		search_method:AddChoice("Alles durchsuchen", 2)
		search_method:AddChoice("Logs durchsuchen", 0)
		search_method:AddChoice("Infos durchsuchen", 1)
		date_select = vgui.Create("DComboBox", menu)
		date_select:SetPos(menu:GetWide() - 155, menu:GetTall() - 60)
		date_select:SetSize(95, 25)
		date_select:SetFont("logs.ui.18")
		date_select:SetColor(logs.ui.ComboBoxText)
		date_select:SetSortItems(false)
		date_select:AddChoice("Zuletzt", 1)
		date_select:SetValue("Zuletzt", 1)
		local cur_time = os.time()
		local cur_min = tonumber(os.date("%M", cur_time)) or 0
		cur_min = cur_min * 60
		local cur_sec = tonumber(os.date("%S", cur_time)) or 0
		local cur_add = cur_min + cur_sec
		for i=0, ((logs.cfg.OldestLogs / 24 / 60 / 60) * 24) - 1 do
			local hour = (cur_time - one_hour * i) - cur_add
			date_select:AddChoice(os.date("%d.%m.%y - %H", hour).." Uhr", hour)
		end
		date_select.OnSelect = function(self, index, value)
			date_select:SetTooltip(value)
		end
		page_select = vgui.Create("DTextEntry", menu)
		page_select:SetPos(menu:GetWide() - 55, menu:GetTall() - 60)
		page_select:SetSize(50, 25)
		page_select:SetFont("logs.ui.18")
		page_select:SetValue("1")
		page_select:SetNumeric(true)
		local local_searchbut = vgui.Create("DButton", menu)
		local_searchbut:SetPos(menu:GetWide() - 315, menu:GetTall() - 60)
		local_searchbut:SetSize(70, 25)
		local_searchbut:SetText("Suchen")
		local_searchbut.DoClick = function()
			loglist:Search(string.Trim(local_entry:GetValue()))
		end
		local searchbut = vgui.Create("DButton", menu)
		searchbut:SetPos(menu:GetWide() - 410, menu:GetTall() - 30)
		searchbut:SetSize(90, 25)
		searchbut:SetText("Log laden")
		searchbut.DoClick = function()
			loglist:AskLogs(string.Trim(entry:GetValue()))
		end
		local reload = vgui.Create("DButton", menu)
		reload:SetPos(menu:GetWide() - 240, menu:GetTall() - 60)
		reload:SetSize(80, 25)
		reload:SetText("Neuladen")
		reload.DoClick = function()
			loglist:AskLogs(string.Trim(entry:GetValue()))
		end
		logs.Adv_Menu.Loglist = loglist
		if do_search and GetConVar("mg_logs_searchext"):GetBool() then
			loglist:AskLogs(text)
		end
	end
	local reload = vgui.Create("DButton", panel)
	reload:SetPos(panel:GetWide() - 235, panel:GetTall() - 30)
	reload:SetSize(80, 25)
	reload:SetText("Neuladen")
	reload.DoClick = function()
		loglist:Clear()
		local line = loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()))
		line:SetColumnText(name == generic_logs and 3 or 2, loading)
		local _, selected_date = date_select:GetSelected()
		if !tonumber(selected_date) then
			selected_date = 1
		end
		local selected_page = page_select:GetValue()
		if !tonumber(selected_page) then
			selected_page = 1
		end
		logs.AskLogs(name, selected_date, selected_page)
	end
	date_select = vgui.Create("DComboBox", panel)
	date_select:SetPos(panel:GetWide() - 150, panel:GetTall() - 30)
	date_select:SetSize(90, 25)
	date_select:SetFont("logs.ui.18")
	date_select:SetColor(logs.ui.ComboBoxText)
	date_select:SetSortItems(false)
	date_select:AddChoice("Zuletzt", 1)
	date_select:SetValue("Zuletzt", 1)
	local cur_time = os.time()
	local cur_hour = tonumber(os.date("%H", cur_time)) or 0
	cur_hour = cur_hour * 60 * 60
	local cur_min = tonumber(os.date("%M", cur_time)) or 0
	cur_min = cur_min * 60
	local cur_sec = tonumber(os.date("%S", cur_time)) or 0
	local cur_add = cur_hour + cur_min + cur_sec
	for i=0, (logs.cfg.OldestLogs / 24 / 60 / 60) do
		local day = (os.time() - one_day * i) - cur_add + (24 * 60 * 60) - 1
		date_select:AddChoice(os.date("%d.%m.%y", day), day)
	end
	date_select.OnSelect = function(self, index, value, data)
		loglist:Clear()
		loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()), loading)
		logs.AskLogs(name, tonumber(data), 1)
	end
	page_select = vgui.Create("DComboBox", panel)
	page_select:SetPos(panel:GetWide() - 55, panel:GetTall() - 30)
	page_select:SetSize(50, 25)
	page_select:SetFont("logs.ui.18")
	page_select:SetColor(logs.ui.ComboBoxText)
	page_select:SetSortItems(false)
	page_select:SetValue(page)
	page_select.OnSelect = function(self, index, value, data)
		if value == "▼" then
			local cnt = #page_select.Choices - 1
			page_select:Clear()
			for i=1, cnt + 25 do
				page_select:AddChoice(i)
			end
			page_select:AddChoice("▼")
			page_select:SetValue(page)
			timer.Simple(0, function()
				page_select:OpenMenu()
				if IsValid(page_select) then
					page_select.Menu:GetVBar():AnimateTo(math.huge, 0, 0)
				end
			end)
		else
			local _, selected_date = date_select:GetSelected()
			if !tonumber(selected_date) then
				selected_date = 1
			end
			loglist:Clear()
			loglist:AddLine(os.date("%d.%m.%y - %H:%M:%S", os.time()), loading)
			logs.AskLogs(name, tonumber(selected_date), tonumber(value))
		end
	end
	logs.Menu.Loglist = logs.Menu.Loglist or {}
	logs.Menu.Loglist[name] = loglist
end

function logs.OpenMenu()
	local w, h = math.Clamp(width:GetFloat(), 0.5, 1) * ScrW(), math.Clamp(height:GetFloat(), 0.5, 1) * ScrH()
	local menu = logs.Menu
	if IsValid(menu) then
		menu:Close()
	end
	menu = vgui.Create("logs_frame_main")
	menu:SetSize(w, h)
	menu:Center()
	logs.Menu = menu
	local tabs = vgui.Create("logs_tablist", menu)
	tabs:SetPos(0, 29)
	tabs:SetSize(w, h - 29)
	logs.Menu.Tabs = tabs
	logs.Menu.OrigWidth = w
	logs.Menu.OrigHeight = h
	logs.AddLog(generic_logs, true)
	local is_sadmin = logs.cfg.Superadmins[LocalPlayer():GetUserGroup()]
	for _,v in SortedPairs(logs.types) do
		if v[2] and !is_sadmin then continue end
		logs.AddLog(v[1])
	end
end

hook.Add("OnPlayerChat", "Logs_OpenMenu", function(ply, text)
	text = string.lower(text)
	local text_sub = string.sub(text, 1, 1)
	if text_sub == "!" or text_sub == "/" then
		local cmd = string.sub(text, 2, #text)
		if logs.cfg.Commands[cmd] then
			if ply != LocalPlayer() then return true end
			if !logs.HasPerms(ply) then
				chat.AddText(Color(255, 50, 50), "Du hast keine Berechtigung, die Logs zu benutzen!")
				return true
			end
			if IsValid(logs.Menu) then return true end
			logs.OpenMenu()
			return true
		end
	end
end)

concommand.Add("logs", function(ply)
	if ply != LocalPlayer() then return end
	if !logs.HasPerms(ply) then
		chat.AddText(Color(255, 50, 50), "Du hast keine Berechtigung, die Logs zu benutzen!")
		return
	end
	if IsValid(logs.Menu) then return end
	logs.OpenMenu()
end)

net.Receive("logs.AddLog", function()
	local id = net.ReadString()
	local leng = net.ReadUInt(32)
	local logs_to_add = net.ReadData(leng)
	logs_to_add = util.Decompress(logs_to_add)
	logs_to_add = util.JSONToTable(logs_to_add)
	local is_sadmin = logs.cfg.Superadmins[LocalPlayer():GetUserGroup()]
	for i=#logs_to_add, 1, -1 do
		local log = logs_to_add[i]
		if log then
			local logtyp = logs.types[log.category]
			if logtyp and logtyp[2] and !is_sadmin then
				table.remove(logs_to_add, i)
			end
		end
	end
	data[id] = logs_to_add
	local pg = net.ReadUInt(16)
	page = pg
	local menu = logs.Menu
	if IsValid(menu) and menu.Loglist and menu.Loglist[id] then
		menu.Loglist[id].AddLogs()
		if IsValid(menu.Loglist[id].VBar) then
			menu.Loglist[id].VBar:AnimateTo(0, 0, 0)
		end
	end
end)

net.Receive("logs.AdvLog", function()
	local leng = net.ReadUInt(32)
	local logs_to_add = net.ReadData(leng)
	logs_to_add = util.Decompress(logs_to_add)
	logs_to_add = util.JSONToTable(logs_to_add)
	local is_sadmin = logs.cfg.Superadmins[LocalPlayer():GetUserGroup()]
	for i=#logs_to_add, 1, -1 do
		local log = logs_to_add[i]
		if log then
			local logtyp = logs.types[log.category]
			if logtyp and logtyp[2] and !is_sadmin then
				table.remove(logs_to_add, i)
			end
		end
	end
	adv_data = logs_to_add
	local menu = logs.Adv_Menu
	if IsValid(menu) and menu.Loglist then
		menu.Loglist.AddLogs()
		if IsValid(menu.Loglist.VBar) then
			menu.Loglist.VBar:AnimateTo(0, 0, 0)
		end
	end
end)