local PANEL = {}

local voicebind_use = CreateClientConVar("mg_logs_voicebind", 1)
local voicebind_key = CreateClientConVar("mg_logs_voicekey", KEY_X)
local searchext = CreateClientConVar("mg_logs_searchext", 1)

local function VoiceChatEnable(bool)
	if permissions and permissions.EnableVoiceChat then
		permissions.EnableVoiceChat(bool)
	else
		RunConsoleCommand((bool and "+" or "-").."voicerecord")
	end
end

local cog = Material("icon16/cog.png")
local talk = Material("icon16/sound.png")
function PANEL:Init()
	self.btnMaxim:Remove()
	self.btnMinim:Remove()
	self.lblTitle:SetText("[MG] Logsystem")
	self.lblTitle:SetColor(logs.ui.Text)
	self.lblTitle:SetFont("logs.ui.22")
	self.btnClose:SetTooltip("Fenster schließen")
	self:SetSkin("logs")
	self:SetDraggable(true)
	self:MakePopup()
	self:SetAlpha(0)
	self:FadeIn(0.1)
	hook.Add("Think", self, function()
		if self.animation then
			self.animation:Run()
		end
	end)
	self:AddExtras()
end

function PANEL:AddExtras()
	self.btnSettings = vgui.Create("DButton", self)
	self.btnSettings:SetText("")
	self.btnSettings.Paint = function(self, w, h)
		if self:IsHovered() then
			surface.SetDrawColor(logs.ui.CloseHovered)
		else
			surface.SetDrawColor(logs.ui.Close)
		end
		surface.SetMaterial(cog)
		surface.DrawTexturedRect(5, 6, 16, 16)
	end
	self.btnSettings.DoClick = function()
		self:OpenSettings()
	end
	self.btnSettings:SetTooltip("Einstellungen")
	self.btnTalk = vgui.Create("DButton", self)
	self.btnTalk:SetText("")
	self.btnTalk.Paint = function(self, w, h)
		if self:IsHovered() then
			surface.SetDrawColor(logs.ui.CloseHovered)
		else
			surface.SetDrawColor(logs.ui.Close)
		end
		surface.SetMaterial(talk)
		surface.DrawTexturedRect(5, 6, 16, 16)
	end
	self.btnTalk.OnMousePressed = function(self, key)
		if self.Closing then return end
		if key == MOUSE_FIRST then
			VoiceChatEnable(true)
			self.MouseUse = true
			self.Communicating = true
		end
	end
	self.btnTalk.Think = function(self)
		if self.Closing then return end
		if voicebind_use:GetBool() and !self.Communicating and input.IsKeyDown(voicebind_key:GetInt()) then
			VoiceChatEnable(true)
			self.KeyUse = true
			self.Communicating = true
		end
		if self.Communicating and self.KeyUse and voicebind_use:GetBool() and !input.IsKeyDown(voicebind_key:GetInt()) then
			VoiceChatEnable(false)
			self.KeyUse = nil
			self.Communicating = nil
		end
		if self.Communicating and self.MouseUse and !input.IsMouseDown(MOUSE_FIRST) then
			VoiceChatEnable(false)
			self.MouseUse = nil
			self.Communicating = nil
		end
	end
	self.btnTalk:SetTooltip("Push to Talk\nGedrückt halten, um zu sprechen.")
end

function PANEL:FadeIn(speed, cback)
	self.animation = Derma_Anim("Fade Panel", self, function(panel, animation, delta, data)
		if !IsValid(panel) then return end
		panel:SetAlpha(delta * 255)
		if animation.Finished then
			self.animation = nil
			if cback then
				cback()
			end
		end
	end)
	if self.animation then
		self.animation:Start(speed)
	end
end

function PANEL:FadeOut(speed, cback)
	self.animation = Derma_Anim("Fade Panel", self, function(panel, animation, delta, data)
		if !IsValid(panel) then return end
		panel:SetAlpha(255 - (delta * 255))
		if animation.Finished then
			self.animation = nil
			if cback then
				cback()
			end
		end
	end)
	if self.animation then
		self.animation:Start(speed)
	end
end

function PANEL:PerformLayout()
	self.lblTitle:SizeToContents()
	self.lblTitle:SetPos(5, 3)
	local w = self:GetWide()
	self.btnClose:SetPos(w - 30, 0)
	self.btnClose:SetSize(30, 30)
	if self.btnSettings then
		self.btnSettings:SetPos(w - 60, 0)
		self.btnSettings:SetSize(30, 30)
	end
	if self.btnTalk then
		self.btnTalk:SetPos(w - 90, 0)
		self.btnTalk:SetSize(30, 30)
	end
end

function PANEL:Close(cback)
	if self.Closing then return end
	self.Closing = true
	if IsValid(self.btnTalk) and self.btnTalk.Communicating then
		timer.Simple(0, function()
			VoiceChatEnable(false)
		end)
		self.btnTalk.Communicating = nil
	end
	self.Think = function()
	end
	self:FadeOut(0.1, function()
		if !IsValid(self) then return end
		self:Remove()
		if cback then
			cback()
		end
	end)
end

local function GetSkins(var)
	if var then
		local skin = logs.skins[var]
		if skin then
			return skin[1]
		else
			return "Failsafe"
		end
	else
		return logs.skins
	end
end

local function FontExists(name)
	local result = pcall(surface.SetFont, name)
	if !result then
		return false
	else
		return true
	end
end

-- Füge hier neue Schriftarten ein

surface.CreateFont("logs.roboto", {font = "Roboto", size = 16, weight = 500})
surface.CreateFont("logs.roboto_bold", {font = "Roboto", size = 16, weight = 800})
surface.CreateFont("logs.tahoma", {font = "Tahoma", size = 13, weight = 500})
surface.CreateFont("logs.tahoma_bold", {font = "Tahoma", size = 13, weight = 800})
surface.CreateFont("logs.verdana", {font = "Verdana", size = 13, weight = 500})
surface.CreateFont("logs.verdana_bold", {font = "Verdana", size = 13, weight = 800})
surface.CreateFont("logs.trebuchet", {font = "Trebuchet MS", size = 18, weight = 700})
surface.CreateFont("logs.arial", {font = "Arial", size = 15, weight = 500})
surface.CreateFont("logs.arial_bold", {font = "Arial", size = 15, weight = 800})
surface.CreateFont("logs.akbar", {font = "Akbar", size = 14, weight = 800})
surface.CreateFont("logs.opensans", {font = "Open Sans", size = 17, weight = 500})
surface.CreateFont("logs.opensans_bold", {font = "Open Sans", size = 15, weight = 800})
surface.CreateFont("logs.opensansc", {font = "Open Sans Condensed", size = 19, weight = 1000})
surface.CreateFont("logs.nimbussanpcon", {font = "NimbusSanPCon", size = 15, weight = 1000})

logs.allowed_fonts = {
	["logs.roboto"] = "Roboto/Standard",
	["logs.roboto_bold"] = "Roboto Bold",
	["logs.tahoma"] = "Tahoma",
	["logs.tahoma_bold"] = "Tahoma Bold",
	["logs.verdana"] = "Verdana",
	["logs.verdana_bold"] = "Verdana Bold",
	["logs.trebuchet"] = "Trebuchet MS",
	["logs.arial"] = "Arial",
	["logs.arial_bold"] = "Arial Bold",
	["logs.akbar"] = "Akbar",
	["logs.opensans"] = "Open Sans",
	["logs.opensans_bold"] = "Open Sans Bold",
	["logs.opensansc"] = "Open Sans C",
	["logs.nimbussanpcon"] = "NimbusSanPCon",
}

-- Schriftarten Ende

for k, v in pairs(logs.allowed_fonts) do
	if !FontExists(k) then
		logs.allowed_fonts[k] = nil
		print("[MG Logs] Schriftart \""..k.."\" konnte nicht geladen werden.\n[MG Logs] Möglicherweise fehlt die Schriftart \""..v.."\" auf der Festplatte.")
	end
end

local function GetFonts(var)
	if var then
		local font = logs.allowed_fonts[var]
		if font then
			return font
		else
			return "Failsafe"
		end
	else
		return logs.allowed_fonts
	end
end

function PANEL:ReloadMenu()
	if IsValid(logs.Menu) then
		logs.Menu:Close()
	end
	if IsValid(logs.Adv_Menu) then
		logs.Adv_Menu:Close()
	end
	timer.Simple(0, function()
		logs.OpenMenu()
		if IsValid(logs.Menu) then
			logs.Menu:OpenSettings()
		end
	end)
end

function PANEL:OpenSettings() -- Ich weiß, dass es nicht sehr ordentlich ist... Der Rest des Codes ist aber super! :)
	if IsValid(self.Settings) then
		self.Settings:Remove()
	end
	self.Settings = vgui.Create("logs_frame")
	local settings = self.Settings
	self.Settings:SetSize(450, 320)
	self.Settings:Center()
	self.Settings:SetTitle("[MG] Logs - Einstellungen")
	self.Settings:SetDraggable(true)
	self.Settings:SetSkin("logs")
	self.Settings:MakePopup()
	local oldThink = self.Settings.Think
	self.Settings.Think = function(pan)
		oldThink(pan)
		if !IsValid(self) or self.Closing then
			pan:Close()
		end
	end
	local skins = vgui.Create("DComboBox", self.Settings)
	skins:SetPos(5, 35)
	skins:SetSize(self.Settings:GetWide() - 10, 25)
	skins:SetSortItems(false)
	skins:SetTextColor(logs.ui.ComboBoxText)
	skins:SetFont("logs.ui.20")
	skins:SetValue("Skin auswählen ("..GetSkins(GetConVar("mg_logs_skin"):GetString())..")")
	for k, v in SortedPairs(GetSkins()) do
		skins:AddChoice(v[1], k)
	end
	skins.OnSelect = function(slf, ind, val, data)
		if GetConVar("mg_logs_skin"):GetString() == data then return end
		RunConsoleCommand("mg_logs_skin", data)
		self:ReloadMenu()
	end
	local fonts = vgui.Create("DComboBox", self.Settings)
	fonts:SetPos(5, 65)
	fonts:SetSize(self.Settings:GetWide() - 10, 25)
	fonts:SetSortItems(false)
	fonts:SetTextColor(logs.ui.ComboBoxText)
	fonts:SetFont("logs.ui.20")
	fonts:SetValue("Schriftart auswählen ("..GetFonts(GetConVar("mg_logs_font"):GetString())..")")
	for k, v in SortedPairs(GetFonts()) do
		fonts:AddChoice(v, k)
	end
	fonts.OnSelect = function(slf, ind, val, data)
		if GetConVar("mg_logs_font"):GetString() == data then return end
		RunConsoleCommand("mg_logs_font", data)
		self:ReloadMenu()
	end
	local size_x = vgui.Create("DNumSlider", self.Settings)
	size_x:SetPos(5, 95)
	size_x:SetSize(self.Settings:GetWide() - 10, 20)
	size_x:SetText("Breite des Logfensters")
	size_x:SetMin(0.5)
	size_x:SetMax(1)
	size_x:SetDecimals(2)
	size_x:SetConVar("mg_logs_width")
	size_x.Label:SetTextColor(logs.ui.Text)
	size_x.TextArea:SetTextColor(logs.ui.Text)
	local size_y = vgui.Create("DNumSlider", self.Settings)
	size_y:SetPos(5, 120)
	size_y:SetSize(self.Settings:GetWide() - 10, 20)
	size_y:SetText("Höhe des Logfensters")
	size_y:SetMin(0.5)
	size_y:SetMax(1)
	size_y:SetDecimals(2)
	size_y:SetConVar("mg_logs_height")
	size_y.Label:SetTextColor(logs.ui.Text)
	size_y.TextArea:SetTextColor(logs.ui.Text)
	local use_colors = vgui.Create("DCheckBoxLabel", self.Settings)
	use_colors:SetPos(5, 145)
	use_colors:SetChecked(GetConVar("mg_logs_color"):GetBool())
	use_colors.OnChange = function(slf, checked)
		RunConsoleCommand("mg_logs_color", checked and 1 or 0)
	end
	use_colors:SetTextColor(logs.ui.Text)
	use_colors:SetFont("logs.ui.16")
	use_colors:SetText("Logarten farbig unterscheiden.")
	local fonts_info = vgui.Create("DLabel", self.Settings)
	fonts_info:SetPos(5, 160)
	fonts_info:SetSize(self.Settings:GetWide() - 10, 20)
	fonts_info:SetTextColor(logs.ui.Text)
	fonts_info:SetText("Die oberen 3 Einstellungen werden erst wirksam, wenn das Menü neugeladen wurde.")
	local ext_search = vgui.Create("DCheckBoxLabel", self.Settings)
	ext_search:SetPos(5, 185)
	ext_search:SetChecked(searchext:GetBool())
	ext_search.OnChange = function(self, checked)
		RunConsoleCommand("mg_logs_searchext", checked and 1 or 0)
	end
	ext_search:SetTextColor(logs.ui.Text)
	ext_search:SetFont("logs.ui.16")
	ext_search:SetText("Rechtsklick auf eine Loginfo sucht automatisch.")
	local voice_bind = vgui.Create("DCheckBoxLabel", self.Settings)
	voice_bind:SetPos(5, 205)
	voice_bind:SetChecked(voicebind_use:GetBool())
	voice_bind.OnChange = function(self, checked)
		RunConsoleCommand("mg_logs_color", checked and 1 or 0)
	end
	voice_bind:SetTextColor(logs.ui.Text)
	voice_bind:SetFont("logs.ui.16")
	voice_bind:SetText("Push to Talk über Taste erlauben.")
	local binds_info = vgui.Create("DLabel", self.Settings)
	binds_info:SetTextColor(logs.ui.Text)
	binds_info:SetFont("logs.ui.16")
	binds_info:SetText("Push to Talk-Taste")
	binds_info:SizeToContents()
	binds_info:SetPos(self.Settings:GetWide() / 2 - binds_info:GetWide() / 2, 225)
	local bind_select = vgui.Create("DBinder", self.Settings)
	bind_select:SetSize(100, 30)
	bind_select:SetPos(self.Settings:GetWide() / 2 - bind_select:GetWide() / 2, 245)
	bind_select:SetTextColor(logs.ui.Text)
	bind_select:SetValue(voicebind_key:GetString())
	bind_select.OnChange = function(self, num)
		RunConsoleCommand("mg_logs_voicekey", num)
	end
	local reload_menu = vgui.Create("DButton", self.Settings)
	reload_menu:SetSize(200, 30)
	reload_menu:SetPos(self.Settings:GetWide() / 2 - reload_menu:GetWide() / 2, 285)
	reload_menu:SetTextColor(logs.ui.Text)
	reload_menu:SetText("Menü neuladen")
	reload_menu.DoClick = function(slf, num)
		self:ReloadMenu()
	end
end

vgui.Register("logs_frame_main", PANEL, "DFrame")

local PANEL_2 = table.Copy(PANEL)
PANEL = nil

function PANEL_2:AddExtras()
end

vgui.Register("logs_frame", PANEL_2, "DFrame")
PANEL_2 = nil