local use_skin = CreateClientConVar("mg_logs_skin", "dark")

local surface = surface
local draw = draw

local SKIN 	= {}
logs.ui = SKIN

SKIN.PrintName = "Logs"

logs.skins = {}
function logs.AddSkin(name, translated, skin)
	logs.skins[name] = {translated, skin}
end

function logs.LoadSkin(skin)
	local skin_to_load = logs.skins[skin]
	for k, v in pairs(skin_to_load[2]) do
		SKIN[k] = v
	end
end

function logs.UpdateSkin()
	local skin = use_skin:GetString()
	if skin and logs.skins[skin] then
		logs.LoadSkin(skin)
	else
		logs.LoadSkin("default")
	end
end

cvars.AddChangeCallback("mg_logs_skin", function(cmd, old, new)
	if new == old then return end
	logs.UpdateSkin()
end)

logs.AddSkin("default", "Schimmernd",
	{
		Blur = true,
		Background = Color(245, 245, 235, 200),
		Header = Color(230, 230, 220, 225),
		Outline = Color(170, 170, 170),
		Panel = Color(245, 245, 235, 100),
		Text = Color(0, 0, 0),
		Menu = Color(230, 230, 220),
		MenuOutline = Color(170, 170, 170),
		Button = Color(230, 230, 220),
		ButtonOutline = Color(170, 170, 170),
		ButtonHovered = Color(200, 200, 190),
		ButtonText = Color(0, 0, 0),
		Column = Color(230, 230, 220),
		ColumnOutline = Color(170, 170, 170),
		ColumnHovered = Color(200, 200, 190),
		ColumnText = Color(0, 0, 0),
		ComboBox = Color(230, 230, 220),
		ComboBoxOutline = Color(170, 170, 170),
		ComboBoxHovered = Color(200, 200, 190),
		ComboBoxText = Color(0, 0, 0),
		MenuOption = Color(230, 230, 220),
		MenuOptionOutline = Color(170, 170, 170),
		MenuOptionHovered = Color(200, 200, 190),
		MenuOptionText = Color(0, 0, 0),
		ScrollBar = Color(230, 230, 220),
		ScrollBarOutline = Color(170, 170, 170),
		ScrollBarHovered = Color(200, 200, 190),
		Close = Color(0, 0, 0),
		CloseHovered = Color(255, 0, 0),
		TabButton = Color(230, 230, 220, 225),
		TabButtonOutline = Color(170, 170, 170),
		TabButtonSelected = Color(200, 200, 200),
		TabButtonText = Color(0, 0, 0),
		TextEntry = Color(230, 230, 220),
		TextEntryOutline = Color(170, 170, 170),
		TextEntryText = Color(0, 0, 0),
		TextEntryHighlight = Color(200, 200, 190),
		ListViewLine = Color(230, 230, 220),
		ListViewLineAlt = Color(200, 200, 190),
		ListViewLineHighlight = Color(200, 0, 0, 200),
		ComboDownArrow = Color(200, 0, 0, 200)
	}
)

logs.AddSkin("dark", "Düster",
	{
		Blur = true,
		Background = Color(35, 35, 35, 253),
		Header = Color(25, 25, 25, 50),
		Outline = Color(0, 0, 0),
		Panel = Color(30, 30, 30, 100),
		Text = Color(245, 245, 245),
		Menu = Color(20, 20, 20),
		MenuOutline = Color(0, 0, 0),
		Button = Color(40, 40, 40),
		ButtonOutline = Color(0, 0, 0),
		ButtonHovered = Color(50, 50, 50),
		ButtonText = Color(245, 245, 245),
		Column = Color(50, 50, 50),
		ColumnOutline = Color(0, 0, 0),
		ColumnHovered = Color(60, 60, 60),
		ColumnText = Color(245, 245, 245),
		ComboBox = Color(40, 40, 40),
		ComboBoxOutline = Color(0, 0, 0),
		ComboBoxHovered = Color(50, 50, 50),
		ComboBoxText = Color(245, 245, 245),
		MenuOption = Color(40, 40, 40),
		MenuOptionOutline = Color(0, 0, 0),
		MenuOptionHovered = Color(50, 50, 50, 190),
		MenuOptionText = Color(245, 245, 245),
		ScrollBar = Color(50, 50, 50),
		ScrollBarOutline = Color(0, 0, 0),
		ScrollBarHovered = Color(70, 70, 70, 190),
		Close = Color(245, 245, 245),
		CloseHovered = Color(255, 0, 0),
		TabButton = Color(50, 50, 50, 225),
		TabButtonOutline = Color(0, 0, 0),
		TabButtonSelected = Color(100, 100, 100),
		TabButtonText = Color(245, 245, 245),
		TextEntry = Color(45, 45, 45, 200),
		TextEntryOutline = Color(0, 0, 0),
		TextEntryText = Color(245, 245, 245),
		TextEntryHighlight = Color(51, 128, 255),
		ListViewLine = Color(230, 230, 220),
		ListViewLineAlt = Color(200, 200, 190),
		ListViewLineHighlight = Color(200, 75, 75, 200),
		ComboDownArrow = Color(200, 0, 0, 200)
	}
)

logs.UpdateSkin()

function SKIN:PaintFrame(self, w, h)
	if SKIN.Blur then
		logs.draw.Blur(self)
	end
	logs.draw.OutlinedBox(0, 0, w, h, SKIN.Background, SKIN.Outline)
	logs.draw.OutlinedBox(0, 0, w, 30, SKIN.Header, SKIN.Outline)
end

function SKIN:PaintPanel(self, w, h)
	if !self.m_bBackground then return end
	logs.draw.OutlinedBox(0, 0, w, h, SKIN.Panel, SKIN.Outline)
end

function SKIN:PaintShadow()
end

function SKIN:PaintButton(self, w, h)
	if !self.m_bBackground then return end
	local parent = self:GetParent()
	if IsValid(parent) and IsValid(parent.DraggerBar) then
		if !self.FontSet then
			self:SetTextColor(SKIN.ColumnText)
			self:SetFont("logs.ui.18")
			self.FontSet = true
		end
		logs.draw.OutlinedBox(0, 0, w, h, self:IsHovered() and SKIN.ColumnHovered or SKIN.Column, SKIN.ColumnOutline)
	else
		if !self.FontSet then
			self:SetTextColor(SKIN.ButtonText)
			self:SetFont("logs.ui.20")
			self.FontSet = true
		end
		logs.draw.OutlinedBox(0, 0, w, h, self:IsHovered() and SKIN.ButtonHovered or SKIN.Button, SKIN.ButtonOutline)
	end
end

local cross = Material("icon16/cross.png")
function SKIN:PaintWindowCloseButton(self, w, h)
	if !self.m_bBackground then return end
	if self:IsHovered() then
		surface.SetDrawColor(SKIN.CloseHovered)
	else
		surface.SetDrawColor(SKIN.Close)
	end
	surface.SetMaterial(cross)
	surface.DrawTexturedRect(5, 6, 16, 16)
end

function SKIN:PaintTextEntry(self, w, h)
	logs.draw.OutlinedBox(0, 0, w, h, SKIN.TextEntry, SKIN.TextEntryOutline)
	self:DrawTextEntryText(SKIN.TextEntryText, SKIN.TextEntryHighlight, SKIN.TextEntryText)
end

function SKIN:PaintListView(self, w, h)
end

function SKIN:PaintListViewLine(self, w, h)
	local selected = self:IsSelected()
	local hovered = self:IsHovered()
	if self.Color then
		local use_col = SKIN.ListViewLine
		logs.draw.Box(0, 0, w, h, use_col)
		self.RowColor = self.RowColor or table.Copy(self.Color)
		self.RowColor.a = 200
		use_col = (selected or hovered) and SKIN.ListViewLineHighlight or self.RowColor
		logs.draw.Box(0, 0, w, h, use_col)
	else
		local col = (selected or hovered) and SKIN.ListViewLineHighlight or SKIN.ListViewLine
		local use_col = (self.m_bAlt and !(selected or hovered)) and SKIN.ListViewLineAlt or col
		logs.draw.Box(0, 0, w, h, use_col)
	end
end

function SKIN:PaintScrollBarGrip(self, w, h)
	logs.draw.OutlinedBox(0, 0, w, h, self:IsHovered() and SKIN.ScrollBarHovered or SKIN.ScrollBar, SKIN.ScrollBarOutline)
end

SKIN.PaintButtonDown = SKIN.PaintScrollBarGrip
SKIN.PaintButtonUp = SKIN.PaintScrollBarGrip

function SKIN:PaintScrollPanel(self, w, h)
end

function SKIN:PaintVScrollBar(self, w, h)
end

function SKIN:PaintTabListButton(self, w, h)
	if self.Active or self:IsHovered() then
		logs.draw.OutlinedBox(0, 0, w, h, SKIN.TabButton, SKIN.TabButtonOutline)
		local color = logs.types[self:GetText()]
		color = color and color[3]
		if self:IsHovered() then
			logs.draw.Box(1, 1, 6, h - 2, color or SKIN.TabButtonSelected)
		else
			logs.draw.Box(1, 1, 3, h - 2, color or SKIN.TabButtonSelected)
		end
	else
		logs.draw.Outline(0, 0, w, h, SKIN.ButtonOutline)
	end
	self:SetTextColor(SKIN.TabButtonText)
end

function SKIN:PaintComboBox(self, w, h)
	if IsValid(self.Menu) and !self.Menu.SkinSet then
		self.Menu:SetSkin("logs")
		self.Menu.SkinSet = true
	end
	logs.draw.OutlinedBox(0, 0, w, h, ((self:IsHovered() or self.Depressed or self:IsMenuOpen()) and SKIN.ComboBoxHovered or SKIN.ComboBox), SKIN.ComboBoxOutline)
end

function SKIN:PaintComboDownArrow(self, w, h)
	surface.SetDrawColor(SKIN.ComboDownArrow)
	draw.NoTexture()
	local poly = {{x = 0, y = w * 0.5}, {x = h, y = 0}, {x = h, y = w}}
	surface.DrawPoly(poly)
end

function SKIN:PaintMenu(self, w, h)
	logs.draw.OutlinedBox(0, 0, w, h, SKIN.Menu, SKIN.MenuOutline)
end

function SKIN:PaintMenuOption(self, w, h)
	if !self.FontSet then
		self:SetFont("logs.ui.18")
		self:SetTextInset(5, 0)
		self.FontSet = true
	end
	self:SetTextColor(SKIN.MenuOptionText)
	logs.draw.OutlinedBox(0, 0, w, h, SKIN.MenuOption, SKIN.MenuOptionOutline)
	if self.m_bBackground and (self:IsHovered() or self.Highlight) then
		logs.draw.OutlinedBox(0, 0, w, h, SKIN.MenuOptionHovered , SKIN.MenuOptionOutline)
	end
end

derma.DefineSkin("logs", "logs derma skin", SKIN)