local function ConvertTime(seconds)
	if seconds < 1 then return "Permanent" end
	local years = math.floor(seconds / 31536000)
	seconds = seconds - (years * 31536000)
	local weeks = math.floor(seconds / 604800)
	seconds = seconds - (weeks * 604800)
	local days = math.floor(seconds / 86400)
	seconds = seconds - (days * 86400)
	local hours = math.floor(seconds / 3600)
	seconds = seconds - (hours * 3600)
	local minutes = math.floor(seconds / 60)
	seconds = seconds - (minutes * 60)
	local curtime = ""
	if years != 0 then curtime = curtime..years.." Jahr"..((years > 1) and "e, " or ", ") end
	if weeks != 0 then curtime = curtime..weeks.." Woche"..((weeks > 1) and "n, " or ", ") end
	if days != 0 then curtime = curtime..days.." Tag"..((days > 1) and "e, " or ", ") end
	if hours + minutes + seconds < 1 then return string.sub(curtime, 0, #curtime - 2) end
	curtime = curtime..((hours < 10) and "0" or "")..hours..":"
	curtime = curtime..((minutes < 10) and "0" or "")..minutes..":"
	return curtime..((seconds < 10 and "0" or "")..seconds)
end

if CLIENT then
	local base
	net.Receive("mg_banlist_sendentries", function()
		local SID, Results = net.ReadString(), net.ReadTable()
		local PlyObject = player.GetBySteamID(SID)

		if !IsValid(base) then
			base = vgui.Create("DFrame")
			base:SetSize(760, 400)
			base:Center()
			base:SetTitle("Bannliste von "..(PlyObject and PlyObject:Name() or SID))
			base:MakePopup()
		else
			local basex, basey = base:GetPos()
			base:Close()
			base = vgui.Create("DFrame")
			base:SetSize(760, 400)
			base:SetPos(basex, basey)
			base:SetTitle("Bannliste von "..(PlyObject and PlyObject:Name() or SID))
			base:MakePopup()
		end

		local EntryList = vgui.Create("DListView", base)
		EntryList:Dock(FILL)
		EntryList:AddColumn("ID"):SetFixedWidth(100)
		EntryList:AddColumn("Admin")
		EntryList:AddColumn("Grund")
		EntryList:AddColumn("Dauer")
		EntryList:AddColumn("Entbannung am")
		EntryList:AddColumn("Datum")
		EntryList.OnRowRightClick = function(_, _, line)
			if LocalPlayer():IsSuperAdmin() then
				local context = vgui.Create("DMenu", base)
				context:AddOption("Eintrag löschen", function()
					net.Start("mg_banlist_removeentry")
						net.WriteString(line:GetValue(1))
						net.WriteString(SID)
					net.SendToServer()
				end):SetIcon("icon16/delete.png")

				context:AddOption("Alle Einträge löschen", function()
					net.Start("mg_banlist_removeentry")
						net.WriteString("")
						net.WriteString(SID)
					net.SendToServer()
					base:Remove()
				end):SetIcon("icon16/shield_delete.png")
				context:Open()
			end
		end
		for k, v in ipairs(Results) do
			if !v.unban_on then continue end -- Dafuq, this sometimes errors

			if v.status == "1" then
				EntryList:AddLine(v.id, v.admin.." (Editiert)", (v.reason == "NULL" and "-" or v.reason), ConvertTime(v.unban_on - v.banned_on), (v.unban_on == "0" and "Nie" or os.date("%d.%m.%Y %H:%M:%S", v.unban_on)), os.date("%d.%m.%Y %H:%M:%S", v.banned_on))
			else
				EntryList:AddLine(v.id, v.admin, (v.reason == "NULL" and "-" or v.reason), ConvertTime(v.unban_on - v.banned_on), (v.unban_on == "0" and "Nie" or os.date("%d.%m.%Y %H:%M:%S", v.unban_on)), os.date("%d.%m.%Y %H:%M:%S", v.banned_on))
			end
		end
	end)
end

function ulx.banlist(calling_ply, target_ply)
	if !calling_ply:IsValid() then
		Msg("You can't open the banlist from the dedicated server console.\n")
		return
	end
	MG_Banlist.RequestEntries(calling_ply, target_ply:SteamID())
end
local banlist = ulx.command("Watchlist", "ulx banlist", ulx.banlist, "!banlist", true)
banlist:addParam{type=ULib.cmds.PlayerArg}
banlist:help("Opens banlist of target.")
banlist:defaultAccess(ULib.ACCESS_ADMIN)

function ulx.banlistid(calling_ply, TargetSID)
	if !calling_ply:IsValid() then
		Msg("You can't open the banlist from the dedicated server console.\n")
		return
	end
	if !ULib.isValidSteamID(TargetSID) then ULib.tsayError(calling_ply, "Invalid steamid.") return end
	MG_Banlist.RequestEntries(calling_ply, TargetSID)
end
local banlistid = ulx.command("Watchlist", "ulx banlistid", ulx.banlistid, "!banlistid", true)
banlistid:addParam{type=ULib.cmds.StringArg, hint="SteamID"}
banlistid:help("Opens banlist of target, using steamid.")
banlistid:defaultAccess(ULib.ACCESS_ADMIN)