MG_JB = MG_JB or {}

MG_JB.IndexJob_Team_Name = {}
MG_JB.IndexJob_Name_Command = {}
MG_JB.IndexJob_Command_Name = {}
MG_JB.IndexJob_Command_Team = {}

timer.Simple(0,function()
	if !DarkRP then return end
	for k, v in pairs(RPExtraTeams) do
		MG_JB.IndexJob_Team_Name[k] = v.name
		MG_JB.IndexJob_Name_Command[v.name] = v.command
		MG_JB.IndexJob_Command_Name[v.command] = v.name
		MG_JB.IndexJob_Command_Team[v.command] = k
	end
end)

function ulx.showjobbans(calling_ply, target_ply)
	local is_ply = IsValid(calling_ply)
	local name = target_ply:Name()
	local steamid = target_ply:SteamID()
	MG_JB.GetJobBans(steamid, function(results)
		if is_ply and !IsValid(calling_ply) then return end
		if !results or !istable(results) or table.IsEmpty(results) then ULib.tsayError(calling_ply, name.." is not job-banned!") return end
		if is_ply then
			net.Start("MG_JB_ShowJobBans")
				net.WriteString(name)
				net.WriteTable(results)
			net.Send(calling_ply)
		else
			ULib.console(calling_ply, "SteamID | Name | Admin | Datum | Verbleibende Zeit | Grund")
			for _, v in ipairs(results) do
				ULib.console(calling_ply, v.steamid.." | "..(v.name or "Unbekannt").." | "..(v.admin or "Unbekannt").." | "..os.date("%d.%m.%y - %H:%M:%S", v.date).." | "..((tonumber(v.unban) != 0 and ULib.secondsToStringTime(tonumber(v.unban) - os.time())) or "Permanent").." | "..(v.reason or "Kein Grund angegeben"))
			end
		end
	end)
end
local showjobbans = ulx.command("Job-Ban", "ulx showjobbans", ulx.showjobbans, "!showjobbans", true)
showjobbans:addParam{type = ULib.cmds.PlayerArg}
showjobbans:defaultAccess(ULib.ACCESS_ADMIN)
showjobbans:help("Shows all job bans of target.")

function ulx.showjobbansid(calling_ply, steamid)
	steamid = steamid:upper()
	if !ULib.isValidSteamID(steamid) then
		ULib.tsayError(calling_ply, "Invalid steamid.")
		return
	end
	local is_ply = IsValid(calling_ply)
	local name = steamid
	MG_JB.GetJobBans(steamid, function(results)
		if is_ply and !IsValid(calling_ply) then return end
		if !results or !istable(results) or table.IsEmpty(results) then ULib.tsayError(calling_ply, name.." is not job-banned!") return end
		if !IsValid(calling_ply) then return end
		if is_ply then
			net.Start("MG_JB_ShowJobBans")
				net.WriteString(name)
				net.WriteTable(results)
			net.Send(calling_ply)
		else
			ULib.console(calling_ply, "SteamID | Name | Admin | Datum | Verbleibende Zeit | Grund")
			for _, v in ipairs(results) do
				ULib.console(calling_ply, v.steamid.." | "..(v.name or "Unbekannt").." | "..(v.admin or "Unbekannt").." | "..os.date("%d.%m.%y - %H:%M:%S", v.date).." | "..((tonumber(v.unban) != 0 and ULib.secondsToStringTime(tonumber(v.unban) - os.time())) or "Permanent").." | "..(v.reason or "Kein Grund angegeben"))
			end
		end
	end)
end
local showjobbansid = ulx.command("Job-Ban", "ulx showjobbansid", ulx.showjobbansid, "!showjobbansid", true)
showjobbansid:addParam{type = ULib.cmds.StringArg, hint = "steamid"}
showjobbansid:defaultAccess(ULib.ACCESS_ADMIN)
showjobbansid:help("Shows all job bans of target, using steamid.")

function ulx.jobunban(calling_ply, target_ply, job)
	MG_JB.RemoveJobBan(calling_ply, target_ply, job)
end
local jobunban = ulx.command("Job-Ban", "ulx jobunban", ulx.jobunban, "!jobunban", true)
jobunban:addParam{type = ULib.cmds.PlayerArg}
jobunban:addParam{type = ULib.cmds.StringArg, hint = "Job", completes = MG_JB.IndexJob_Team_Name, ULib.cmds.restrictToCompletes}
jobunban:defaultAccess(ULib.ACCESS_ADMIN)
jobunban:help("Remove job ban of target, using steamid.")

function ulx.jobunbanid(calling_ply, steamid, job)
	MG_JB.RemoveJobBan(calling_ply, steamid, job)
end
local jobunbanid = ulx.command("Job-Ban", "ulx jobunbanid", ulx.jobunbanid, "!jobunbanid", true)
jobunbanid:addParam{type = ULib.cmds.StringArg, hint = "steamid"}
jobunbanid:addParam{type = ULib.cmds.StringArg, hint = "job", completes = MG_JB.IndexJob_Team_Name, ULib.cmds.restrictToCompletes}
jobunbanid:defaultAccess(ULib.ACCESS_ADMIN)
jobunbanid:help("Remove job ban of target, using steamid.")

function ulx.jobban(calling_ply, target_ply, job, minutes, reason)
	MG_JB.JobBan(calling_ply, target_ply, minutes, reason, job)
end
local jobban = ulx.command("Job-Ban", "ulx jobban", ulx.jobban, "!jobban", true)
jobban:addParam{type = ULib.cmds.PlayerArg}
jobban:addParam{type = ULib.cmds.StringArg, hint = "job", completes = MG_JB.IndexJob_Team_Name, ULib.cmds.restrictToCompletes}
jobban:addParam{type=ULib.cmds.NumArg, hint="minutes, 0 for perma", ULib.cmds.optional, ULib.cmds.allowTimeString, min=0}
jobban:addParam{type=ULib.cmds.StringArg, hint="reason", ULib.cmds.optional, ULib.cmds.takeRestOfLine, completes=ulx.common_kick_reasons}
jobban:defaultAccess(ULib.ACCESS_ADMIN)
jobban:help("Bans target from job.")

function ulx.jobbanid(calling_ply, steamid, job, minutes, reason)
	MG_JB.JobBanID(calling_ply, steamid, minutes, reason, job)
end
local jobbanid = ulx.command("Job-Ban", "ulx jobbanid", ulx.jobbanid, "!jobbanid", true)
jobbanid:addParam{type = ULib.cmds.StringArg, hint = "steamid"}
jobbanid:addParam{type = ULib.cmds.StringArg, hint = "Job", completes = MG_JB.IndexJob_Team_Name}
jobbanid:addParam{type=ULib.cmds.NumArg, hint="minutes, 0 for perma", ULib.cmds.optional, ULib.cmds.allowTimeString, min=0}
jobbanid:addParam{type=ULib.cmds.StringArg, hint="reason", ULib.cmds.optional, ULib.cmds.takeRestOfLine, completes=ulx.common_kick_reasons}
jobbanid:defaultAccess(ULib.ACCESS_ADMIN)
jobbanid:help("Bans target from job, using steamid.")

function ulx.clearjobbans(calling_ply, target_ply)
	MG_JB.ClearJobBans(calling_ply, target_ply)
end
local clearjobbans = ulx.command("Job-Ban", "ulx clearjobbans", ulx.clearjobbans, "!clearjobbans", true)
clearjobbans:addParam{type = ULib.cmds.PlayerArg}
clearjobbans:defaultAccess(ULib.ACCESS_ADMIN)
clearjobbans:help("Clears all job bans of target.")

function ulx.clearjobbansid(calling_ply, steamid)
	MG_JB.ClearJobBans(calling_ply, steamid)
end
local clearjobbansid = ulx.command("Job-Ban", "ulx clearjobbansid", ulx.clearjobbansid, "!clearjobbansid", true)
clearjobbansid:addParam{type = ULib.cmds.StringArg, hint = "steamid"}
clearjobbansid:defaultAccess(ULib.ACCESS_ADMIN)
clearjobbansid:help("Clears all job bans of target, using steamid.")

if CLIENT then
	local Frame
	net.Receive("MG_JB_ShowJobBans", function()
		local name = net.ReadString()
		local bans = net.ReadTable()
		if IsValid(Frame) then Frame:Close() end
		Frame = vgui.Create("DFrame")
		Frame:SetSize(760, 400)
		Frame:Center()
		Frame:MakePopup()
		Frame:SetTitle("Job-Banns von "..name)
		local List = vgui.Create("DListView", Frame)
		List:Dock(FILL)
		List:SetMultiSelect(false)
		List:AddColumn("Name")
		List:AddColumn("Ausführender Admin")
		List:AddColumn("Datum")
		List:AddColumn("Verbleibende Zeit")
		List:AddColumn("Job")
		List:AddColumn("Grund")

		local function AddLines()
			for _, v in ipairs(bans) do
				List:AddLine(v.name or "Unbekannt", v.admin or "Unbekannt", os.date("%d.%m.%y - %H:%M:%S", v.date), (tonumber(v.unban) != 0 and ULib.secondsToStringTime(tonumber(v.unban) - os.time())) or "Permanent", MG_JB.IndexJob_Command_Name[v.team] or "NaN", v.reason or "Kein Grund angegeben")
			end
		end
		AddLines()

		function List:OnRowSelected(row, panel)
			local Menu = vgui.Create("DMenu", panel)
			Menu:AddOption("Bann entfernen", function()
				RunConsoleCommand("ulx", "jobunbanid", bans[row].steamid, MG_JB.IndexJob_Command_Name[bans[row].team])
				table.remove(bans, row)
				List:Clear()
				AddLines()
			end):SetIcon("icon16/key.png")
			Menu:AddSpacer()
			Menu:AddOption("Alle Banns entfernen", function()
				RunConsoleCommand("ulx", "clearjobbansid", bans[row].steamid)
				if IsValid(Frame) then
					Frame:Remove()
				end
			end):SetIcon("icon16/cross.png")
			Menu:Open()
		end
	end)
end