function ulx.resetdata(calling_ply, steamid)
	steamid = steamid:upper()
	if !ULib.isValidSteamID(steamid) then
		ULib.tsayError(calling_ply, "Invalid steamid.")
		return
	end
	local target_ply = player.GetBySteamID(steamid)
	if IsValid(target_ply) then
		ULib.tsayError(calling_ply, target_ply:Name().." needs to be offline in order for this to work.")
		return
	end

	local steamid64 = util.SteamIDTo64(steamid)
	local uid = util.CRC("gm_"..steamid.."_gm")

	-- DarkRP
	if DarkRP then
		MySQLite.query("UPDATE darkrp_player SET wallet = "..GAMEMODE.Config.startingmoney.." WHERE uid = '"..steamid64.."'")
		MySQLite.query("UPDATE darkrp_player SET wallet = "..GAMEMODE.Config.startingmoney.." WHERE uid = '"..uid.."'")
	end

	-- Inventar
	if itemstore and itemstore.data then
		itemstore.data.ResetID(steamid)
	end

	-- Autohändler
	if MG_CarDealer_Provider then
		MG_CarDealer_Provider.ResetPlayer(steamid)
	end

	-- Kennzeichen
	if LicensePlates then
		LicensePlates.ResetPlayer(steamid)
	end

	-- GlorifiedBanking
	if GlorifiedBanking then
		GlorifiedBanking.SetPlayerBalanceBySteamID(steamid64, GlorifiedBanking.Config.STARTING_BALANCE)
	end

	-- XP
	if MG_LevelSys and MG_LevelSys.StoreData then
		MG_LevelSys.StoreData(steamid, 0, 0, 0, {})
	end

	ulx.fancyLogAdmin(calling_ply, "#A reset data of #s", steamid)
end
local resetdata = ulx.command("User Management", "ulx resetdata", ulx.resetdata, "!resetdata")
resetdata:addParam{type=ULib.cmds.StringArg, hint="steamid"}
resetdata:defaultAccess(ULib.ACCESS_SUPERADMIN)
resetdata:help("Resets all related data of this user.")
