local welcome_msg = "Willkommen auf Modern Roleplay!"

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("namechange_font1", {font = use_font, size = 22, antialias = true, weight = 1000, shadow = true})
surface.CreateFont("namechange_font2", {font = "Roboto", size = 20, antialias = true, weight = 1000})
surface.CreateFont("namechange_font3", {font = "Roboto", size = 18, antialias = true, weight = 1000})

local correct, incorrect = Material("icon16/accept.png"), Material("icon16/cross.png")
local NameMenu
local function OpenNameChangeMenu(enforce)
	local ply = LocalPlayer()
	if !IsValid(ply) or !ply.getDarkRPVar or IsValid(NameMenu) then return end
	local submitted = false
	local previousname = ply:getDarkRPVar("rpname")
	local dtext, dtext2, dbutton1
	NameMenu = vgui.Create("DFrame")
	NameMenu:SetSize(550, 300)
	NameMenu:SetTitle("")
	NameMenu:Center()
	NameMenu:ShowCloseButton(false)
	NameMenu:SetDraggable(false)
	NameMenu:MakePopup()
	NameMenu:ParentToHUD()
	NameMenu.Paint = function(self, w, h)
		draw.RoundedBox(8, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBox(8, 3, 3, w - 6, h - 6, Color(20, 20, 20, 255))
		surface.SetFont("namechange_font1")
		local x, y = surface.GetTextSize(welcome_msg)
		draw.RoundedBox(8, w * 0.5 - x / 2 - 4, 5, x + 8, y, Color(49, 78, 85, 255))
		draw.SimpleText(welcome_msg, "namechange_font1", w / 2, 5, color_white, TEXT_ALIGN_CENTER)
		draw.SimpleText(enforce and "Bitte erstelle dir einen RP-Namen für deinen Spielcharakter." or "Hier kannst du deinen Namen über eine simple Oberfläche ändern.", "namechange_font2", w / 2, 70, color_white, TEXT_ALIGN_CENTER)
		draw.SimpleText(enforce and "Du wirst diesen im Spiel zu jeder Zeit ändern können." or "Tipp: Du kannst im Feld \"Nachname\" auch einen dritten Namen angeben.", "namechange_font2", w / 2, 90, color_white, TEXT_ALIGN_CENTER)
		draw.SimpleText("Vorname:", "namechange_font2", w / 2, 134, color_white, TEXT_ALIGN_CENTER)
		draw.SimpleText("Nachname:", "namechange_font2", w / 2, 184, color_white, TEXT_ALIGN_CENTER)
		surface.SetDrawColor(255, 255, 255, 255)
		if dtext.Correct then
			surface.SetMaterial(correct)
			surface.DrawTexturedRect(380, 157, 16, 16)
		else
			surface.SetMaterial(incorrect)
			surface.DrawTexturedRect(380, 157, 16, 16)
		end
		if dtext2.Correct then
			surface.SetMaterial(correct)
			surface.DrawTexturedRect(380, 207, 16, 16)
		else
			surface.SetMaterial(incorrect)
			surface.DrawTexturedRect(380, 207, 16, 16)
		end
		surface.SetDrawColor(175, 175, 175, 255)
		surface.DrawRect(w / 2 - 101, 154, 202, 22)
		surface.DrawRect(w / 2 - 101, 204, 202, 22)
	end
	if !enforce then
		local close = vgui.Create("DButton", NameMenu)
		close:SetSize(50, 20)
		close:SetPos(NameMenu:GetWide() - 55, 5)
		close:SetText("X")
		close:SetFont("namechange_font1")
		close:SetTextColor(color_white)
		close.Paint = function(self, w, h)
			local col
			if self:IsHovered() then
				col = Color(255, 100, 100)
			else
				col = Color(200, 50, 50)
			end
			draw.RoundedBox(4, 0, 0, w, h, col)
		end
		close.DoClick = function()
			surface.PlaySound("ui/buttonclick.wav")
			NameMenu:Remove()
		end
	end
	dtext = vgui.Create("DTextEntry", NameMenu)
	dtext:SetSize(200, 20)
	dtext:SetPos(NameMenu:GetWide() / 2 - 100, 155)
	dtext2 = vgui.Create("DTextEntry", NameMenu)
	dtext2:SetSize(200, 20)
	dtext2:SetPos(NameMenu:GetWide() / 2 - 100, 205)
	dbutton1 = vgui.Create("DButton", NameMenu)
	dbutton1:SetSize(80, 25)
	dbutton1:SetPos(NameMenu:GetWide() / 2 - dbutton1:GetWide() / 2, NameMenu:GetTall() * 0.85)
	dbutton1:SetText("")
	dbutton1:SetDisabled(true)
	dbutton1.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, self.MouseOver and Color(200, 200, 200, 255) or Color(100, 100, 100, 255))
		draw.RoundedBox(4, 1, 1, w - 2, h - 2, !self:GetDisabled() and Color(30, 180, 0, 255) or Color(120, 120, 120, 255))
		draw.SimpleTextOutlined("Bestätigen", "namechange_font3", self:GetWide() / 2, 5, !self:GetDisabled() and color_white or Color(180, 180, 180, 255), TEXT_ALIGN_CENTER, nil, 1, color_black)
	end
	local oldthink = NameMenu.Think
	function NameMenu:Think(...)
		oldthink(self, ...)
		dbutton1:SetDisabled(!(dtext.Correct and dtext2.Correct)) 
		if submitted and previousname != ply:getDarkRPVar("rpname") then
			self:Remove()
		end
	end
	dbutton1.DoClick = function(self)
		surface.PlaySound("ui/buttonclick.wav")
		RunConsoleCommand("darkrp", "rpname", dtext:GetText().." "..dtext2:GetText())
		submitted = true
	end
	dbutton1.OnCursorEntered = function(self)
		self.MouseOver = true
	end
	dbutton1.OnCursorExited = function(self)
		self.MouseOver = false
	end	
	function dtext:GetUpdateOnType()
		return true
	end
	function dtext2:GetUpdateOnType()
		return true
	end
	function dtext:OnValueChange(text)
		local first, toomuch = string.match(text, "^%s*(%S+)%s*(%S*)")
		if toomuch and #toomuch > 0 then
			self:SetTooltip("Schreibe nur deinen Vornamen hier rein!")
			self.Correct = false
			return
		end
		local succ, reason = NameChange.CheckNamePart(first, "Vorname")
		self:SetTooltip(!succ and reason)
		self.Correct = succ
	end
	function dtext2:OnValueChange(text)
		local second, third, toomuch = string.match(text, "^%s*(%S+)%s*(%S*)%s*(%S*)")
		if toomuch and #toomuch > 0 then
			self.Correct = false
			self:SetTooltip("Du hast zu viele Namen!")
			return
		end
		local succ, reason = NameChange.CheckNamePart(second, "Nachname")
		if !succ then
			self.Correct = false
			self:SetTooltip(reason)
			return
		end
		if third and #toomuch > 0 then 
			local succ, reason = NameChange.CheckNamePart(third, "Drittname")
			if !succ then
				self.Correct = false
				self:SetTooltip(reason)
				return
			end
		end
		self:SetTooltip()
		self.Correct = true
	end
end

net.Receive("NameChange_OpenMenu",function()
	OpenNameChangeMenu(net.ReadBool())
end)