NameChange = NameChange or {}

properties.Add("forcename",{
	MenuLabel =	"Namensänderung erzwingen",
	Order =	2,
	MenuIcon = "icon16/comment_edit.png",
	Filter = function(self, ent, ply) 
		if !IsValid(ent) or !IsValid(ply) then return false end
		if !ent:IsPlayer() or ent:IsAdmin() or !ply:IsAdmin() then return false end
		return true
	end,
	Action = function(self, ent)
		self:MsgStart()
			net.WriteEntity(ent)
		self:MsgEnd()
	end,
	Receive	= function(self, length, ply)
		local ent = net.ReadEntity()
		if !IsValid(ent) or !IsValid(ply) then return false end
		if !ent:IsPlayer() or ent:IsAdmin() or !ply:IsAdmin() then return end
		NameChange.OpenMenu(ent, true)
		DarkRP.notify(ply, 0, 6, "Namensänderung angefordert.")
		DarkRP.notify(ent, 1, 7, "Dein Name ist gegen die Regeln. Bitte ändere ihn!")
	end	
})

include("nameblacklist.lua")

local nameletters = "[A-Za-züöäßÜÖÄ]"
local matchstring = "(%S)(%S+)"
local name_lenmin = 2
local name_lenmax = 12
function NameChange.CheckNamePart(name, typ)
	local len = name and utf8.len(name)
	if !name or len == 0 then
		return false, string.format("Bitte gebe deinen %sn an.", typ)
	end
	local name = string.match(name, "^%s*("..nameletters.."+)%s*$")
	if !name then 
		return false, "Es sind nur deutsche und lateinische Buchstaben erlaubt. Ändere deinen "..typ.."n!"
	end
	if len < name_lenmin then
		return false, string.format("Dein %s ist zu kurz! Er muss mindestens %i Buchstaben lang sein!", typ, name_lenmin)
	end
	if len > name_lenmax then 
		return false, string.format("Dein %s ist zu lang! Er darf maximal %i Buchstaben lang sein!", typ, name_lenmax)
	end
	if (NameChange.Blacklist[string.lower(name)] == true) then
		return false, string.format("Dein %s ist verboten! Bitte ändere ihn!", typ)
	end
	return true, name
end

local oldUpper = string.upper
function string.upper(str)
	str = string.gsub(str, "ä", "Ä")
	str = string.gsub(str, "ö", "Ö")
	str = string.gsub(str, "ü", "Ü")
	return oldUpper(str)
end

local oldLower = string.lower
function string.lower(str)
	str = string.gsub(str, "Ä", "a")
	str = string.gsub(str, "Ö", "ö")
	str = string.gsub(str, "Ü", "ü")
	return oldLower(str)
end

function NameChange.CheckName(name)
	local parts = {}
	for big, small in string.gmatch(name, matchstring) do
		table.insert(parts, big)
		table.insert(parts, small)
	end
	local F, irst, S, econd, T, hird, toomuch = unpack(parts)
	if !F or !irst or !S or !econd then
		return false, "Du musst einen Vor und Nachnamen angeben!"
	end
	if toomuch then
		return false, "Dieser Name ist zu lang!"
	end
	local succ, reason = NameChange.CheckNamePart(F..irst, "Vorname")
	if !succ then return false, reason end
	local succ, reason = NameChange.CheckNamePart(S..econd, "Nachname")
	if !succ then return false, reason end
	if T and hird and #T > 0 then
		local succ, reason = NameChange.CheckNamePart(T..hird, "Drittname")
		if !succ then return false, reason end
	end
	local First = string.upper(F)..string.lower(irst)
	local Second = string.upper(S)..string.lower(econd)
	local Third = T and hird and (string.upper(T)..string.lower(hird))
	if First == Second then
		return false, "Dein Vor und Nachname ist identisch. Bitte ändere ihn!"
	end
	if Third and First == Third then
		return false, "Dein Vor und Drittname ist identisch. Bitte ändere ihn!"
	end
	if Third and Third == Second then
		return false, "Dein Nach und Drittname ist identisch. Bitte ändere ihn!"
	end
	return true, First.." "..Second..(Third and (" "..Third) or "")
end