include("shared.lua")


function ENT:Initialize()
	self:UpdatePitch()

	self.UpdateSound = false

	self.LastState = "nil"

	zrush.f.EntList_Add(self)
end

function ENT:UpdateModules()
	local tb = self:GetTable()
	if !tb then return end

	if tb.ModuleSocket then
		for i = 1, #tb.ModuleSocket do
			local ent = tb.ModuleSocket[i]
			if IsValid(ent) then
				local aPoint = zrush.utility.MachineSockets[tb.MachineID][i]
				local attach = self:GetAttachment(aPoint)
				if !attach then continue end
				ent:SetPos(attach.Pos)
				local ang = attach.Ang
				ang:RotateAroundAxis(attach.Ang:Right(), -90)
				ang:RotateAroundAxis(attach.Ang:Up(), -180)
				ent:SetAngles(ang)
				ent:DrawModel()
			else
				tb.ModuleSocket = nil
				break
			end
		end
	end

	if !tb.ModuleSocket then
		local count = math.Clamp(zrush.config.Machine[tb.MachineID].Module_Sockets, 1, table.Count(zrush.utility.MachineSockets[tb.MachineID]))
		tb.ModuleSocket = tb.ModuleSocket or {}

		for i = 1, count do
			local aPoint = zrush.utility.MachineSockets[tb.MachineID][i]
			local attach = self:GetAttachment(aPoint)
			if !attach then continue end
			local socket = ClientsideModel("models/zerochain/props_oilrush/zor_module_socket.mdl")
			if !IsValid(socket) then return end
			socket:SetPos(attach.Pos)
			local ang = attach.Ang
			ang:RotateAroundAxis(attach.Ang:Right(), -90)
			ang:RotateAroundAxis(attach.Ang:Up(), -180)
			socket:SetAngles(ang)
			socket:SetNoDraw(true)
			socket:DrawModel()
			table.insert(tb.ModuleSocket, socket)
		end
	end
end

function ENT:Draw()
	self:DrawModel()
	self:UpdateModules()
end

function ENT:UpdatePitch()
	local maxSpeed = zrush.config.Machine[self.MachineID].Speed * 2
	local current_Speed = zrush.config.Machine[self.MachineID].Speed * (1 + self:GetSpeedBoost())
	self.SoundPitch = math.Clamp((140 / maxSpeed) * current_Speed, 0, 140) // Maybe replace 140 with 200 idk
end

// This Updates some of the Sound Info
function ENT:UpdateSoundInfo()
	self:UpdatePitch()
	self.UpdateSound = true
end

local localPly
local updateDistance = GetConVar("mg_rush_cl_vfx_updatedistance")
function ENT:Think()
	localPly = localPly or LocalPlayer()
	local tb = self:GetTable()
	if !tb then return end

	if zrush.f.InDistance(localPly:EyePos(), self:GetPos(), updateDistance:GetFloat()) then
		local dt = tb.dt
		if !dt then return end

		// One time Effect Creation
		local cur_state = dt.State
		if tb.LastState ~= cur_state then

			tb.LastState = cur_state

			self:StopParticles()

			if (tb.LastState == "BURNING_GAS") then
				zrush.f.ParticleEffectAttach("zrush_burner", self, 4)
			elseif (tb.LastState == "OVERHEAT") then
				zrush.f.ParticleEffectAttach("zrush_burner_overheat", self, 4)
			end
		end

		// Playing looped sound
		zrush.f.LoopedSound(self, "zrush_sfx_overheat_loop", dt.OverHeat == true and cur_state == "OVERHEAT",70)
		zrush.f.LoopedSound(self, "zrush_sfx_refine", dt.OverHeat == false and cur_state == "BURNING_GAS", tb.SoundPitch)
	else
		if tb.LastState then
			tb.LastState = nil
			self:StopParticles()
		end
	end

	self:SetNextClientThink(CurTime())
	return true
end

function ENT:OnRemove()
	if self.ModuleSocket then
		for i = 1, #self.ModuleSocket do
			local ent = self.ModuleSocket[i]
			SafeRemoveEntity(self.ModuleSocket[i])
		end
	end

	self:StopSound("zrush_sfx_overheat_loop")
	self:StopSound("zrush_sfx_refine")

	self:StopParticles()

	zrush.f.EntList_Remove(self)
end