include("shared.lua")

function ENT:Draw()
	self:DrawModel()
end

function ENT:Initialize()
	self.HasEffect = false
	self.LastState = "nil"
end

local localPly
local updateDistance = GetConVar("mg_rush_cl_vfx_updatedistance")
function ENT:Think()
	localPly = localPly or LocalPlayer()
	local tb = self:GetTable()
	if !tb then return end

	if zrush.f.InDistance(localPly:EyePos(), self:GetPos(), updateDistance:GetFloat()) then
		local dt = tb.dt
		if !dt then return end

		// One time Effect Creation
		local cur_state = dt.State
		if tb.LastState ~= cur_state then

			tb.LastState = cur_state

			self:StopParticles()

			if (tb.LastState == "NEED_BURNER") then
				zrush.f.ParticleEffectAttach("zrush_butangas", self, 0)
				tb.HasEffect = true
			end
		end

		// The Sound of the gas
		zrush.f.LoopedSound(self, "zrush_sfx_butangas", cur_state == "NEED_BURNER",80)
	else
		if tb.HasEffect == true then
			tb.HasEffect = false
			self:StopParticles()
		end
	end

	self:SetNextClientThink(CurTime())
	return true
end

function ENT:OnRemove()
	self:StopSound("zrush_sfx_butangas")
	self:StopParticles()
end