include("shared.lua")

local localPly, wep
function ENT:HasToolActive()
	localPly = localPly or LocalPlayer()
	wep = localPly:GetActiveWeapon()
	if wep:IsValid() and wep:GetClass() == "oilspot_generator" then
		return true
	end

	return false
end

function ENT:Draw()
	if (!self:HasToolActive()) then return end

	self:DrawModel()
	self:DrawInfo01()

	localPly = localPly or LocalPlayer()
	if zrush.f.InDistance(localPly:EyePos(), self:GetPos(), 1000) then
		self:DrawInfo02()
	end
end

function ENT:DrawInfo01()
	local Pos = self:GetPos()
	local Ang = self:GetAngles()
	local size = self:GetSpawnRadius() * 2.25
	cam.Start3D2D(Pos, Ang, 1)
		surface.SetDrawColor(zrush.default_colors["black04"])
		surface.SetMaterial(zrush.default_materials["circle"])
		surface.DrawTexturedRect(-size / 2, -size / 2, size, size)
	cam.End3D2D()
end

function ENT:DrawInfo02()
	local Pos = self:GetPos()
	local Ang = Angle(0, EyeAngles().y - 90, 90)
	Pos = Pos + Ang:Right() * -20
	local Text = zrush.language.General["OilSpotSpawner"]
	cam.Start3D2D(Pos, Ang, 0.2)
		draw.DrawText(Text, "zrush_oilspotgenerator_font01", 0, -75, zrush.default_colors["white01"], TEXT_ALIGN_CENTER)
	cam.End3D2D()
end
