include("shared.lua")


function ENT:Initialize()
	self:UpdatePitch()

	self.UpdateSound = false

	self.LastState = "nil"

	zrush.f.EntList_Add(self)
end

function ENT:UpdateModules()
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end

	if tb.ModuleSocket then
		for i = 1, #tb.ModuleSocket do
			local ent = tb.ModuleSocket[i]
			if IsValid(ent) then
				local aPoint = zrush.utility.MachineSockets[tb.MachineID][i]
				local attach = self:GetAttachment(aPoint)
				if !attach then continue end
				ent:SetPos(attach.Pos)
				local ang = attach.Ang
				ang:RotateAroundAxis(attach.Ang:Right(), -90)
				ang:RotateAroundAxis(attach.Ang:Up(), -180)
				ent:SetAngles(ang)
				ent:DrawModel()
			else
				tb.ModuleSocket = nil
				break
			end
		end
	end

	if !tb.ModuleSocket then
		local count = math.Clamp(zrush.config.Machine[tb.MachineID].Module_Sockets, 1, table.Count(zrush.utility.MachineSockets[tb.MachineID]))
		tb.ModuleSocket = tb.ModuleSocket or {}

		for i = 1, count do
			local aPoint = zrush.utility.MachineSockets[tb.MachineID][i]
			local attach = self:GetAttachment(aPoint)
			if !attach then continue end
			local socket = ClientsideModel("models/zerochain/props_oilrush/zor_module_socket.mdl")
			if !IsValid(socket) then return end
			socket:SetPos(attach.Pos)
			local ang = attach.Ang
			ang:RotateAroundAxis(attach.Ang:Right(), -90)
			ang:RotateAroundAxis(attach.Ang:Up(), -180)
			socket:SetAngles(ang)
			socket:SetNoDraw(true)
			socket:DrawModel()
			table.insert(tb.ModuleSocket, socket)
		end
	end
end

local localPly
function ENT:Draw()
	localPly = localPly or LocalPlayer()

	self:DrawModel()
	self:UpdateModules()

	if zrush.f.DrawUI() and zrush.f.InDistance(localPly:EyePos(), self:GetPos(), 500) then
		self:Draw_MainInfo()
	end
end

local time = 0
local progress = 0
local l_pos = Vector(0,-24.3,69.5)
local l_ang = Angle(0,0,90)

function ENT:Draw_MainInfo(col)
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end

	local lColor = zrush.Fuel[dt.FuelTypeID].color

	cam.Start3D2D(self:LocalToWorld(l_pos), self:LocalToWorldAngles(l_ang), 0.1)
		draw.RoundedBox(0, -53, -50, 108, 108, zrush.trans_fuelcolors[dt.FuelTypeID])

		if tb.LastState == "REFINING" then

			if (time > 100) then
				time = 0
			end

			local boostBoni = zrush.f.ReturnBoostValue(tb.MachineID, "speed", self)

			time = time + 20 * FrameTime()
			progress = (1 / 100) * time

			surface.SetDrawColor(lColor)
			surface.SetMaterial(zrush.default_materials["circle_refining"])
			surface.DrawTexturedRectRotated(0, 0, 100, 100, Lerp(progress, 360, 0))
		end
	cam.End3D2D()
end

function ENT:UpdatePitch()
	local maxSpeed = zrush.config.Machine[self.MachineID].Speed * 2
	local current_Speed = zrush.config.Machine[self.MachineID].Speed * (1 + self:GetSpeedBoost())
	self.SoundPitch = math.Clamp((140 / maxSpeed) * current_Speed, 0, 140) // Maybe replace 140 with 200 idk
end

// This Updates some of the Sound Info
function ENT:UpdateSoundInfo()
	self:UpdatePitch()
	self.UpdateSound = true
end

local localPly
local updateDistance = GetConVar("mg_rush_cl_vfx_updatedistance")

function ENT:Think()
	localPly = localPly or LocalPlayer()
	local tb = self:GetTable()
	if !tb then return end

	if zrush.f.InDistance(localPly:EyePos(), self:GetPos(), updateDistance:GetFloat()) then
		local dt = tb.dt
		if !dt then return end

		// One time Effect Creation
		local cur_state = dt.State
		if tb.LastState ~= cur_state then

			tb.LastState = cur_state

			self:StopParticles()

			if (tb.LastState == "REFINING") then
				zrush.f.ParticleEffectAttach("zrush_burner", self, 7)

			elseif (tb.LastState == "OVERHEAT") then
				zrush.f.ParticleEffectAttach("zrush_refinery_overheat", self, 7)

			end
		end

		// Playing looped sound
		zrush.f.LoopedSound(self, "zrush_sfx_overheat_loop", dt.OverHeat == true and cur_state == "OVERHEAT",70)
		zrush.f.LoopedSound(self, "zrush_sfx_refine", dt.OverHeat == false and cur_state == "REFINING", tb.SoundPitch)
	else
		if tb.LastState then
			tb.LastState = nil
			self:StopParticles()
		end
	end

	self:SetNextClientThink(CurTime())
	return true
end

function ENT:OnRemove()
	if self.ModuleSocket then
		for i = 1, #self.ModuleSocket do
			local ent = self.ModuleSocket[i]
			SafeRemoveEntity(self.ModuleSocket[i])
		end
	end

	self:StopSound("zrush_sfx_overheat_loop")
	self:StopSound("zrush_sfx_refine")
	self:StopParticles()
end