if SERVER then
	AddCSLuaFile()
end

if CLIENT then
	SWEP.Slot = 5
	SWEP.SlotPos = 100
	SWEP.DrawAmmo = false
	SWEP.DrawCrosshair = true
end

SWEP.Category = "Mapobjekte"
SWEP.PrintName = "Ölquellen Spawner"
SWEP.Author = "Modern Gaming"
SWEP.Instructions = "Linksklick um einen Ölquellen Spawner zu erschaffen.\nRechtsklick um einen Ölquellen Spawner zu löschen.\nR + E zum Regulieren des Radius."
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/weapons/c_pistol.mdl")
SWEP.WorldModel = Model("models/weapons/w_pistol.mdl")

SWEP.Primary.Delay = 2
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = ""
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = ""

SWEP.Radius = 1000

function SWEP:SetupDataTables()
	self:NetworkVar("Int", 0, "Radius")
	self:SetRadius(self.Radius)
end

local ShootSound = Sound("Metal.SawbladeStick")
local function DoEffect(self, tr)
	sound.Play(ShootSound, tr.HitPos)
	local ed = EffectData()
	ed:SetOrigin(tr.HitPos)
	ed:SetNormal(tr.HitNormal)
	ed:SetScale(2)
	ed:SetMagnitude(3)
	util.Effect("ElectricSpark", ed, true, true)
end

function SWEP:PrimaryAttack()
	if !SERVER then return end

	if !MG_DeveloperGroups[self.Owner:GetUserGroup()] then DarkRP.notify(self.Owner, 1, 4, "Rang zu niedrig.") return end

	local trace = self.Owner:GetEyeTrace()
	local ent = trace.Entity

	if ent:IsPlayer() then return end
	local tool_Radius = self:GetRadius()

	if (!ent:IsValid() or ent:IsWorld()) then
		--This prevents the creation of Spawner that are too close to others
		local distance
		local pos = trace.HitPos

		for a, b in ipairs(ents.FindByClass("zrush_oilspot_generator")) do
			if zrush.f.InDistance(pos, b:GetPos(), 100) then
				distance = true
				zrush.f.Notify(self:GetOwner(), "Zu nah an anderem Ölquellen Spawner!", 1)
				break
			end
		end

		if distance then return false end

		local ent = ents.Create("zrush_oilspot_generator")
		if !IsValid(ent) then return end
		ent:SetPos(pos + Vector(0, 0, 1))
		ent:SetSpawnRadius(tool_Radius)
		ent:Spawn()

		zrush.f.Notify(self:GetOwner(), "Ölquellen Spawner erstellt!", 0)
		
		DoEffect(self, trace)

		return
	elseif (ent:GetClass() == "zrush_oilspot_generator") then

		ent:SetSpawnRadius(tool_Radius)
		zrush.f.Notify(self:GetOwner(), "Ölquellen Spawner aktualisiert!", 0)

		DoEffect(self, trace)

		return
	end
end

function SWEP:SecondaryAttack()
	if !SERVER then return end

	if !MG_DeveloperGroups[self.Owner:GetUserGroup()] then DarkRP.notify(self.Owner, 1, 4, "Rang zu niedrig.") return end

	for a, b in ipairs(ents.FindByClass("zrush_oilspot_generator")) do
		b:SetNotSolid(false)
	end

	local trace = self.Owner:GetEyeTrace()
	local ent = trace.Entity

	if ent:IsPlayer() then return end

	if (ent:GetClass() == "zrush_oilspot_generator" or ent:GetClass() == "zrush_oilspot") then
		ent:Remove()
		zrush.f.Notify(self:GetOwner(), "Ölquellen Spawner entfernt!", 0)
		
		DoEffect(self, trace)

		return
	end

	for a, b in ipairs(ents.FindByClass("zrush_oilspot_generator")) do
		b:SetNotSolid(true)
	end
end

function SWEP:Reload()
	if (self.NextEdit or 0) > CurTime() then return end
	self.NextEdit = CurTime() + 0.1
	self:SetRadius(math.max(100, self:GetRadius() + (self.Owner:KeyDown(IN_USE) and -100 or 100)))
end

function SWEP:DrawHUD()
	local scrw, scrh = ScrW() / 2, ScrH() - 110
	draw.SimpleTextOutlined("Reichweite: "..self:GetRadius(), "mg_instructions", scrw, scrh + 10, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	draw.SimpleTextOutlined("R + E zum Regulieren.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
end