zrush = zrush or {}
zrush.config = zrush.config or {}
zrush.f = zrush.f or {}

/////////////////////////////////////////////////////////////////////////////

// Version MG



// General
///////////////////////
zrush.config.Debug = false

// What language do we want? en,de,hu,fr,es,pl,cn,ru,it,dk
zrush.config.selectedLanguage = "de"

// The Currency
zrush.config.Currency = "$"

// The Unit of Measurement
zrush.config.UoM = "l" // liter

// These Jobs are allowed to sell fuel, Leave empty to allow everyone to sell fuel
zrush.config.Jobs = {
	[TEAM_REFFINERY] = true
}

// Player Config
zrush.config.Player = {
	// Should the player drop all of the Fuel Barrels he has in his Zrush inventory when he dies?
	DropFuelOnDeath = true,

	// How many barrels can the player transport in his inventory?
	FuelInvSize = 150
}

// This jams or over heats the machines
// The chance of a machine getting hit by a chaos event can be reduced by the correct boost models
zrush.config.ChaosEvents = {
	// How often should we try to send chaos events to the machine
	Interval = 40,

	// How long till a machine can receive a chaos event again
	Cooldown = 120,
}

// The money you get when you sell your machines or modules again
zrush.config.SellValue = 0.5 // You get 50% of the original price

// The system which is used do place machines
zrush.config.MachineBuilder = {

	// See http://wiki.garrysmod.com/page/Enums/BUTTON_CODE

	// The Button which complets the action
	AcceptKey = "+attack",
	AcceptKeyName = "M1",

	// The Button which cancels the action
	CancelKey = "+attack2",
	CancelKeyName = "M2",
}

// How should the drilling work?
// 0 = The DrillTower dont needs a oilspots and can be placed everywhere
// 1 = The DrillTower can only be placed on OilSpots and OilSpots Refresh after use (OilSpots need do be placed by an Admin)
// 2 = The DrillTower can only be placed on OilSpots which get created at random by a OilSpot Generator. (OilSpot Generator need do be placed by an Admin)
zrush.config.Drill_Mode = 2

// The Fuel Buyer data
zrush.config.FuelBuyer = {

	// 1 = Barrels can be absorbed and sold by the NPC
	// 2 = Barrels need to be moved to the NPC and sold directly
	SellMode = 1,

	// The Model
	Model = "models/barney.mdl",

	// The Dialogbox Image
	NotifyImage = "models/barney.mdl",

	// How often should the fuel marked change in seconds
	RefreshRate = 480,

	//% The Max Sell Multiplicator you can get (100 is the Base Price, More means + Profit, Less means - Profit)
	MaxBuyRate = 140,

	//% The Min Sell Multiplicator you can get
	MinBuyRate = 60,

	// Just to give them a little Character :I
	Name = "Big Jim",
}

///////////////////////



// OilSpots
///////////////////////
zrush.config.OilSpot = {

	// This is the time in seconds a oilspot is gonna wait after it was closed before it can get drilled again or before it gets removed
	Cooldown = 60,
}

zrush.config.OilSpot_Generator = {
	// The rate in seconds the generator tries do spawn a new OilSpot if possible
	Rate = 60,

	// The Max count of valid oilspots a generator can have
	MaxOilSpots = 6,

	// This is the max time in seconds a oilspot is gonna wait before it gets removed again if its not used by a Player
	MaxLifeTime = 600,

	// This is the max search count per interval, meaning the generator trys this often do find a valid space for a oilspot before it stops
	MaxSearchPosCount = 25,
}
///////////////////////
