local PANEL = {}
function PANEL:Init()
	self:SetText("")
	self.Status = "idle"
	self.Text = ""
	self.Font = "Party_Treb_S20"
	self.BoarderWidth = 1
	self.Anim_Hover = 1
	self.Anim_Exit = 1
	self.Anim_Click = 1
	self.EventTime = nil
	self.HoverAnimTime = 0.3
	self.ClickSound = "ui/buttonclick.wav"
	self.AlignX = TEXT_ALIGN_CENTER
	self.AlignY = TEXT_ALIGN_CENTER
	self.FXCol = Color(255, 255, 255, 255)
end

function PANEL:CursorEnter()
end

function PANEL:CursorExit()
end

function PANEL:OnCursorEntered()
	self.EventTime = {Time = CurTime(), Mode = "HoverPer"}
	self:CursorEnter()
end

function PANEL:OnCursorExited()
	if self.NoExit then self.NoExit = nil return end
	self:CursorExit()
	local Time = CurTime() + self.HoverAnimTime
	if self.EventTime and self.EventTime.Time then
		if CurTime() - self.EventTime.Time < self.HoverAnimTime then
			Time = CurTime() + (CurTime() - self.EventTime.Time)
		end
	end
	self.EventTime = {Time = Time, Mode = "HoverPer_Exit"}
end

function PANEL:DoClick()
	surface.PlaySound(self.ClickSound)
	self.EventTime = {Time = CurTime(), Mode = "Click"}
	self:Click()
	self.NoExit = true
	return
end

function PANEL:SetTextAlign(X, Y)
	if X then
		self.AlignX = X
	end
	if Y then
		self.AlignY = Y
	end
end
function PANEL:SetTexts(name)
	self.Text = name
end

function PANEL:SetBoarderWidth(int)
	self.BoarderWidth = int
end

function PANEL:SetBoarderColor(color)
	self.BoarderCol = color
end

function PANEL:SetHoverAnim(int)
	self.Anim_Hover = int
end

function PANEL:SetExitAnim(int)
	self.Anim_Exit = int
end

function PANEL:SetClickAnim(int)
	self.Anim_Click = int
end

function PANEL:PaintBackGround()
end

function PANEL:PaintOverlay()
end

function PANEL:Paint(wide, height)
	draw.RoundedBox(6, 0, 0, wide, height, Color(50, 50, 50, 255))
	self:PaintBackGround()
	local col = self.FXCol
	if self.EventTime and self.EventTime.Time and self.EventTime.Mode then
		local mode = self.EventTime.Mode
		if mode == "HoverPer" then
			local per = CurTime() - self.EventTime.Time
			local d = math.min(per, self.HoverAnimTime) * 4
			draw.RoundedBox(6, 1, 1, (wide - 2), height - 2, Color(col.r, col.g, col.b, d * 10))
		end
		if mode == "HoverPer_Exit" then
			local per = self.EventTime.Time - CurTime()
			local d = math.max(per, 0) * 4
			draw.RoundedBox(6, 1, 1, (wide - 2), height - 2, Color(col.r, col.g, col.b, d * 10))
		end
		if mode == "Click" then
			local per = CurTime() - self.EventTime.Time
			local d = 1-math.min(per * 4, 1)
			draw.RoundedBox(6, 1, 1, (wide - 2), height - 2, Color(col.r, col.g, col.b, d * 40))
		end
	end
	local pos_x = wide / 2
	local pos_y = height / 2
	local align_x = self.AlignX
	if align_x == TEXT_ALIGN_LEFT then
		pos_x = 10
	end
	if align_x == TEXT_ALIGN_RIGHT then
		pos_x = wide - 10
	end
	if align_x == TEXT_ALIGN_TOP then
		pos_y = 1
	end
	if align_x == TEXT_ALIGN_BOTTOM then
		pos_y = height - 1
	end
	draw.SimpleText(self.Text, self.Font, pos_x, pos_y, self.TextCol, align_x, self.AlignY)
	self:PaintOverlay()
end

function PANEL:Click()
end
vgui.Register("Party_DSWButton", PANEL, "DButton")