function Party_OpenPanel()
	Party_ClosePanel()
	PartyList_Panel = vgui.Create("PartyList_Panel")
	PartyList_Panel:SetSize(ScrW()*0.6, ScrH()*0.6)
	PartyList_Panel:Install()
	PartyList_Panel:Center()
	PartyList_Panel:MakePopup()
	PartyList_Panel:ParentToHUD()
end

function Party_ClosePanel()
	if IsValid(PartyList_Panel) then
		PartyList_Panel:Remove()
	end
end

local PANEL = {}
function PANEL:Paint()
	local wide = self:GetWide()
	local height = self:GetTall()
	surface.SetDrawColor(Color(40, 40, 40, 255))
	surface.DrawRect(0, 0, wide, height)
	surface.SetDrawColor(Color(30, 30, 30, 255))
	surface.DrawRect(0, 0, wide, 40)
	surface.SetDrawColor(Color(20, 20, 20, 255))
	surface.DrawRect(0, 37, wide, 3)
	surface.SetDrawColor(Color(30, 30, 30, 255))
	surface.DrawRect(0, height - 40, wide, 40)
	surface.SetDrawColor(Color(20, 20, 20, 255))
	surface.DrawRect(0, height - 40, wide, 3)
	draw.SimpleText("Party", "Party_Treb_S34", 30, 20 , Color(255, 255, 255, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
end

function PANEL:Init()
	self:SetTitle("")
	self:ShowCloseButton(false)
	self:SetDraggable(false)
end

function PANEL:Install()
	local PartyList = vgui.Create("DPanel", self)
	PartyList:SetPos(10, 45)
	PartyList:SetSize(self:GetWide() * 0.4, 30)
	PartyList.Paint = function(slf)
		draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(25, 25, 25, 255))
		draw.SimpleText("Partyliste", "Party_Treb_S24", slf:GetWide() / 2, slf:GetTall() / 2 , Color(255, 255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	self.PartyList = vgui.Create("DPanelList", self)
	self.PartyList:SetPos(10, 80)
	self.PartyList:SetSize(self:GetWide() * 0.4, self:GetTall() - 130)
	self.PartyList:SetSpacing(2)
	self.PartyList:SetPadding(5)
	self.PartyList:EnableVerticalScrollbar(true)
	self.PartyList:EnableHorizontal(false)
	self.PartyList.Paint = function(slf)
		draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(25, 25, 25, 255))
	end
	self.PartyInfoPanel = vgui.Create("DPanelList", self)
	self.PartyInfoPanel:SetPos(10 + self.PartyList:GetWide() + 15, 45)
	self.PartyInfoPanel:SetSize(self:GetWide() - (self.PartyList:GetWide() + 40), self:GetTall() - 95)
	self.PartyInfoPanel:SetSpacing(2)
	self.PartyInfoPanel:SetPadding(2)
	self.PartyInfoPanel:EnableVerticalScrollbar(true)
	self.PartyInfoPanel:EnableHorizontal(false)
	self.PartyInfoPanel.Paint = function(slf)
		draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(25, 25, 25, 255))
	end

	function self.PartyInfoPanel:AddTitle(text)
		local Title = vgui.Create("DPanel")
		Title:SetSize(self:GetWide(), 30)
		Title.Paint = function(slf)
			draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(40, 40, 40, 255))
			draw.SimpleText(text, "Party_Treb_S24", slf:GetWide() / 2, slf:GetTall() / 2 , Color(255, 255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
		self:AddItem(Title)
	end

	function self.PartyInfoPanel:AddLabel(text, left)
		local Label = vgui.Create("DPanel")
		Label:SetSize(self:GetWide(), 24)
		Label.Text = text
		Label.Paint = function(slf)
			draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(30, 30, 30, 255))
			if left then
				draw.SimpleText(slf.Text, "Party_Treb_S20", 10, slf:GetTall() / 2, slf.Color, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			else
				draw.SimpleText(slf.Text, "Party_Treb_S20", slf:GetWide() / 2, slf:GetTall() / 2, slf.Color, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			end
		end
		self:AddItem(Label)
		return Label
	end

	function self.PartyInfoPanel:AddSpace(tall)
		tall = tall or 20
		local Space = vgui.Create("DPanel")
		Space:SetSize(self:GetWide(), tall)
		Space.Paint = function(slf)
		end
		self:AddItem(Space)
	end

	function self.PartyInfoPanel:AddEntry()
		local BG = vgui.Create("DPanel")
		BG:SetSize(self:GetWide(), 30)
		BG.Paint = function(slf)
			draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(30, 30, 30, 255))
			draw.SimpleText("Name -> ", "Party_Treb_S20", 10, slf:GetTall() / 2 , Color(255, 255, 255, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.RoundedBox(6, 100, 5, slf.Entry:GetWide(), slf.Entry:GetTall(), Color(35, 35, 35, 255))
		end
		local Entry = vgui.Create("DTextEntry", BG)
		BG.Entry = Entry
		Entry:SetValue("")
		Entry:SetPos(100, 5)
		Entry:SetSize(self:GetWide() - 110, 20)
		Entry:SetAllowNonAsciiCharacters(true)
		Entry:SetTextColor(Color(200, 200, 200, 255))
		Entry:SetDrawBackground(false)
		Entry:SetEnterAllowed(false)
		Entry:SetCursorColor(Color(255, 255, 255, 255))
		Entry:RequestFocus()
		self:AddItem(BG)
		return Entry
	end

	function self.PartyInfoPanel:AddButton(text, FunC)
		local BG = vgui.Create("DPanel")
		BG:SetSize(self:GetWide(), 50)
		BG.Paint = function(slf)
			draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(30, 30, 30, 255))
		end
		local Entry = vgui.Create("DButton", BG)
		Entry:SetText("")
		Entry:SetPos(BG:GetWide()/2 - 100, 5)
		Entry:SetSize(200, 40)
		Entry.Paint = function(slf)
			draw.RoundedBox(6, 0, 0, slf:GetWide(), slf:GetTall(), Color(40, 40, 40, 255))
			draw.SimpleText(text, "Party_Treb_S24", slf:GetWide() / 2, slf:GetTall() / 2 , Color(255, 255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
		Entry.DoClick = function(slf)
			surface.PlaySound("ui/buttonclick.wav")
			if FunC then
				FunC()
			end
		end
		self:AddItem(BG)
		return Entry
	end

	local Exit = vgui.Create("Party_DSWButton", self)
	Exit:SetPos(self:GetWide() - 102, 3)
	Exit:SetSize(98, 34)
	Exit:SetTexts("X")
	Exit.Click = function()
		Party_ClosePanel()
	end
	local Party_Create = vgui.Create("Party_DSWButton", self)
	Party_Create:SetPos(20, self:GetTall() - 35)
	Party_Create:SetSize(150, 30)
	Party_Create:SetTexts("Party erstellen")
	Party_Create:SetTooltip("Wird einem Spieler in einer Party von einem anderen Mitglied Schussschaden zugefügt, ist der Schaden verringert.")
	local ply = LocalPlayer()
	Party_Create.Click = function()
		if ply:HasParty() then return end
		self:UpdatePartyInfo("createparty")
	end
	local LeaveParty = vgui.Create("Party_DSWButton", self)
	LeaveParty:SetPos(200, self:GetTall() - 35)
	LeaveParty:SetSize(150, 30)
	LeaveParty:SetTexts("Party verlassen")
	LeaveParty.Think = function(slf)
		if ply:IsPartyMaster() then
			slf:SetTexts("Party auflösen")
		else
			slf:SetTexts("Party verlassen")
		end
	end
	LeaveParty.Click = function()
		if ply:HasParty() then
			Party_RunNetworkedConsoleCommand("Party_LeaveParty")
			self:UpdatePartyInfo("")
		end
	end
	local MyParty = vgui.Create("Party_DSWButton", self)
	MyParty:SetPos(380, self:GetTall() - 35)
	MyParty:SetSize(150, 30)
	MyParty:SetTexts("Meine Party")
	MyParty.Click = function()
		if ply:HasParty() then
			self:UpdatePartyInfo("partyinfo", ply:GetCurrentPartyNumber())
		end
	end
	self:UpdatePartyList()
end
vgui.Register("PartyList_Panel", PANEL, "DFrame")

function PANEL:UpdatePartyList()
	self.PartyList:Clear()
	local max_players = PartySystem.MaxPartyPlayerAmount
	for num, party in pairs(PartyList or {}) do
		local SButton = vgui.Create("DButton")
		SButton:SetSize(self.PartyList:GetWide(), 50)
		SButton:SetText("")
		SButton.Paint = function(slf)
			local wide = slf:GetWide()
			local height = slf:GetTall()
			if slf:IsHovered() then
				draw.RoundedBox(6, 0, 0, wide, height, Color(50, 50, 50, 255))
			else
				draw.RoundedBox(6, 0, 0, wide, height, Color(40, 40, 40, 255))
			end
			draw.SimpleText("Nr."..num, "Party_Treb_S25", 10, 2 , Color(255, 255, 255, 255), draw.TEXT_ALIGN_LEFT, draw.TEXT_ALIGN_TOP)
			draw.SimpleText(party.PrintName, "Party_Treb_S25", wide - 10, 2 , Color(255, 255, 255, 255), draw.TEXT_ALIGN_RIGHT, draw.TEXT_ALIGN_TOP)
			draw.SimpleText("Spieler: "..table.Count(party.Players or {}).." / "..max_players, "Party_Treb_S20", wide - 10, height - 5 , Color(100, 200, 255, 255), draw.TEXT_ALIGN_RIGHT, draw.TEXT_ALIGN_BOTTOM)
		end
		SButton.DoClick = function()
			surface.PlaySound("ui/buttonclick.wav")
			self:UpdatePartyInfo("partyinfo", num)
		end
		self.PartyList:AddItem(SButton)
	end
end

function PANEL:UpdatePartyInfo(mode, num)
	self.CurPartyInfoMode = mode
	self.CurPartyNum = num
	self.PartyInfoPanel:Clear()
	local ply = LocalPlayer()
	if mode == "partyinfo" then
		local partydata = PartyList[num]
		if !partydata then return end
		self.PartyInfoPanel:AddTitle("Party-Informationen")
		self.PartyInfoPanel:AddLabel("Party-Name: "..(partydata and partydata.PrintName).." (Nr. "..num..")", true)
		if IsValid(partydata.Master) then
			self.PartyInfoPanel:AddLabel("Leiter: "..partydata.Master:Name(), true)
		end
		self.PartyInfoPanel:AddLabel("Spieler: ("..(partydata and table.Count(partydata.Players or {})).." / "..PartySystem.MaxPartyPlayerAmount..")", true)
		self.PartyInfoPanel:AddSpace(20)
		self.PartyInfoPanel:AddTitle("Optionen")
		if !ply:HasParty() then
			self.PartyInfoPanel:AddButton("Party beitreten", function(slf)
				if ply:HasParty() then return end
				Party_RunNetworkedConsoleCommand("Party_AskJoinParty", num)
				self:UpdatePartyInfo("")
			end)
		end
		if partydata.Master == ply then
			self.PartyInfoPanel:AddButton("Party-Name editieren", function(slf)
				if !ply:HasParty() then return end
				self:UpdatePartyInfo("nameedit")
			end)
			self.PartyInfoPanel:AddButton("Spieler einladen", function(slf)
				if !ply:HasParty() then return end
				if IsValid(plist) then plist:Remove() end
				local target
				local plist = DermaMenu(self)
				local players = player.GetAll()
				table.sort(players, function(a, b) return a:Name() < b:Name() end)
				for _, v in ipairs(players) do
					if ply != v then
						if v:HasParty() then continue end
						plist:AddOption(v:Name(), function()
							if IsValid(v) then
								Party_RunNetworkedConsoleCommand("Party_InvitePlayer", v:EntIndex())
							end
						end)
					end
				end
				plist:Open()
			end)
		end
		self.PartyInfoPanel:AddSpace(20)
		self.PartyInfoPanel:AddTitle("Spieler")
		for _, v in pairs(partydata.Players or {}) do
			if !IsValid(v) then continue end
			local Players = vgui.Create("DButton")
			Players:SetSize(self.PartyInfoPanel:GetWide(), 40)
			Players:SetText("")
			Players.Paint = function(slf)
				if !IsValid(v) then return end
				draw.RoundedBox(0, 0, 0, slf:GetWide(), 50, Color(60, 60, 60, 255))
				if v == partydata.Master then
					draw.SimpleText("Leiter: "..v:Name(), "Party_Treb_S20", 30, 20, Color(100, 255, 255, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				else
					draw.SimpleText("Spieler: "..v:Name(), "Party_Treb_S20", 30, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				end
			end
			Players.DoClick = function(slf)
				if v then
					local menu = DermaMenu()
					if ply == partydata.Master and v != partydata.Master then
						menu:AddOption("Leiterberechtigungen geben", function()
							Party_RunNetworkedConsoleCommand("Party_ChangePartyMaster", v:EntIndex())
						end)
						menu:AddOption("Rauswerfen", function()
						Party_RunNetworkedConsoleCommand("Party_KickOut", v:EntIndex())
						end)
					end
					menu:Open()
				end
			end
			self.PartyInfoPanel:AddItem(Players)
		end
	end
	if mode == "nameedit" then
		self.PartyInfoPanel:AddTitle("Party-Namen editieren")
		self.PartyInfoPanel:AddLabel("Party-Informationen bearbeiten")
		self.PartyInfoPanel:AddSpace(10)
		self.PartyInfoPanel:AddTitle("Party-Namen eintragen")
		local Entry = self.PartyInfoPanel:AddEntry()
		local Checker = self.PartyInfoPanel:AddLabel("")
		Checker.Think = function(slf)
			local length = #Entry:GetValue()
			if length < PartySystem.MinPartyNameLength then
				slf.Text = "Name zu kurz!"
				slf.Color = Color(255, 0, 0)
				slf.CanCreate = false
			elseif length > PartySystem.MaxPartyNameLength then
				slf.Text = "Name zu lang!"
				slf.Color = Color(255, 0, 0)
				slf.CanCreate = false
			else
				slf.Text = "Erlaubt!"
				slf.Color = Color(0, 255, 0)
				slf.CanCreate = true
			end
		end
		self.PartyInfoPanel:AddSpace(10)
		self.PartyInfoPanel:AddButton("Speichern", function()
			if Checker.CanCreate then
				Party_RunNetworkedConsoleCommand("Party_EditParty", Entry:GetValue())
				self:UpdatePartyInfo("")
			end
		end)
	end
	if mode == "createparty" then
		self.PartyInfoPanel:AddTitle("Party erstellen")
		self.PartyInfoPanel:AddLabel("Party-Informationen bearbeiten")
		self.PartyInfoPanel:AddSpace(10)
		self.PartyInfoPanel:AddTitle("Party-Namen eintragen")
		local Entry = self.PartyInfoPanel:AddEntry()
		local Checker = self.PartyInfoPanel:AddLabel("")
		Checker.Think = function(slf)
			local length = #Entry:GetValue()
			if length < PartySystem.MinPartyNameLength then
				slf.Text = "Name zu kurz!"
				slf.Color = Color(255, 0, 0)
				slf.CanCreate = false
			elseif length > PartySystem.MaxPartyNameLength then
				slf.Text = "Name zu lang!"
				slf.Color = Color(255, 0, 0)
				slf.CanCreate = false
			else
				slf.Text = "Erlaubt!"
				slf.Color = Color(0, 255, 0)
				slf.CanCreate = true
			end
		end
		self.PartyInfoPanel:AddSpace(10)
		self.PartyInfoPanel:AddButton("Party erstellen", function()
			if Checker.CanCreate then
				Party_RunNetworkedConsoleCommand("Party_CreateParty", Entry:GetValue())
				self:UpdatePartyInfo("")
			end
		end)
	end
end