PartyList = {}

function Party_RunNetworkedCommand(name, func)
	if SERVER then
		util.AddNetworkString(name)
	end
	net.Receive(name, function(len, ply)
		local str = net.ReadString()
		local args = string.Explode(" ", str)
		func(ply, "any", args)
	end)
end

function Party_RunNetworkedConsoleCommand(name, ...)
	local x = {...}
	local str = string.Implode(" ", x)
	net.Start(name)
		net.WriteString(str)
	net.SendToServer()
end

if CLIENT then
	CreateClientConVar("cl_ignorepartyasks", 0, FCVAR_ARCHIVE)
end
Party_RunNetworkedCommand("Party_AskJoinParty", function(ply, cmd, args)
	if !CLIENT or !args or !args[1] or GetConVar("cl_ignorepartyasks"):GetBool() then return end
	local ply = LocalPlayer()
	if !ply:GetParty() then return end
	local receiver = ents.GetByIndex(args[1])
	if !IsValid(receiver) or !receiver:IsPlayer() then return end
	if table.Count(ply:GetParty().Players or {}) >= PartySystem.MaxPartyPlayerAmount then
		chat.AddText(Color(255, 50, 50), "Diese Party ist bereits voll!")
		return
	end
	local panel = Party_CreateRequestPanel()
	panel.InParty = false
	panel.Player = receiver
	panel.PlayerName = receiver:Name()
	panel.TextData = "möchte deiner Party beitreten."
	panel.AcceptFunction = function()
		Party_RunNetworkedConsoleCommand("Party_AcceptRequest", receiver:EntIndex())
	end
end)

if CLIENT then
	local ignoreinvites = CreateClientConVar("cl_ignorepartyinvites", 0, FCVAR_ARCHIVE)
end

Party_RunNetworkedCommand("Party_ShowInviteMenu", function(ply, cmd, args)
	if !CLIENT or !args or !args[1] or GetConVar("cl_ignorepartyinvites"):GetBool() then return end
	local sender = ents.GetByIndex(args[1])
	if !IsValid(sender) or !sender:IsPlayer() then return end
	local panel = Party_CreateRequestPanel()
	panel.InParty = true
	panel.Player = sender
	panel.PlayerName = sender:Name()
	panel.TextData = "lädt dich in seine Party ein."
	panel.AcceptFunction = function() 
		Party_RunNetworkedConsoleCommand("Party_AcceptInvite", sender:EntIndex())
	end
end)

if CLIENT then
	net.Receive("Party_ClrMsg", function()
		local text = net.ReadTable()

		chat.AddText(unpack(text))
	end)
else
	util.AddNetworkString("Party_ClrMsg")

	function Party_ColoredMessage(ply, ...)
		net.Start("Party_ClrMsg")
			net.WriteTable({...})
		net.Send(ply)
	end
end