surface.CreateFont("PoliceRadio_VoiceChatter", {font = "Roboto Th", size = 24, weight = 400, antialias = true, underline = false})
surface.CreateFont("PoliceRadio_VoiceChatterS", {font = "Roboto Th", size = 18, weight = 400, antialias = true, underline = false})

local talking_plys = {}
local in_vehicle = false
hook.Add("PlayerStartVoice", "PoliceRadio_CreatePanel", function(ply)
	local local_ply = LocalPlayer()
	if !local_ply:IsValid() then return end
	local wep = local_ply:GetNWEntity("HasRadio")
	local wep2 = ply:GetNWEntity("HasRadio")
	if wep:IsValid() and wep2:IsValid() then
		if ply:GetActiveWeapon() != wep2 then return end
		if wep.GetDeviceStatus and wep:GetDeviceStatus() and !wep:GetDeviceMuted() and wep2.GetDeviceStatus and wep2:GetDeviceStatus() then
			local local_chan = local_ply:getDarkRPVar("channelID")
			local ply_chan = ply:getDarkRPVar("channelID")
			if local_chan and ply_chan and local_chan == ply_chan then
				table.insert(talking_plys, ply)
				ply.playerframe = vgui.Create("DFrame")
				ply.playerframe:SetSize(220, 50)
				ply.playerframe:SetPos(ScrW() - 255, 120 + (in_vehicle and 70 or 0) + 55 * (#talking_plys - 1))
				ply.playerframe:SetTitle("")
				ply.playerframe:ShowCloseButton(false)
				ply.playerframe.Paint = function(self, w, h)
					draw.RoundedBox(4, 0, 0, w, h, Color(255, 255, 255, 150))
				end
				ply.playername = vgui.Create("DLabel", ply.playerframe)
				ply.playername:SetText(ply:Name())
				ply.playername:SetFont("PoliceRadio_VoiceChatter")
				ply.playername:SetColor(Color(25, 25, 25))
				ply.playername:SetPos(65, 3)
				ply.playername:SetWidth(150)
				ply.playerjob = vgui.Create("DLabel", ply.playerframe)
				ply.playerjob:SetText(local_ply:getDarkRPVar("channelName"))
				ply.playerjob:SetColor(Color(25, 25, 25))	
				ply.playerjob:SetFont("PoliceRadio_VoiceChatter")
				ply.playerjob:SetPos(65, 25)
				ply.playerjob:SizeToContents()
				ply.modelicon = vgui.Create("SpawnIcon", ply.playerframe) 
				ply.modelicon:SetModel(ply:GetModel())
				ply.modelicon:SetPos(0, 0)
				ply.modelicon:SetSize(55, 50)
			end
		end
	end
end)

hook.Add("PlayerEndVoice", "PoliceRadio_ClosePanel", function(ply)
	if IsValid(ply.playerframe) then
		table.remove(talking_plys, table.KeyFromValue(talking_plys, ply))
		ply.playerframe:Close()
		ply.playerframe = nil
	end
end)

local local_ply, wep, chan, veh, veh_frame
local function RemoveHUD()
	in_vehicle = false
	if IsValid(veh_frame) then
		veh_frame:Remove()
	end
end

local function VehicleHUD()
	local_ply = local_ply or LocalPlayer()
	veh = local_ply:GetVehicle()
	if !IsValid(veh) then RemoveHUD() return end
	local class = veh:GetClass()
	if class != "prop_vehicle_jeep" and class != "prop_vehicle_jeep_old" and class != "prop_vehicle_airboat" then RemoveHUD() return end
	wep = local_ply:GetNWEntity("HasRadio")
	chan = local_ply:getDarkRPVar("channelName")
	if !wep:IsValid() or !wep:GetDeviceStatus() or !chan then RemoveHUD() return end
	in_vehicle = true
	if IsValid(veh_frame) then return end
	veh_frame = vgui.Create("DFrame")
	veh_frame:SetSize(220, 60)
	veh_frame:SetPos(ScrW() - 255, 120)
	veh_frame:SetTitle("")
	veh_frame:ShowCloseButton(false)
	veh_frame.Paint = function(self, w, h)
		if wep:IsValid() and wep:GetDeviceMuted() then
			draw.RoundedBox(4, 0, 0, w, h, Color(255, 0, 0, 150))
		else
			draw.RoundedBox(4, 0, 0, w, h, Color(0, 255, 0, 150))
		end
	end
	local radio_name = vgui.Create("DLabel", veh_frame)
	radio_name:SetText("Funkgerät")
	radio_name:SetFont("PoliceRadio_VoiceChatter")
	radio_name:SetColor(Color(25, 25, 25))
	radio_name:SetPos(5, 3)
	radio_name:SetWidth(210)
	local radio_chan = vgui.Create("DLabel", veh_frame)
	radio_chan:SetText("Sender: "..local_ply:getDarkRPVar("channelName"))
	radio_chan:SetFont("PoliceRadio_VoiceChatter")
	radio_chan:SetColor(Color(25, 25, 25))
	radio_chan:SetPos(5, 23)
	radio_chan:SetWidth(210)
	local radio_info = vgui.Create("DLabel", veh_frame)
	radio_info:SetText(", zum stummen/entstummen.")
	radio_info:SetFont("PoliceRadio_VoiceChatterS")
	radio_info:SetColor(Color(0, 0, 0))
	radio_info:SetPos(5, 30)
	radio_info:SetSize(210, 40)
end
hook.Add("HUDPaint", "PoliceRadio_VehicleHUD", VehicleHUD)

hook.Add("PlayerButtonDown", "PoliceRadio_VehicleMute", function(ply, button)
	if ply:InVehicle() and button == KEY_COMMA then
		RunConsoleCommand("policeradio_mutevehicle")
	end
end)